/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.exception.ValidationException;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.service.common.DatastoreHelper;
import com.google.apphosting.datastore.service.common.ValidationConstraint;
import com.google.apphosting.datastore.service.common.ValidationUtils;
import com.google.apphosting.datastore.shared.Config;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@VisibleForTesting
public abstract class BaseDatastoreValidator {
    protected Config.DatastoreConfig config;
    private final Set<ByteString> allowedReservedKindsBytes;

    protected BaseDatastoreValidator(Config.DatastoreConfig config) {
        this.config = config;
        ImmutableSet.Builder allowedReservedKindsBytesBuilder = ImmutableSet.builder();
        allowedReservedKindsBytesBuilder.addAll((Iterable)config.getReservedKindsToAllowList().asByteStringList());
        this.allowedReservedKindsBytes = allowedReservedKindsBytesBuilder.build();
    }

    public Config.DatastoreConfig getConfig() {
        return this.config;
    }

    public void validateKind(ValidationConstraint constraint, ByteString kind) throws ValidationException {
        this.validateStringNotEmpty(kind, "kind");
        this.validateLength(kind, this.config.getMaxIndexedValueBytes(), "kind");
        if (!constraint.allowReservedKey() && !this.allowedReservedKindsBytes.contains(kind)) {
            this.validateStringNotReserved(kind, "kind");
        }
    }

    public void validatePartitionIdDimensionBytes(ByteString value, String dimension) throws ValidationException {
        this.validateLength(value, 100, dimension);
        ValidationUtils.INSTANCE.validateStringUtf8(value, dimension);
    }

    protected void validatePartitionIdDimension(ValidationConstraint constraint, String value, String dimension) throws ValidationException {
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(value, dimension);
        }
        ValidationException.validateAssertion(DatastoreHelper.PARTITION_ID_REGEX.matcher(value).matches(), "Illegal string \"%s\" in %s.", value, dimension);
    }

    public void validateAppId(ValidationConstraint constraint, String appId) throws ValidationException {
        ValidationException.validateAssertion(!appId.isEmpty(), "The app id is the empty string.", new Object[0]);
        this.validateAppOrProjectId(constraint, DatastoreHelper.APP_ID_REGEX, appId, "app id");
    }

    public void validateProjectId(ValidationConstraint constraint, String projectId) throws ValidationException {
        this.validateAppOrProjectId(constraint, DatastoreHelper.PROJECT_ID_REGEX, projectId, "project id");
    }

    protected void validateAppOrProjectId(ValidationConstraint constraint, Pattern appOrProjectIdPattern, String appOrProjectId, String desc) throws ValidationException {
        Matcher matcher = appOrProjectIdPattern.matcher(appOrProjectId);
        ValidationException.validateAssertion(matcher.matches(), "\"%s\" is an invalid %s.", appOrProjectId, desc);
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(matcher.group("project"), desc);
        }
    }

    public void validatePropertyName(ValidationConstraint constraint, ByteString propertyName) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, "");
    }

    public void validatePropertyName(ValidationConstraint constraint, ByteString propertyName, String desc) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, 0, desc);
    }

    public void validatePropertyName(ValidationConstraint constraint, ByteString propertyName, int prefixLength, String desc) throws ValidationException {
        String string = desc = desc.isEmpty() ? "property.name" : String.valueOf(desc).concat(".property.name");
        if (prefixLength > 0) {
            String string2 = String.valueOf(desc);
            desc = string2.length() != 0 ? "flattened ".concat(string2) : new String("flattened ");
        }
        this.validateStringNotEmpty(propertyName, desc);
        this.validateLength(propertyName.size() + prefixLength, this.config.getMaxIndexedValueBytes(), desc);
        boolean isKeyProperty = Arrays.equals(propertyName.toByteArray(), SpecialPropertyDescriptor.KEY.getPropertyNameAsByteArray());
        if (!(constraint.allowReservedName() || constraint.allowKeyPropertyName() && isKeyProperty)) {
            this.validateStringNotReserved(propertyName, desc);
        }
        if (!constraint.allowPathDelimiterInPropertyName()) {
            ValidationException.validateAssertion(!Iterables.contains((Iterable)propertyName, (Object)46), "%s contains a path delimiter, and the entity contains one or more indexed entity value.", desc);
        }
    }

    public void validateKeyPathString(ValidationConstraint constraint, ByteString pathElement, String desc) throws ValidationException {
        this.validateStringNotEmpty(pathElement, desc);
        this.validateLength(pathElement, this.config.getMaxIndexedValueBytes(), desc);
        if (!constraint.allowReservedName()) {
            this.validateStringNotReserved(pathElement, desc);
        }
    }

    public void validateStringNotReserved(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!RepHelper.isNameReserved(string), "The %s \"%s\" is reserved.", desc, string);
    }

    public void validateStringNotReserved(ByteString string, String desc) throws ValidationException {
        if (RepHelper.isNameReserved(string)) {
            ValidationException.validateAssertion(false, "The %s \"%s\" is reserved.", desc, string.toStringUtf8());
        }
    }

    public void validateStringNotEmpty(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateStringNotEmpty(ByteString string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateLength(ByteString byteString, int maxLength, String desc) throws ValidationException {
        this.validateLength(byteString.size(), maxLength, desc);
    }

    private void validateLength(int length, int maxLength, String desc) throws ValidationException {
        ValidationException.validateAssertion(length <= maxLength, "The %s is longer than %d bytes.", desc, maxLength);
    }

    public void validateSameApp(String app1, String app2) throws ValidationException {
        Preconditions.checkNotNull((Object)app1);
        Preconditions.checkNotNull((Object)app2);
        ValidationException.validateAssertion(app1.equals(app2), "%s%s vs. %s", "mismatched app ids within request: ", app1, app2);
    }

    public void validateGeoPoint(double lat, double lon) throws ValidationException {
        ValidationException.validateAssertion(Math.abs(lat) <= 90.0, "Geo point latitude outside permitted range -90.0 to 90.0.", new Object[0]);
        ValidationException.validateAssertion(Math.abs(lon) <= 180.0, "Geo point longitude outside permitted range -180.0 to 180.0.", new Object[0]);
    }
}

