/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalConnection;
import com.google.appengine.api.rdbms.dev.LocalMetadata;
import com.google.appengine.api.rdbms.dev.LocalRdbms;
import com.google.appengine.api.rdbms.dev.LocalRdbmsProperties;
import com.google.appengine.api.rdbms.dev.LocalRdbmsService;
import com.google.appengine.api.rdbms.dev.Util;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalRdbmsServiceLocalDriver
extends AbstractLocalRpcService
implements LocalRdbms {
    private static final Logger logger = Logger.getLogger(LocalRdbmsServiceLocalDriver.class.getCanonicalName());
    LocalRdbmsProperties properties;
    private final AtomicLong nextConnectionId = new AtomicLong(0L);
    final ConcurrentHashMap<String, LocalConnection> connectionMap = new ConcurrentHashMap();

    public String getPackage() {
        throw new IllegalStateException("getPackage() not expected on this delegate");
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.properties = new LocalRdbmsProperties(properties);
        this.registerDriver();
    }

    private void registerDriver() throws IllegalStateException {
        try {
            String driverName = this.properties.getDriverClassName();
            if (driverName == null) {
                throw new IllegalStateException(MessageFormat.format("System property {0} must be set.", "rdbms.driver"));
            }
            Class<Driver> driverClass = Class.forName(driverName).asSubclass(Driver.class);
            try {
                DriverManager.registerDriver(driverClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        catch (ClassNotFoundException e1) {
            throw new IllegalStateException(e1);
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            for (Map.Entry<String, LocalConnection> entry : this.connectionMap.entrySet()) {
                String string = entry.getKey();
                logger.logp(Level.WARNING, "com.google.appengine.api.rdbms.dev.LocalRdbmsServiceLocalDriver", "stop", new StringBuilder(44 + String.valueOf(string).length()).append("java.sql.Connection with id ").append(string).append(" was not closed.").toString());
                try {
                    entry.getValue().close();
                }
                catch (SQLException e) {
                    String string2 = String.valueOf(entry.getKey());
                    logger.logp(Level.WARNING, "com.google.appengine.api.rdbms.dev.LocalRdbmsServiceLocalDriver", "stop", string2.length() != 0 ? "Unable to close java.sql.Connection with id ".concat(string2) : new String("Unable to close java.sql.Connection with id "), e);
                }
            }
        }
        finally {
            this.connectionMap.clear();
        }
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 60.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 60.0;
    }

    public Integer getMaxApiRequestSize() {
        return LocalRdbmsService.MAX_API_REQUEST_SIZE;
    }

    @Override
    public OpenConnectionResponse openConnection(LocalRpcService.Status status, OpenConnectionRequest request) {
        try {
            Map<String, String> requestPropertyMap = Util.toPropertyMap(request.getPropertyList());
            Map<String, String> overriddenRequestPropertyMap = Util.getConnectionProperties(this.properties, requestPropertyMap);
            Connection conn = DriverManager.getConnection(this.properties.getUrl(), Util.asProperties(Util.concat(overriddenRequestPropertyMap, this.properties.getExtraProperties())));
            String database = Util.getDatabase(overriddenRequestPropertyMap);
            if (database != null && !database.isEmpty()) {
                conn.setCatalog(database);
            }
            long connectionId = this.nextConnectionId.getAndIncrement();
            String string = String.valueOf(request.getInstance());
            this.connectionMap.put(new StringBuilder(20 + String.valueOf(string).length()).append(string).append(connectionId).toString(), LocalConnection.create(conn));
            return OpenConnectionResponse.newBuilder().setConnectionId(ByteString.copyFromUtf8((String)Long.toString(connectionId))).build();
        }
        catch (SQLException e) {
            logger.logp(Level.SEVERE, "com.google.appengine.api.rdbms.dev.LocalRdbmsServiceLocalDriver", "openConnection", "Could not allocate a connection", e);
            return OpenConnectionResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
    }

    @Override
    public CloseConnectionResponse closeConnection(LocalRpcService.Status status, CloseConnectionRequest request) {
        String string = String.valueOf(request.getInstance());
        String string2 = String.valueOf(request.getConnectionId().toStringUtf8());
        LocalConnection conn = this.connectionMap.remove(string2.length() != 0 ? string.concat(string2) : new String(string));
        if (conn == null) {
            throw this.connectionNotFound();
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            return CloseConnectionResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
        return CloseConnectionResponse.newBuilder().build();
    }

    @Override
    public ExecResponse exec(LocalRpcService.Status status, ExecRequest request) {
        LocalConnection conn = this.getConnectionById(request.getInstance(), request.getConnectionId());
        return conn.exec(status, request);
    }

    @Override
    public ExecOpResponse execOp(LocalRpcService.Status status, ExecOpRequest request) {
        LocalConnection conn = this.getConnectionById(request.getInstance(), request.getConnectionId());
        return conn.execOp(status, request);
    }

    @Override
    public MetadataResponse getMetadata(LocalRpcService.Status status, MetadataRequest request) {
        return new LocalMetadata().getMetadata(status, request, this.getConnectionById(request.getInstance(), request.getConnectionId()));
    }

    private LocalConnection getConnectionById(String instance, ByteString connectionId) {
        String string = String.valueOf(instance);
        String string2 = String.valueOf(connectionId.toStringUtf8());
        LocalConnection conn = this.connectionMap.get(string2.length() != 0 ? string.concat(string2) : new String(string));
        if (conn == null) {
            throw this.connectionNotFound();
        }
        return conn;
    }

    ApiProxy.ApplicationException connectionNotFound() {
        return new ApiProxy.ApplicationException(1007, "Invalid connection id");
    }
}

