/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRectBase;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckReturnValue;

@GwtCompatible(serializable=true)
public strictfp final class S2LatLngRect
extends S2LatLngRectBase {
    private static final byte LOSSLESS_ENCODING_VERSION = 1;

    public static S2LatLngRect empty() {
        return new S2LatLngRect(R1Interval.empty(), S1Interval.empty());
    }

    public static S2LatLngRect full() {
        return new S2LatLngRect(S2LatLngRect.fullLat(), S2LatLngRect.fullLng());
    }

    public static R1Interval fullLat() {
        return new R1Interval(-1.5707963267948966, 1.5707963267948966);
    }

    public static S1Interval fullLng() {
        return S1Interval.full();
    }

    public static S2LatLngRect fromCenterSize(S2LatLng center, S2LatLng size) {
        return S2LatLngRect.fromPoint(center).expanded(size.mul(0.5));
    }

    public static S2LatLngRect fromPoint(S2LatLng p) {
        return new S2LatLngRect(p, p);
    }

    public static S2LatLngRect fromPointPair(S2LatLng p1, S2LatLng p2) {
        return new S2LatLngRect(R1Interval.fromPointPair(p1.lat().radians(), p2.lat().radians()), S1Interval.fromPointPair(p1.lng().radians(), p2.lng().radians()));
    }

    public static S2LatLngRect fromEdge(S2Point a, S2Point b) {
        double db;
        S2LatLngRect r = S2LatLngRect.fromPointPair(new S2LatLng(a), new S2LatLng(b));
        S2Point ab = S2.robustCrossProd(a, b);
        S2Point dir = S2Point.crossProd(ab, S2Point.Z_POS);
        double da = dir.dotProd(a);
        if (da * (db = dir.dotProd(b)) >= 0.0) {
            return r;
        }
        double absLat = Math.acos(Math.abs(ab.z / ab.norm()));
        if (da < 0.0) {
            return new S2LatLngRect(new R1Interval(r.lat().lo(), absLat), r.lng());
        }
        return new S2LatLngRect(new R1Interval(-absLat, r.lat().hi()), r.lng());
    }

    public S2LatLngRect(S2LatLng lo, S2LatLng hi) {
        super(lo, hi);
    }

    public S2LatLngRect(R1Interval lat, S1Interval lng) {
        super(lat, lng);
    }

    public S2LatLngRect(S2LatLngRectBase b) {
        this.lat.setLo(b.lat.lo());
        this.lat.setHi(b.lat.hi());
        this.lng.set(b.lng.lo(), b.lng.hi(), true);
    }

    @Override
    public final R1Interval lat() {
        return this.lat;
    }

    @Override
    public final S1Interval lng() {
        return this.lng;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @CheckReturnValue
    public S2LatLngRect addPoint(S2Point p) {
        return this.addPoint(new S2LatLng(p));
    }

    @CheckReturnValue
    public S2LatLngRect addPoint(S2LatLng ll) {
        R1Interval newLat = this.lat.addPoint(ll.lat().radians());
        S1Interval newLng = this.lng.addPoint(ll.lng().radians());
        return new S2LatLngRect(newLat, newLng);
    }

    @CheckReturnValue
    public S2LatLngRect expanded(S2LatLng margin) {
        return new S2LatLngRect(this.lat.expanded(margin.lat().radians()).intersection(S2LatLngRect.fullLat()), this.lng.expanded(margin.lng().radians()));
    }

    @CheckReturnValue
    public S2LatLngRect polarClosure() {
        if (this.lat.lo() == -1.5707963267948966 || this.lat.hi() == 1.5707963267948966) {
            return new S2LatLngRect(this.lat, S1Interval.full());
        }
        return this;
    }

    @CheckReturnValue
    public S2LatLngRect union(S2LatLngRectBase other) {
        return new S2LatLngRect(this.lat.union(other.lat), this.lng.union(other.lng));
    }

    @CheckReturnValue
    public S2LatLngRect intersection(S2LatLngRectBase other) {
        R1Interval intersectLat = this.lat.intersection(other.lat);
        S1Interval intersectLng = this.lng.intersection(other.lng);
        if (intersectLat.isEmpty() || intersectLng.isEmpty()) {
            return S2LatLngRect.empty();
        }
        return new S2LatLngRect(intersectLat, intersectLng);
    }

    @CheckReturnValue
    public S2LatLngRect convolveWithCap(S1Angle angle) {
        S2Cap cap = S2Cap.fromAxisAngle(S2Point.X_POS, angle);
        S2LatLngRect r = this;
        for (int k = 0; k < 4; ++k) {
            S2Cap vertexCap = S2Cap.fromAxisHeight(this.getVertex(k).toPoint(), cap.height());
            r = r.union(vertexCap.getRectBound());
        }
        return r;
    }

    public S2Region clone() {
        return new S2LatLngRect(this.lo(), this.hi());
    }

    @Override
    public S2LatLngRect getRectBound() {
        return this;
    }

    public void encode(OutputStream output) throws IOException {
        this.encode(new LittleEndianOutput(output));
    }

    void encode(LittleEndianOutput encoder) throws IOException {
        encoder.writeByte((byte)1);
        encoder.writeDouble(this.lat().lo());
        encoder.writeDouble(this.lat().hi());
        encoder.writeDouble(this.lng().lo());
        encoder.writeDouble(this.lng().hi());
    }

    public static S2LatLngRect decode(InputStream input) throws IOException {
        return S2LatLngRect.decode(new LittleEndianInput(input));
    }

    static S2LatLngRect decode(LittleEndianInput decoder) throws IOException {
        double lngHi;
        double lngLo;
        S1Interval lng;
        double latHi;
        byte version = decoder.readByte();
        if (version != 1) {
            throw new IOException(new StringBuilder(46).append("Unsupported S2LatLngRect encoding version ").append(version).toString());
        }
        double latLo = decoder.readDouble();
        R1Interval lat = new R1Interval(latLo, latHi = decoder.readDouble());
        S2LatLngRect bound = new S2LatLngRect(lat, lng = new S1Interval(lngLo = decoder.readDouble(), lngHi = decoder.readDouble()));
        if (!bound.isValid()) {
            throw new IOException("Decoded S2LatLngRect is invalid.");
        }
        return bound;
    }

    public strictfp static final class Builder
    extends S2LatLngRectBase {
        public Builder(S2LatLng lo, S2LatLng hi) {
            super(lo, hi);
        }

        public Builder(R1Interval lat, S1Interval lng) {
            super(lat, lng);
        }

        public Builder(S2LatLngRectBase b) {
            this.lat.setLo(b.lat.lo());
            this.lat.setHi(b.lat.hi());
            this.lng.set(b.lng.lo(), b.lng.hi(), true);
        }

        @Override
        public final R1Interval lat() {
            return new R1Interval(this.lat);
        }

        @Override
        public final S1Interval lng() {
            return new S1Interval(this.lng);
        }

        public S2LatLngRect build() {
            return new S2LatLngRect(new R1Interval(this.lat), new S1Interval(this.lng));
        }

        public static Builder empty() {
            return new Builder(R1Interval.empty(), S1Interval.empty());
        }

        public void setFull() {
            this.lat.set(-1.5707963267948966, 1.5707963267948966);
            this.lng.setFull();
        }

        public void addPoint(S2Point p) {
            this.addPoint(new S2LatLng(p));
        }

        public void addPoint(S2LatLng ll) {
            this.lat.unionInternal(ll.lat().radians());
            this.lng.unionInternal(S1Interval.fromPoint(ll.lng().radians()));
        }

        public void expanded(S2LatLng margin) {
            this.lat.expandedInternal(margin.lat().radians());
            this.lat.intersectionInternal(S2LatLngRect.fullLat());
            this.lng.expandedInternal(margin.lng().radians());
        }

        public void polarClosure() {
            if (this.lat.lo() == -1.5707963267948966 || this.lat.hi() == 1.5707963267948966) {
                this.lng.setFull();
            }
        }

        public void union(S2LatLngRect other) {
            this.lat.unionInternal(other.lat);
            this.lng.unionInternal(other.lng);
        }

        public void intersection(S2LatLngRect other) {
            this.lat.intersectionInternal(other.lat);
            this.lng.intersectionInternal(other.lng);
            if (this.lat.isEmpty() && !this.lng.isEmpty()) {
                this.lng.setEmpty();
            } else if (this.lng.isEmpty() && !this.lat.isEmpty()) {
                this.lat.setEmpty();
            }
        }

        public void convolveWithCap(S1Angle angle) {
            S2Cap cap = S2Cap.fromAxisAngle(S2Point.X_POS, angle);
            double latLo = this.lat.lo();
            double latHi = this.lat.hi();
            double lngLo = this.lng.lo();
            double lngHi = this.lng.hi();
            this.union(S2Cap.fromAxisHeight(S2LatLng.fromRadians(latLo, lngLo).toPoint(), cap.height()).getRectBound());
            this.union(S2Cap.fromAxisHeight(S2LatLng.fromRadians(latLo, lngHi).toPoint(), cap.height()).getRectBound());
            this.union(S2Cap.fromAxisHeight(S2LatLng.fromRadians(latHi, lngLo).toPoint(), cap.height()).getRectBound());
            this.union(S2Cap.fromAxisHeight(S2LatLng.fromRadians(latHi, lngHi).toPoint(), cap.height()).getRectBound());
        }

        public S2Region clone() {
            return new S2LatLngRect(this.lo(), this.hi());
        }

        @Override
        public S2LatLngRect getRectBound() {
            return this.build();
        }
    }
}

