/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.exception;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import javax.annotation.Nullable;

public class DatastoreException
extends Exception {
    private final RetryOptions retryOptions;
    private final DatastorePb.Error.ErrorCode errorCode;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isNeverRetryable() {
        return this.retryOptions() == RetryOptions.NOT_RETRYABLE || this.errorCode.equals((Object)DatastorePb.Error.ErrorCode.INTERNAL_ERROR);
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public DatastoreException(String message, DatastorePb.Error.ErrorCode errorCode, @Nullable Throwable cause) {
        this(message, errorCode, cause, RetryOptions.DEFAULT);
    }

    private DatastoreException(String message, DatastorePb.Error.ErrorCode errorCode, @Nullable Throwable cause, RetryOptions retryOptions) {
        super((String)Preconditions.checkNotNull((Object)message), cause);
        this.errorCode = (DatastorePb.Error.ErrorCode)Preconditions.checkNotNull((Object)errorCode);
        this.retryOptions = retryOptions;
    }

    public DatastorePb.Error.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static class Builder {
        private RetryOptions retryOptions = RetryOptions.DEFAULT;
        private DatastorePb.Error.ErrorCode errorCode;
        private String message;
        private Throwable cause;

        public Builder forceNonRetryable() {
            Preconditions.checkArgument((this.retryOptions == RetryOptions.DEFAULT ? 1 : 0) != 0, (Object)"RetryOptions already set.");
            this.retryOptions = RetryOptions.NOT_RETRYABLE;
            return this;
        }

        public Builder continuation() {
            Preconditions.checkArgument((this.retryOptions == RetryOptions.DEFAULT ? 1 : 0) != 0, (Object)"RetryOptions already set.");
            this.retryOptions = RetryOptions.CONTINUATION;
            return this;
        }

        public Builder errorCode(DatastorePb.Error.ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public DatastoreException build() {
            return new DatastoreException(this.message, this.errorCode, this.cause, this.retryOptions);
        }
    }

    public static enum RetryOptions {
        DEFAULT,
        NOT_RETRYABLE,
        CONTINUATION;

    }
}

