/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.$AutoValue_DatabaseRef;
import com.google.apphosting.datastore.rep.AutoValue_DatabaseRef_Directory;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.rep.ResourceRef;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public abstract class DatabaseRef
implements ResourceRef {
    public static final DatabaseRef EMPTY = DatabaseRef.builder().partitionId("").projectId("").databaseId("").directory(Directory.USER).build();

    public static Builder builder() {
        return new $AutoValue_DatabaseRef.Builder();
    }

    public static DatabaseRef createForProject(String partitionId, String projectId, String databaseId) {
        boolean isMetadata;
        Preconditions.checkNotNull((Object)partitionId);
        if (partitionId.isEmpty() && projectId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Matcher matcher = RepHelper.PROJECT_ID_REGEX.matcher(projectId);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Not a project id");
        boolean bl = isMetadata = matcher.matches() && matcher.group("metadata") != null;
        if (isMetadata) {
            projectId = matcher.group("metadata");
        }
        return DatabaseRef.builder().directory(isMetadata ? Directory.LEGACY : Directory.USER).partitionId(partitionId).projectId(projectId).databaseId(databaseId).build();
    }

    public static DatabaseRef createWithUnknownPartitionId(String projectId, String databaseId) {
        boolean isMetadata;
        if (projectId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Matcher matcher = RepHelper.PROJECT_ID_REGEX.matcher(projectId);
        boolean bl = isMetadata = matcher.matches() && matcher.group("metadata") != null;
        if (isMetadata) {
            projectId = matcher.group("metadata");
        }
        return DatabaseRef.builder().directory(isMetadata ? Directory.LEGACY : Directory.USER).partitionId(null).projectId(projectId).databaseId(databaseId).build();
    }

    public static DatabaseRef createForApp(String appId, String databaseId) {
        if (appId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Matcher matcher = RepHelper.APP_ID_REGEX.matcher(appId);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Invalid app id");
        boolean isMetadata = matcher.group("metadata") != null;
        String projectId = isMetadata ? matcher.group("metadata") : matcher.group("project");
        String partitionId = matcher.group("cluster") != null ? matcher.group("cluster") : "";
        return DatabaseRef.builder().directory(isMetadata ? Directory.LEGACY : Directory.USER).partitionId(partitionId).projectId(projectId).databaseId(databaseId).build();
    }

    public abstract Directory directory();

    @Nullable
    protected abstract String autoPartitionId();

    public abstract String projectId();

    public abstract String databaseId();

    public ByteString databaseIdAsByteString() {
        return ByteString.copyFromUtf8((String)this.databaseId());
    }

    public String appId() {
        if (this.directory().isLegacy()) {
            String string = String.valueOf("__metadata-");
            String string2 = String.valueOf(this.projectId());
            String string3 = String.valueOf("__");
            return RepHelper.projectIdToApp(this.partitionId(), new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(string3).toString());
        }
        return RepHelper.projectIdToApp(this.partitionId(), this.projectId());
    }

    public ByteString appIdAsByteString() {
        return ByteString.copyFromUtf8((String)this.appId());
    }

    public String partitionId() {
        if (this.autoPartitionId() == null) {
            throw new Error("Unknown partitionId.");
        }
        return this.autoPartitionId();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.autoPartitionId() == null) {
            builder.append("<unknown!>~");
        } else if (!this.autoPartitionId().isEmpty()) {
            builder.append(this.autoPartitionId());
            builder.append("~");
        }
        if (this.directory().isLegacy()) {
            builder.append("__metadata-");
        }
        builder.append(this.projectId());
        if (this.directory().isLegacy()) {
            builder.append("__");
        } else if (this.directory().isReplicated()) {
            builder.append("@").append(this.directory().replicaId());
        }
        if (!this.databaseId().isEmpty()) {
            builder.append("#");
            builder.append(this.databaseId());
        }
        return builder.toString();
    }

    public abstract Builder toBuilder();

    public DatabaseRef withDirectory(Directory directory) {
        return this.toBuilder().directory(directory).build();
    }

    public DatabaseRef withoutAppPartition() {
        if (this.autoPartitionId() == null) {
            return this;
        }
        return this.toBuilder().partitionId(null).build();
    }

    public boolean hasAppPartition() {
        return this.autoPartitionId() != null && !this.autoPartitionId().isEmpty();
    }

    public static abstract class Builder {
        public abstract Builder directory(Directory var1);

        public Builder partitionId(@Nullable String partitionId) {
            return this.autoPartitionId(partitionId);
        }

        protected abstract Builder autoPartitionId(@Nullable String var1);

        public abstract Builder projectId(String var1);

        public abstract Builder databaseId(String var1);

        public abstract DatabaseRef build();
    }

    public static abstract class Directory {
        public static final Directory USER = new AutoValue_DatabaseRef_Directory(false, false, null);
        public static final Directory LEGACY = new AutoValue_DatabaseRef_Directory(true, false, null);
        public static final Directory ALL_REPLICAS = new AutoValue_DatabaseRef_Directory(false, true, null);

        public boolean isMetadata() {
            return this.isLegacy() || this.isReplicated();
        }

        public abstract boolean isLegacy();

        public abstract boolean isReplicated();

        @Nullable
        public abstract Integer replicaId();

        public static Directory replicated(int replica) {
            return new AutoValue_DatabaseRef_Directory(false, true, replica);
        }
    }
}

