/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.primitives.Bytes;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.AmbiguousPropertyPath;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.RegularPropertyPath;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.rep.Value;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;

public abstract class PropertyPath
implements Comparable<PropertyPath> {
    public static final PropertyPath KEY_RESOURCE_ID = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.KEY_RESOURCE_ID);
    public static final PropertyPath KEY = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.KEY);
    public static final PropertyPath KIND = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.KIND);
    public static final PropertyPath NAMESPACE = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.NAMESPACE);
    public static final PropertyPath PARENT_PATH = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.PARENT_PATH);
    public static final PropertyPath PROPERTY_PATH = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.PROPERTY_PATH);
    public static final PropertyPath PROPERTY_VALUE = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.PROPERTY_VALUE);
    public static final PropertyPath SCATTER = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.SCATTER);
    public static final PropertyPath SPLITS = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.SPLITS);
    public static final PropertyPath UNAPPLIED_LOG_TIMESTAMP_US = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.UNAPPLIED_LOG_TIMESTAMP_US);

    public static int compare(@Nullable PropertyPath leftPath, @Nullable PropertyPath rightPath) {
        if (leftPath == null) {
            if (rightPath == null) {
                return 0;
            }
            return -1;
        }
        if (rightPath == null) {
            return 1;
        }
        boolean isRightPathAmbiguous = rightPath instanceof AmbiguousPropertyPath;
        if (leftPath instanceof AmbiguousPropertyPath) {
            AmbiguousPropertyPath leftAmbiguousPropertyPath = (AmbiguousPropertyPath)leftPath;
            if (isRightPathAmbiguous) {
                AmbiguousPropertyPath rightAmbiguousPropertyPath = (AmbiguousPropertyPath)rightPath;
                return leftAmbiguousPropertyPath.compareToSameClass(rightAmbiguousPropertyPath);
            }
            RegularPropertyPath rightRegularPropertyPath = (RegularPropertyPath)rightPath;
            return -rightRegularPropertyPath.compareToDiffClass(leftAmbiguousPropertyPath);
        }
        RegularPropertyPath leftRegularPropertyPath = (RegularPropertyPath)leftPath;
        if (isRightPathAmbiguous) {
            AmbiguousPropertyPath rightAmbiguousPropertyPath = (AmbiguousPropertyPath)rightPath;
            return leftRegularPropertyPath.compareToDiffClass(rightAmbiguousPropertyPath);
        }
        RegularPropertyPath rightRegularPropertyPath = (RegularPropertyPath)rightPath;
        return leftRegularPropertyPath.compareToSameClass(rightRegularPropertyPath);
    }

    public static PropertyPath create(ImmutableList<String> names) {
        Preconditions.checkArgument((names.size() == 1 ? 1 : 0) != 0);
        return PropertyPath.createFromAmbiguousPathString((String)names.get(0));
    }

    public static PropertyPath createFromByteArray(byte[] byteArray) {
        return PropertyPath.createFromAmbiguousPathByteArray(byteArray);
    }

    public static PropertyPath createFromSegments(List<PropertyPathSegment> segments) {
        PropertyPath propertyPath = null;
        for (int index = segments.size() - 1; index >= 0; --index) {
            PropertyPathSegment segment = segments.get(index);
            propertyPath = PropertyPath.create(segment, propertyPath);
        }
        return propertyPath;
    }

    public static PropertyPath createFromMemberName(String name) {
        return PropertyPath.create(PropertyPathSegment.Member.create(PropertyName.fromUtf8(name)), null);
    }

    public static PropertyPath create(PropertyPathSegment segment, @Nullable PropertyPath next) {
        return new RegularPropertyPath(segment, next);
    }

    public static PropertyPath create(@Nullable PropertyPath prefix, PropertyPathSegment segment) {
        if (prefix == null) {
            return PropertyPath.create(segment, null);
        }
        PropertyPath remainder = prefix.next() == null ? PropertyPath.create(segment, null) : PropertyPath.create(prefix.next(), segment);
        return PropertyPath.create(prefix.segment(), remainder);
    }

    public static PropertyPath createFromAmbiguousPathString(String name) {
        return PropertyPath.createFromAmbiguousPathByteArray(name.getBytes(StandardCharsets.UTF_8));
    }

    public static PropertyPath createFromAmbiguousPathByteArray(byte[] byteArray) {
        String stringLossy = ProtocolSupport.toStringUtf8((byte[])byteArray);
        PropertyName propertyName = PropertyName.fromByteArrayAndUtf8(byteArray, stringLossy);
        if (Bytes.indexOf((byte[])byteArray, (byte)46) < 0 && ByteString.copyFrom((byte[])byteArray).isValidUtf8()) {
            return PropertyPath.create(PropertyPathSegment.Member.create(propertyName), null);
        }
        return new AmbiguousPropertyPath(propertyName);
    }

    private static PropertyPath createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor special) {
        return PropertyPath.createFromMemberName(special.getPropertyName());
    }

    public abstract PropertyPathSegment segment();

    @Nullable
    public abstract PropertyPath next();

    @Nullable
    abstract Value getFrom(ImmutableList<Value> var1);

    @Nullable
    abstract Value getFrom(ImmutableMap<String, Value> var1);

    @Nullable
    public abstract SpecialPropertyDescriptor special();

    public abstract PropertyName asPropertyNameWithDelimiterAmbiguity();

    @Override
    public int compareTo(@Nullable PropertyPath other) {
        return PropertyPath.compare(this, other);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof PropertyPath)) {
            return false;
        }
        PropertyPath otherPropertyPath = (PropertyPath)otherObject;
        return this.compareTo(otherPropertyPath) == 0;
    }

    public abstract int hashCode();

    public String asStringLossy() {
        return this.toString();
    }
}

