/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.rep.AutoValue_QueryScope;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.rep.PartitionRef;
import javax.annotation.Nullable;

public abstract class QueryScope {
    @Deprecated
    public abstract PartitionRef partition();

    public String namespace() {
        return this.partition().namespace();
    }

    @Deprecated
    public DatabaseRef databaseRef() {
        return this.partition().databaseRef();
    }

    @Nullable
    public abstract ImmutableList<String> safeReplicaNames();

    @Nullable
    public abstract Long transaction();

    @Nullable
    public abstract Long readTimestamp();

    public abstract boolean isStrong();

    public abstract boolean allowInMemoryOperations();

    public abstract boolean isVeryInconsistent();

    @Nullable
    public abstract DatastorePb.Query.Hint hint();

    @Nullable
    public abstract Integer batchSize();

    public static Builder builder() {
        return new AutoValue_QueryScope.Builder().isStrong(false).allowInMemoryOperations(false).isVeryInconsistent(false);
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder partition(PartitionRef var1);

        public abstract Builder safeReplicaNames(@Nullable Iterable<String> var1);

        public abstract Builder transaction(@Nullable Long var1);

        public abstract Builder readTimestamp(@Nullable Long var1);

        public abstract Builder isStrong(boolean var1);

        public abstract Builder allowInMemoryOperations(boolean var1);

        public abstract Builder isVeryInconsistent(boolean var1);

        public abstract Builder hint(@Nullable DatastorePb.Query.Hint var1);

        public abstract Builder batchSize(@Nullable Integer var1);

        abstract QueryScope autoBuild();

        public QueryScope build() {
            QueryScope queryScope = this.autoBuild();
            Preconditions.checkState((queryScope.transaction() == null || queryScope.isStrong() ? 1 : 0) != 0);
            Preconditions.checkState((queryScope.transaction() == null || queryScope.readTimestamp() == null ? 1 : 0) != 0);
            return queryScope;
        }
    }
}

