/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Arrays;
import javax.annotation.CheckReturnValue;

public class ReferencePaths {
    protected ReferencePaths() {
    }

    public static String getKind(OnestoreEntity.Reference key) {
        return ReferencePaths.lastElement(key).getType();
    }

    public static String getKind(OnestoreEntity.Path path) {
        return ReferencePaths.lastElement(path).getType();
    }

    public static OnestoreEntity.Path.Element lastElement(OnestoreEntity.Reference key) {
        return ReferencePaths.lastElement(key.getPath());
    }

    public static OnestoreEntity.Path.Element lastElement(OnestoreEntity.Path path) {
        Preconditions.checkArgument((path.elementSize() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return path.getElement(path.elementSize() - 1);
    }

    public static EntityV4.Key.PathElementOrBuilder lastElement(EntityV4.KeyOrBuilder key) {
        Preconditions.checkArgument((key.getPathElementCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPathElementOrBuilder(key.getPathElementCount() - 1);
    }

    public static EntityV4.Key.PathElement.Builder lastElement(EntityV4.Key.Builder key) {
        Preconditions.checkArgument((key.getPathElementCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPathElementBuilder(key.getPathElementCount() - 1);
    }

    public static Key.PathElement lastElement(KeyOrBuilder key) {
        Preconditions.checkArgument((key.getPathCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPath(key.getPathCount() - 1);
    }

    public static boolean hasIncompleteLastElement(EntityV4.KeyOrBuilder key) {
        if (key.getPathElementCount() == 0) {
            return false;
        }
        EntityV4.Key.PathElementOrBuilder lastPathElement = ReferencePaths.lastElement(key);
        return !lastPathElement.hasId() && !lastPathElement.hasName();
    }

    public static boolean hasIncompleteLastElement(KeyOrBuilder key) {
        if (key.getPathCount() == 0) {
            return false;
        }
        return ReferencePaths.lastElement(key).getIdTypeCase() == Key.PathElement.IdTypeCase.IDTYPE_NOT_SET;
    }

    public static boolean hasIdOrName(OnestoreEntity.Reference key) {
        return ReferencePaths.hasIdOrName(key.getPath());
    }

    public static boolean hasIdOrName(OnestoreEntity.Path path) {
        return ReferencePaths.hasIdOrName(ReferencePaths.lastElement(path));
    }

    public static boolean hasIdOrName(OnestoreEntity.Path.Element element) {
        return element.hasId() && element.getId() != 0L || element.hasName() && !element.getName().isEmpty();
    }

    public static boolean hasIncompleteLastElement(OnestoreEntity.Reference key) {
        if (key.getPath().elementSize() == 0) {
            return false;
        }
        return !ReferencePaths.hasIdOrName(key);
    }

    public static OnestoreEntity.PropertyValue toReferenceProperty(OnestoreEntity.Reference key) {
        OnestoreEntity.PropertyValue prop = new OnestoreEntity.PropertyValue();
        OnestoreEntity.PropertyValue.ReferenceValue ref = prop.getMutableReferenceValue();
        if (key.hasApp()) {
            ref.setApp(key.getApp());
        }
        if (key.hasDatabaseId()) {
            ref.setDatabaseId(key.getDatabaseId());
        }
        if (key.hasNameSpace()) {
            ref.setNameSpace(key.getNameSpace());
        }
        for (OnestoreEntity.Path.Element keyElem : key.getPath().elements()) {
            OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem = ref.addPathElement();
            if (keyElem.hasType()) {
                refElem.setType(keyElem.getType());
            }
            if (keyElem.hasId()) {
                refElem.setId(keyElem.getId());
            }
            if (!keyElem.hasName()) continue;
            refElem.setName(keyElem.getName());
        }
        return prop;
    }

    public static OnestoreEntity.Path.Element pop(OnestoreEntity.Path path) {
        return path.removeElement(path.elementSize() - 1);
    }

    @CheckReturnValue
    public static OnestoreEntity.Path truncatePath(OnestoreEntity.Path path, int newLength) {
        if (newLength >= path.elementSize()) {
            return path;
        }
        OnestoreEntity.Path truncated = (OnestoreEntity.Path)path.clone();
        truncated.mutableElements().subList(newLength, path.elementSize()).clear();
        return truncated;
    }

    public static OnestoreEntity.Reference createKeyFromPath(DatabaseRef internalDatabase, String namespace, Object ... elms) {
        Preconditions.checkNotNull((Object)internalDatabase);
        Preconditions.checkArgument((!internalDatabase.appId().isEmpty() ? 1 : 0) != 0, (Object)"Application name must be supplied");
        OnestoreEntity.Reference k = new OnestoreEntity.Reference();
        k.setApp(internalDatabase.appId());
        if (!internalDatabase.databaseId().isEmpty()) {
            k.setDatabaseId(internalDatabase.databaseId());
        }
        if (namespace != null && !namespace.isEmpty()) {
            k.setNameSpace(namespace);
        }
        k.setPath(ReferencePaths.createPath(elms));
        return k;
    }

    public static OnestoreEntity.Path createPath(Object ... elms) {
        Preconditions.checkArgument((elms.length > 0 && elms.length % 2 == 0 ? 1 : 0) != 0, (String)"Bad path: wrong number of elements %s", (Object)Arrays.toString(elms));
        OnestoreEntity.Path p = new OnestoreEntity.Path();
        for (int i = 0; i < elms.length; i += 2) {
            Preconditions.checkArgument((boolean)(elms[i] instanceof String), (String)"Bad path: type should be String: %s", (Object)elms[i]);
            String type = (String)elms[i];
            if (elms[i + 1] instanceof Long || elms[i + 1] instanceof Integer) {
                long id = ((Number)elms[i + 1]).longValue();
                Preconditions.checkArgument((id != 0L || i + 2 == elms.length ? 1 : 0) != 0, (Object)"Bad path: id can be 0 only for the last element");
                p.addElement().setType(type).setId(id);
                continue;
            }
            Preconditions.checkArgument((boolean)(elms[i + 1] instanceof String), (String)"Bad path: type should be String, int or long: %s", (Object)elms[i + 1]);
            String name = (String)elms[i + 1];
            p.addElement().setType(type).setName(name);
        }
        return p;
    }

    public static String getName(OnestoreEntity.Reference key) {
        return ReferencePaths.lastElement(key).getName();
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue.ReferenceValue ref) {
        OnestoreEntity.Reference key = new OnestoreEntity.Reference();
        if (ref.hasApp()) {
            key.setApp(ref.getApp());
        }
        if (ref.hasNameSpace()) {
            key.setNameSpace(ref.getNameSpace());
        }
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement refElem : ref.pathElements()) {
            OnestoreEntity.Path.Element keyElem = key.getMutablePath().addElement();
            if (refElem.hasType()) {
                keyElem.setType(refElem.getType());
            }
            if (refElem.hasId()) {
                keyElem.setId(refElem.getId());
            }
            if (!refElem.hasName()) continue;
            keyElem.setName(refElem.getName());
        }
        return key;
    }

    public static OnestoreEntity.Reference toParentReference(OnestoreEntity.Reference key) {
        OnestoreEntity.Reference parentKey = (OnestoreEntity.Reference)key.clone();
        ReferencePaths.pop(parentKey.getPath());
        return parentKey;
    }
}

