/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.apphosting.datastore.rep.AmbiguousPropertyPath;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.rep.Value;
import javax.annotation.Nullable;

class RegularPropertyPath
extends PropertyPath {
    private final PropertyPathSegment segment;
    @Nullable
    private final PropertyPath next;
    @Nullable
    private final PropertyName fullPathName;

    public RegularPropertyPath(PropertyPathSegment segment, @Nullable PropertyPath next) {
        PropertyPathSegment.Member memberSegment;
        PropertyName propertyName;
        this.segment = segment;
        this.next = next;
        PropertyName localFullPathName = null;
        if (next == null && segment instanceof PropertyPathSegment.Member && !(propertyName = (memberSegment = (PropertyPathSegment.Member)segment).name()).string().contains(".")) {
            localFullPathName = propertyName;
        }
        this.fullPathName = localFullPathName;
    }

    @Override
    public PropertyPathSegment segment() {
        return this.segment;
    }

    @Override
    @Nullable
    public PropertyPath next() {
        return this.next;
    }

    @Override
    @Nullable
    Value getFrom(ImmutableList<Value> array) {
        Value subValue = this.segment().getFrom(array);
        if (subValue == null || this.next() == null) {
            return subValue;
        }
        return subValue.get(this.next());
    }

    @Override
    @Nullable
    Value getFrom(ImmutableMap<String, Value> map) {
        Value subValue = this.segment().getFrom(map);
        if (subValue == null || this.next() == null) {
            return subValue;
        }
        return subValue.get(this.next());
    }

    @Override
    @Nullable
    public SpecialPropertyDescriptor special() {
        return this.segment().special();
    }

    @Override
    public PropertyName asPropertyNameWithDelimiterAmbiguity() {
        this.checkTrivial("asPropertyNameWithDelimiterAmbiguity");
        return this.fullPathName;
    }

    private void checkTrivial(String methodName) {
        if (this.fullPathName == null) {
            throw new UnsupportedOperationException(new StringBuilder(68 + String.valueOf(methodName).length()).append("RegularPropertyPath.").append(methodName).append(" is not supported for non-trivial regular paths.").toString());
        }
    }

    public int compareToSameClass(RegularPropertyPath otherPath) {
        int segmentComparison = this.segment().compareTo(otherPath.segment());
        if (segmentComparison != 0) {
            return segmentComparison;
        }
        return PropertyPath.compare(this.next, otherPath.next);
    }

    public int compareToDiffClass(AmbiguousPropertyPath otherPath) {
        PropertyName otherFullPathPropertyName = otherPath.asPropertyNameWithDelimiterAmbiguity();
        if (this.fullPathName != null) {
            this.fullPathName.compareTo(otherFullPathPropertyName);
        }
        return PropertyName.fromUtf8(this.asStringLossy()).compareTo(otherFullPathPropertyName);
    }

    @Override
    public int hashCode() {
        int hashCode = this.segment().hashCode();
        if (this.next() != null) {
            hashCode ^= this.next().hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (PropertyPath path = this; path != null; path = ((PropertyPath)path).next()) {
            ((PropertyPath)path).segment().appendAsString(isFirst, stringBuilder);
            isFirst = false;
        }
        return stringBuilder.toString();
    }
}

