/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import java.util.regex.Pattern;

public class RepHelper {
    public static final int MAX_KEY_PATH_LENGTH = 100;
    public static final int MAX_PARTITION_ID_LENGTH = 100;
    @VisibleForTesting
    public static final int MAX_APP_ID_SECTION_LENGTH = 100;
    protected static final String METADATA_PROJECT_PREFIX = "__metadata-";
    protected static final String METADATA_PROJECT_SUFFIX = "__";
    public static final String PROPERTY_PATH_DELIMITER = ".";
    public static final String PROPERTY_PATH_DELIMITER_REGEX = "\\.";
    public static final byte PROPERTY_PATH_DELIMITER_BYTE = 46;
    public static final char PROPERTY_PATH_DELIMITER_CHAR = '.';
    public static final byte PROPERTY_PATH_ESCAPE_BYTE = 92;
    public static final char PROPERTY_PATH_ESCAPE_CHAR = '\\';
    public static final String PARTITION_DELIMITER = "~";
    public static final String PROPERTY_PATH_DELIMITER_AND_KEY_SUFFIX;
    public static final String PARTITION_ID_GROUP = "cluster";
    public static final String PROJECT_ID_GROUP = "project";
    public static final String METADATA_PROJECT_ID_GROUP = "metadata";
    private static final String APP_ID_PARTITION_STRING;
    private static final String APP_ID_DOMAIN_STRING;
    private static final String APP_ID_DISPLAY_STRING;
    private static final String PUBLIC_PROJECT_ID_STRING;
    private static final String RESTRICTED_PROJECT_ID_STRING;
    private static final String METADATA_PROJECT_ID_STRING;
    private static final String PROJECT_ID_STRING;
    public static final Pattern APP_ID_REGEX;
    public static final Pattern PROJECT_ID_REGEX;
    public static final Pattern PARTITION_ID_REGEX;
    public static final Pattern DATABASE_ID_REGEX;
    public static final Pattern PLACEMENT_ID_REGEX;
    public static final long ENTITY_VERSION_NONE = -1L;
    private static final String RESERVED_DELIMITER = "__";
    private static final ByteString RESERVED_DELIMITER_BYTES;
    private static final byte[] RESERVED_DELIMITER_BYTE_ARRAY;

    protected RepHelper() {
    }

    public static String projectIdToApp(String cluster, String projectId) {
        Preconditions.checkArgument((!projectId.contains(PARTITION_DELIMITER) ? 1 : 0) != 0);
        if (cluster.isEmpty()) {
            return projectId;
        }
        return String.format("%s%s%s", cluster, PARTITION_DELIMITER, projectId);
    }

    public static boolean isNameReserved(String name) {
        return name.length() > 2 * "__".length() && name.startsWith("__") && name.endsWith("__");
    }

    public static boolean isNameReserved(ByteString name) {
        return name.size() > 2 * RESERVED_DELIMITER_BYTES.size() && name.startsWith(RESERVED_DELIMITER_BYTES) && name.endsWith(RESERVED_DELIMITER_BYTES);
    }

    public static boolean isNameReserved(byte[] name) {
        if (name.length <= 2 * RESERVED_DELIMITER_BYTE_ARRAY.length) {
            return false;
        }
        int endBase = name.length - RESERVED_DELIMITER_BYTE_ARRAY.length;
        for (int i = 0; i < RESERVED_DELIMITER_BYTE_ARRAY.length; ++i) {
            if (name[i] != RESERVED_DELIMITER_BYTE_ARRAY[i]) {
                return false;
            }
            if (name[endBase + i] == RESERVED_DELIMITER_BYTE_ARRAY[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isPropertyIndexedNormally(PropertyPath propertyPath) {
        SpecialPropertyDescriptor special = propertyPath.special();
        return special == null || special.isStored();
    }

    static {
        String string = String.valueOf(PROPERTY_PATH_DELIMITER);
        String string2 = String.valueOf(SpecialPropertyDescriptor.KEY.getPropertyName());
        PROPERTY_PATH_DELIMITER_AND_KEY_SUFFIX = string2.length() != 0 ? string.concat(string2) : new String(string);
        APP_ID_PARTITION_STRING = String.format("[a-z\\d\\-]{1,%d}", 100);
        APP_ID_DOMAIN_STRING = String.format("[a-z\\d][a-z\\d\\-\\.]{0,%d}", 99);
        APP_ID_DISPLAY_STRING = String.format("[a-z\\d][a-z\\d\\-]{0,%d}", 99);
        PUBLIC_PROJECT_ID_STRING = String.format("(?:%s:)?%s", APP_ID_DOMAIN_STRING, APP_ID_DISPLAY_STRING);
        RESTRICTED_PROJECT_ID_STRING = String.format("__%s__", PUBLIC_PROJECT_ID_STRING);
        METADATA_PROJECT_ID_STRING = String.format("__metadata-(?<%s>%s|%s)__", METADATA_PROJECT_ID_GROUP, RESTRICTED_PROJECT_ID_STRING, PUBLIC_PROJECT_ID_STRING);
        PROJECT_ID_STRING = String.format("(?<%s>%s|%s|%s)", PROJECT_ID_GROUP, METADATA_PROJECT_ID_STRING, RESTRICTED_PROJECT_ID_STRING, PUBLIC_PROJECT_ID_STRING);
        APP_ID_REGEX = Pattern.compile(String.format("(?:(?<%s>%s)%s)?%s", PARTITION_ID_GROUP, APP_ID_PARTITION_STRING, PARTITION_DELIMITER, PROJECT_ID_STRING));
        PROJECT_ID_REGEX = Pattern.compile(PROJECT_ID_STRING);
        DATABASE_ID_REGEX = PARTITION_ID_REGEX = Pattern.compile(String.format("[0-9A-Za-z\\._\\-]{0,%d}", 100));
        PLACEMENT_ID_REGEX = PARTITION_ID_REGEX;
        RESERVED_DELIMITER_BYTES = ByteString.copyFromUtf8((String)"__");
        RESERVED_DELIMITER_BYTE_ARRAY = RESERVED_DELIMITER_BYTES.toByteArray();
    }
}

