/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.apphosting.datastore.rep.AutoValue_Value_LegacyUser;
import com.google.apphosting.datastore.rep.Entity;
import com.google.apphosting.datastore.rep.EntityRef;
import com.google.apphosting.datastore.rep.GeoRegion;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.ResourceRef;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public class Value {
    private static final Object BOXED_UNUSED = new Object();
    public static final Value NULL = new Value(true, Meaning.NONE, Type.NULL, -1L, BOXED_UNUSED, OnestoreEntity.PropertyValue.IMMUTABLE_DEFAULT_INSTANCE, OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value TRUE = new Value(true, Meaning.NONE, Type.BOOLEAN, 1L, BOXED_UNUSED, new OnestoreEntity.PropertyValue().setBooleanValue(true), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value FALSE = new Value(true, Meaning.NONE, Type.BOOLEAN, 0L, BOXED_UNUSED, new OnestoreEntity.PropertyValue().setBooleanValue(false), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value NAN = new Value(true, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(Double.NaN), BOXED_UNUSED, new OnestoreEntity.PropertyValue().setBooleanValue(false), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value NEGATIVE_INFINITY = new Value(true, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(Double.NEGATIVE_INFINITY), BOXED_UNUSED, new OnestoreEntity.PropertyValue().setBooleanValue(false), OnestoreEntity.Property.Meaning.NO_MEANING, null);
    public static final Value EMPTY_ARRAY = new Value(true, Meaning.NONE, Type.ARRAY, -1L, ImmutableList.of(), OnestoreEntity.PropertyValue.IMMUTABLE_DEFAULT_INSTANCE, OnestoreEntity.Property.Meaning.EMPTY_LIST, null);
    public static final Value EMPTY_MAP = new Value(true, Meaning.NONE, Type.MAP, -1L, ImmutableMap.of(), new OnestoreEntity.PropertyValue().setStringValueAsBytes(OnestoreEntity.EntityProto.IMMUTABLE_DEFAULT_INSTANCE.toByteArray()), OnestoreEntity.Property.Meaning.ENTITY_PROTO, null);
    private final boolean isIndexed;
    private final Meaning meaning;
    private final Type type;
    private final long unboxed;
    private final Object boxed;
    @Nullable
    private final UnknownFieldSet unknownFieldSet;
    private final OnestoreEntity.PropertyValue v3Value;
    private final OnestoreEntity.Property.Meaning v3Meaning;

    public static Value createBoolean(boolean x) {
        return x ? TRUE : FALSE;
    }

    public static Value createLong(long x) {
        return new Value(true, Meaning.NONE, Type.LONG, x, BOXED_UNUSED, null);
    }

    public static Value createDouble(double x) {
        if (Double.isNaN(x)) {
            x = Double.NaN;
        }
        return new Value(true, Meaning.NONE, Type.DOUBLE, Double.doubleToRawLongBits(x), BOXED_UNUSED, null);
    }

    public static Value createTimestamp(Timestamp x) {
        return new Value(true, Meaning.NONE, Type.TIMESTAMP, -1L, x, null);
    }

    public static Value createEntityRef(EntityRef x) {
        return new Value(true, Meaning.NONE, Type.ENTITY_REF, -1L, x, null);
    }

    public static Value createResourceRef(ResourceRef x) {
        Preconditions.checkArgument((!(x instanceof EntityRef) ? 1 : 0) != 0);
        return new Value(true, Meaning.NONE, Type.RESOURCE_REF, -1L, x, null);
    }

    public static Value createString(String x) {
        return new Value(true, Meaning.NONE, Type.STRING, -1L, x, null);
    }

    public static Value createBytes(ByteString x) {
        return new Value(true, Meaning.NONE, Type.BYTES, -1L, x, null);
    }

    public static Value createGeoPoint(LatLng x) {
        return new Value(true, Meaning.NONE, Type.GEO_POINT, -1L, x, null);
    }

    public static Value createGeoRegion(GeoRegion x) {
        return new Value(true, Meaning.NONE, Type.GEO_REGION, -1L, x, null);
    }

    public static Value createArray(ImmutableList<Value> x) {
        return new Value(true, Meaning.NONE, Type.ARRAY, -1L, x, null);
    }

    public static Value createMap(ImmutableMap<String, Value> x) {
        return Value.createMap(x, null);
    }

    public static Value createMap(ImmutableMap<String, Value> x, @Nullable UnknownFieldSet unknownFieldSet) {
        return new Value(true, Meaning.NONE, Type.MAP, -1L, x, unknownFieldSet);
    }

    public static Value createEntity(Entity x) {
        return Value.createEntity(x, null);
    }

    public static Value createEntity(Entity x, @Nullable UnknownFieldSet unknownFieldSet) {
        return new Value(true, Meaning.NONE, Type.ENTITY, -1L, x, unknownFieldSet);
    }

    public static Value createLegacyUser(LegacyUser x) {
        return new Value(true, Meaning.NONE, Type.LEGACY_USER, -1L, x, null);
    }

    public static Value createLegacyTimestampMicroseconds(long x) {
        return new Value(true, Meaning.NONE, Type.LEGACY_TIMESTAMP_MICROSECONDS, x, BOXED_UNUSED, null);
    }

    private Value(boolean isIndexed, Meaning meaning, Type type, long unboxed, Object boxed, @Nullable UnknownFieldSet unknownFieldSet) {
        this(isIndexed, meaning, type, unboxed, boxed, null, null, unknownFieldSet);
    }

    private Value(boolean isIndexed, Meaning meaning, Type type, long unboxed, Object boxed, OnestoreEntity.PropertyValue v3Value, OnestoreEntity.Property.Meaning v3Meaning, @Nullable UnknownFieldSet unknownFieldSet) {
        this.isIndexed = isIndexed;
        this.meaning = meaning;
        this.type = type;
        this.unboxed = unboxed;
        this.boxed = boxed;
        this.v3Value = v3Value;
        this.v3Meaning = v3Meaning;
        this.unknownFieldSet = unknownFieldSet;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public Meaning meaning() {
        return this.meaning;
    }

    public Type type() {
        return this.type;
    }

    public UnknownFieldSet unknownFieldSet() {
        return this.unknownFieldSet;
    }

    @Deprecated
    public OnestoreEntity.PropertyValue v3Value() {
        return this.v3Value;
    }

    @Deprecated
    public OnestoreEntity.Property.Meaning v3Meaning() {
        return this.v3Meaning;
    }

    public boolean asBoolean() {
        this.assertType(Type.BOOLEAN);
        return this.unboxed != 0L;
    }

    public long asLong() {
        this.assertType(Type.LONG);
        return this.unboxed;
    }

    public double asDouble() {
        this.assertType(Type.DOUBLE);
        return Double.longBitsToDouble(this.unboxed);
    }

    public Timestamp asTimestamp() {
        return (Timestamp)this.boxed;
    }

    public EntityRef asEntityRef() {
        return (EntityRef)this.boxed;
    }

    public ResourceRef asResourceRef() {
        return (ResourceRef)this.boxed;
    }

    public String asString() {
        return (String)this.boxed;
    }

    public ByteString asBytes() {
        return (ByteString)this.boxed;
    }

    public LatLng asGeoPoint() {
        return (LatLng)this.boxed;
    }

    public GeoRegion asGeoRegion() {
        return (GeoRegion)this.boxed;
    }

    public ImmutableList<Value> asArray() {
        return (ImmutableList)this.boxed;
    }

    public ImmutableMap<String, Value> asMap() {
        return (ImmutableMap)this.boxed;
    }

    public Entity asEntity() {
        return (Entity)this.boxed;
    }

    public LegacyUser asLegacyUser() {
        return (LegacyUser)this.boxed;
    }

    public long asLegacyTimestampMicroseconds() {
        this.assertType(Type.LEGACY_TIMESTAMP_MICROSECONDS);
        return this.unboxed;
    }

    public Value withMeaning(Meaning meaning) {
        if (meaning == this.meaning) {
            return this;
        }
        return new Value(this.isIndexed, meaning, this.type, this.unboxed, this.boxed, this.unknownFieldSet);
    }

    public Value withIsIndexed(boolean isIndexed) {
        if (isIndexed == this.isIndexed) {
            return this;
        }
        return new Value(isIndexed, this.meaning, this.type, this.unboxed, this.boxed, this.unknownFieldSet);
    }

    public Value withV3Value(OnestoreEntity.PropertyValue v3Value, OnestoreEntity.Property.Meaning v3Meaning) {
        return new Value(this.isIndexed, this.meaning, this.type, this.unboxed, this.boxed, v3Value, v3Meaning, this.unknownFieldSet);
    }

    @Nullable
    public Value get(PropertyPath propertyPath) {
        switch (this.type()) {
            case ARRAY: {
                return propertyPath.getFrom(this.asArray());
            }
            case MAP: {
                return propertyPath.getFrom(this.asMap());
            }
            case ENTITY: {
                return propertyPath.getFrom(this.asEntity().propertyMap());
            }
        }
        return null;
    }

    private void assertType(Type requiredType) {
        Preconditions.checkState((this.type == requiredType ? 1 : 0) != 0);
    }

    public boolean equals(Object valueObject) {
        if (!(valueObject instanceof Value)) {
            return false;
        }
        Value value = (Value)valueObject;
        return this.isIndexed == value.isIndexed && this.meaning == value.meaning && this.unboxed == value.unboxed && this.boxed.equals(value.boxed) && this.type == value.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isIndexed, this.meaning, this.type, this.unboxed, this.boxed});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{value: ");
        switch (this.type) {
            case NULL: {
                stringBuilder.append("null");
                break;
            }
            case BOOLEAN: {
                stringBuilder.append(this.asBoolean());
                break;
            }
            case LONG: {
                stringBuilder.append(this.asLong());
                break;
            }
            case DOUBLE: {
                stringBuilder.append(this.asDouble());
                break;
            }
            case TIMESTAMP: {
                stringBuilder.append(this.asTimestamp());
                break;
            }
            case ENTITY_REF: {
                stringBuilder.append(this.asEntityRef());
                break;
            }
            case RESOURCE_REF: {
                stringBuilder.append(this.asResourceRef());
                break;
            }
            case STRING: {
                stringBuilder.append(this.asString());
                break;
            }
            case BYTES: {
                stringBuilder.append(this.asBytes());
                break;
            }
            case GEO_POINT: {
                stringBuilder.append(this.asGeoPoint());
                break;
            }
            case GEO_REGION: {
                stringBuilder.append(this.asGeoRegion());
                break;
            }
            case ARRAY: {
                stringBuilder.append(this.asArray());
                break;
            }
            case MAP: {
                stringBuilder.append(this.asMap());
                break;
            }
            case ENTITY: {
                stringBuilder.append(this.asEntity());
                break;
            }
            case LEGACY_USER: {
                stringBuilder.append(this.asLegacyUser());
                break;
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                stringBuilder.append("{legacy timestamp microseconds: ");
                stringBuilder.append(this.asLegacyTimestampMicroseconds());
                stringBuilder.append("}");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value type.");
            }
        }
        if (!this.isIndexed) {
            stringBuilder.append(", isIndexed: false");
        }
        if (this.meaning != Meaning.NONE) {
            stringBuilder.append(", meaning: ");
            stringBuilder.append((Object)this.meaning);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static enum Meaning {
        NONE,
        ATOM_CATEGORY,
        ATOM_LINK,
        ATOM_TITLE,
        ATOM_CONTENT,
        ATOM_SUMMARY,
        ATOM_AUTHOR,
        GD_WHEN,
        GD_EMAIL,
        GEORSS_POINT,
        GD_IM,
        GD_PHONENUMBER,
        GD_POSTALADDRESS,
        GD_RATING,
        BLOB,
        TEXT,
        BYTESTRING,
        BLOBKEY,
        OMITTED_BY_MEGASTORE_INDEX,
        ENTITY_PROTO,
        LEGACY_USER_ENTITY,
        DEPRECATED_LEGACY_GEO_POINT_ENTITY,
        URI_MEANING_ZLIB,
        GEO_POINT_WITHOUT_APP_ENG_V3_MEANING,
        EMPTY_LIST;

        private static final Meaning[] ordinalToEnumArray;

        @Nullable
        public static Meaning createFromOrdinal(long ordinal) {
            if (ordinal < 0L || ordinal > (long)ordinalToEnumArray.length) {
                return null;
            }
            return ordinalToEnumArray[(int)ordinal];
        }

        static {
            ordinalToEnumArray = Meaning.values();
        }
    }

    public static abstract class LegacyUser {
        public static final String PROPERTY_NAME_EMAIL = "email";
        public static final String PROPERTY_NAME_AUTH_DOMAIN = "auth_domain";
        public static final String PROPERTY_NAME_USER_ID = "user_id";
        public static final String PROPERTY_NAME_FEDERATED_IDENTITY = "federated_identity";
        public static final String PROPERTY_NAME_FEDERATED_PROVIDER = "federated_provider";

        public abstract String email();

        public abstract String authDomain();

        public abstract long gaiaId();

        @Nullable
        public abstract String federatedIdentity();

        @Nullable
        public abstract String federatedProvider();

        public static LegacyUser create(String email, String authDomain, long gaiaId, @Nullable String federatedIdentity, @Nullable String federatedProvider) {
            return new AutoValue_Value_LegacyUser(email, authDomain, gaiaId, federatedIdentity, federatedProvider);
        }
    }

    public static enum Type {
        NULL,
        BOOLEAN,
        LONG,
        DOUBLE,
        TIMESTAMP,
        STRING,
        BYTES,
        ENTITY_REF,
        RESOURCE_REF,
        GEO_POINT,
        ARRAY,
        MAP,
        ENTITY,
        LEGACY_USER,
        LEGACY_TIMESTAMP_MICROSECONDS,
        GEO_REGION;

    }
}

