/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.appengv3;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.apphosting.datastore.rep.ReferencePaths;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Iterator;

public class Paths
extends ReferencePaths {
    protected Paths() {
    }

    public static String getKind(OnestoreEntity.Path path) {
        return Paths.lastElement(path).getType();
    }

    public static long getId(OnestoreEntity.Reference key) {
        return Paths.lastElement(key).getId();
    }

    public static OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        return Paths.getGroup(key.getPath());
    }

    public static OnestoreEntity.Path getGroup(OnestoreEntity.Path path) {
        Preconditions.checkArgument((path.elementSize() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    public static OnestoreEntity.Reference toEntityGroupReference(OnestoreEntity.Reference key) {
        OnestoreEntity.Reference egKey = (OnestoreEntity.Reference)key.clone();
        return egKey.setPath(Paths.getGroup(key));
    }

    public static boolean descendsFrom(OnestoreEntity.Reference key, OnestoreEntity.Reference ancestor) {
        if (!ancestor.getApp().equals(key.getApp())) {
            return false;
        }
        return Paths.descendsFrom(key.getPath(), ancestor.getPath());
    }

    public static boolean descendsFrom(OnestoreEntity.Path path, OnestoreEntity.Path ancestor) {
        Iterator ai = ancestor.elementIterator();
        Iterator ki = path.elementIterator();
        while (ai.hasNext()) {
            if (ki.hasNext() && ((OnestoreEntity.Path.Element)ai.next()).equals((OnestoreEntity.Path.Element)ki.next())) continue;
            return false;
        }
        return true;
    }

    public static OnestoreEntity.Reference toReference(OnestoreEntity.PropertyValue value) {
        Preconditions.checkArgument((boolean)value.hasReferenceValue());
        return Paths.toReference(value.getReferenceValue());
    }

    public static String toPathString(KeyOrBuilder key) {
        if (key.getPathCount() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Key.PathElement element : key.getPathList()) {
            String kind = element.getKind();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            switch (element.getIdTypeCase()) {
                case ID: {
                    stringBuilder.append(element.getId());
                    break;
                }
                case NAME: {
                    stringBuilder.append(element.getName());
                    break;
                }
                case IDTYPE_NOT_SET: {
                    break;
                }
                default: {
                    String string = String.valueOf(element.getIdTypeCase());
                    throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(string).length()).append("Unrecognized id_type: ").append(string).toString());
                }
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String toPathString(OnestoreEntity.Reference key) {
        if (key.getPath().elementSize() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (OnestoreEntity.Path.Element element : key.getPath().elements()) {
            String kind = element.getType();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            if (element.hasId()) {
                stringBuilder.append(element.getId());
            } else if (element.hasName()) {
                stringBuilder.append(element.getName());
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

