/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.appengv4;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResultOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatchOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.service.appengv4.CloudDatastoreV1ToAppEngV4Converter;
import com.google.apphosting.datastore.service.appengv4.EntityV4Converter;
import com.google.apphosting.datastore.service.cloudv1.AppEngV3ToCloudDatastoreV1Converter;
import com.google.apphosting.datastore.service.common.EquivalentMessageConverter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.List;

public class AppEngV3ToAppEngV4Converter {
    private static final Function<OnestoreEntity.CompositeIndex, OnestoreEntity.CompositeIndex> V3_TO_V4_COMPOSITE_INDEX_CONVERTER = EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.parser());
    private final EntityV4Converter entityV4Converter;
    private final AppEngV3ToCloudDatastoreV1Converter appEngV3ToCloudDatastoreV1Converter;
    private final CloudDatastoreV1ToAppEngV4Converter cloudDatastoreV1ToAppEngV4Converter;

    public static OnestoreEntity.CompositeIndex toV4CompositeIndex(OnestoreEntity.CompositeIndex compositeIndex) {
        return (OnestoreEntity.CompositeIndex)V3_TO_V4_COMPOSITE_INDEX_CONVERTER.apply((Object)compositeIndex);
    }

    public AppEngV3ToAppEngV4Converter(EntityV4Converter entityConverter, AppEngV3ToCloudDatastoreV1Converter appEngV3ToCloudDatastoreV1Converter, CloudDatastoreV1ToAppEngV4Converter cloudDatastoreV1ToAppEngV4Converter) {
        this.entityV4Converter = entityConverter;
        this.appEngV3ToCloudDatastoreV1Converter = appEngV3ToCloudDatastoreV1Converter;
        this.cloudDatastoreV1ToAppEngV4Converter = cloudDatastoreV1ToAppEngV4Converter;
    }

    public ImmutableList<OnestoreEntity.CompositeIndex> toV4CompositeIndexes(List<OnestoreEntity.CompositeIndex> compositeIndexes) {
        return ImmutableList.copyOf((Collection)Lists.transform(compositeIndexes, V3_TO_V4_COMPOSITE_INDEX_CONVERTER));
    }

    public DatastoreV4.QueryResultBatch.Builder toV4QueryResultBatch(DatastorePb.QueryResult resultV3) throws InvalidConversionException {
        DatastoreV4.QueryResultBatch.Builder queryResultV4 = this.cloudDatastoreV1ToAppEngV4Converter.toV4QueryResultBatch(ProjectIdAppIdResolver.IDENTITY, (QueryResultBatchOrBuilder)this.appEngV3ToCloudDatastoreV1Converter.toV1QueryResultBatchMetadata(resultV3));
        for (int i = 0; i < resultV3.resultSize(); ++i) {
            DatastoreV4.EntityResult.Builder resultV4 = queryResultV4.addEntityResultBuilder();
            resultV4.setEntity(this.entityV4Converter.toV4Entity(resultV3.getResult(i)));
            if (resultV3.resultCompiledCursorSize() != resultV3.resultSize()) continue;
            resultV4.setCursor(this.toV4QueryCursor(resultV3.getResultCompiledCursor(i)));
        }
        int numOfResults = resultV3.resultSize();
        int numOfVersions = resultV3.versionSize();
        InvalidConversionException.checkConversion(numOfVersions == 0 || numOfVersions == numOfResults, "query results contain inconsistent number of versions", new Object[0]);
        for (int i = 0; i < numOfVersions; ++i) {
            queryResultV4.getEntityResultBuilder(i).setVersion(resultV3.getVersion(i));
        }
        return queryResultV4;
    }

    public DatastoreV4.EntityResult.Builder toV4EntityResult(DatastorePb.GetResponse.Entity entityV3) throws InvalidConversionException {
        DatastoreV4.EntityResult.Builder resultV4 = this.cloudDatastoreV1ToAppEngV4Converter.toV4EntityResult(ProjectIdAppIdResolver.IDENTITY, (EntityResultOrBuilder)this.appEngV3ToCloudDatastoreV1Converter.toV1EntityResult(ProjectIdAppIdResolver.IDENTITY, entityV3));
        if (this.entityV4Converter.getPreservePropertyOrderInV4() && entityV3.hasEntity()) {
            resultV4.setEntity(this.entityV4Converter.toV4Entity(entityV3.getEntity()));
        }
        if (entityV3.hasVersion()) {
            resultV4.setVersion(entityV3.getVersion());
        }
        return resultV4;
    }

    public DatastoreV4.Query.Builder toV4Query(DatastorePb.Query queryV3) throws InvalidConversionException {
        return this.cloudDatastoreV1ToAppEngV4Converter.toV4Query(ProjectIdAppIdResolver.IDENTITY, (QueryOrBuilder)this.appEngV3ToCloudDatastoreV1Converter.toV1Query(ProjectIdAppIdResolver.IDENTITY, queryV3).build());
    }

    private ByteString toV4QueryCursor(DatastorePb.CompiledCursor cursorV3) {
        return cursorV3.toByteString();
    }
}

