/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.appengv4;

import com.google.appengine.repackaged.com.google.datastore.v1.GqlQuery;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.service.appengv4.AppEngV4ToCloudDatastoreV1Converter;
import com.google.apphosting.datastore.service.appengv4.CloudDatastoreV1ToAppEngV4Converter;
import com.google.apphosting.datastore.service.appengv4.EntityV4Converter;
import com.google.apphosting.datastore.service.cloudv1.GqlParser;
import com.google.apphosting.datastore.service.cloudv1.ParseException;
import com.google.apphosting.datastore.service.cloudv1.TokenMgrError;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import java.util.ArrayList;
import java.util.List;

public class AppEngV4IntraConverter {
    protected final EntityV4Converter entityV4Converter;
    private final AppEngV4ToCloudDatastoreV1Converter appEngV4ToCloudDatastoreV1Converter;
    private final CloudDatastoreV1ToAppEngV4Converter cloudDatastoreV1ToAppEngV4Converter;

    public AppEngV4IntraConverter(EntityV4Converter entityV4Converter, AppEngV4ToCloudDatastoreV1Converter appEngV4ToCloudDatastoreV1Converter, CloudDatastoreV1ToAppEngV4Converter cloudDatastoreV1ToAppEngV4Converter) {
        this.entityV4Converter = entityV4Converter;
        this.appEngV4ToCloudDatastoreV1Converter = appEngV4ToCloudDatastoreV1Converter;
        this.cloudDatastoreV1ToAppEngV4Converter = cloudDatastoreV1ToAppEngV4Converter;
    }

    public DatastoreV4.Query.Builder toV4Query(DatastoreV4.GqlQueryOrBuilder gqlQuery, EntityV4.PartitionIdOrBuilder partitionId) throws InvalidConversionException {
        try {
            ProjectIdAppIdResolver resolver = ProjectIdAppIdResolver.IDENTITY;
            GqlQuery.Builder gqlQueryV1 = this.appEngV4ToCloudDatastoreV1Converter.toV1GqlQuery(resolver, gqlQuery);
            PartitionId partitionIdV1 = this.entityV4Converter.toV1PartitionId(resolver, partitionId).build();
            Query queryV1 = new GqlParser((GqlQueryOrBuilder)gqlQueryV1, partitionIdV1, GqlParser.Version.V4).selector().build();
            DatastoreV4.Query.Builder queryV4 = this.cloudDatastoreV1ToAppEngV4Converter.toV4Query(resolver, (QueryOrBuilder)queryV1);
            return queryV4;
        }
        catch (ParseException | TokenMgrError exception) {
            throw new InvalidConversionException(exception.getMessage(), exception);
        }
    }

    public List<DatastoreV4.Mutation.Builder> toV4MutationList(DatastoreV4.Mutation.Operation op, List<EntityV4.Entity> entities) {
        ArrayList<DatastoreV4.Mutation.Builder> mutations = new ArrayList<DatastoreV4.Mutation.Builder>(entities.size());
        for (EntityV4.Entity entity : entities) {
            DatastoreV4.Mutation.Builder mutation = DatastoreV4.Mutation.newBuilder();
            mutation.setOp(op);
            mutation.setEntity(entity);
            mutations.add(mutation);
        }
        return mutations;
    }

    public List<DatastoreV4.Mutation.Builder> toV4DeleteMutationList(List<EntityV4.Key> keys) {
        ArrayList<DatastoreV4.Mutation.Builder> mutations = new ArrayList<DatastoreV4.Mutation.Builder>(keys.size());
        for (EntityV4.Key key : keys) {
            DatastoreV4.Mutation.Builder mutation = DatastoreV4.Mutation.newBuilder();
            mutation.setOp(DatastoreV4.Mutation.Operation.DELETE);
            mutation.setKey(key);
            mutations.add(mutation);
        }
        return mutations;
    }
}

