/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.appengv4;

import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResult;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQuery;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameter;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpression;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.Projection;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatch;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.service.appengv3.CompiledCursorUtil;
import com.google.apphosting.datastore.service.appengv4.EntityV4Converter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import java.util.HashSet;

public class AppEngV4ToCloudDatastoreV1Converter {
    private final EntityV4Converter entityV4Converter;

    public AppEngV4ToCloudDatastoreV1Converter(EntityV4Converter entityConverter) {
        this.entityV4Converter = entityConverter;
    }

    public Query.Builder toV1Query(ProjectIdAppIdResolver resolver, DatastoreV4.QueryOrBuilder queryV4) throws InvalidConversionException {
        Query.Builder queryV1 = Query.newBuilder();
        for (DatastoreV4.PropertyExpressionOrBuilder projectionV4 : queryV4.getProjectionOrBuilderList()) {
            queryV1.addProjection(this.toV1Projection(projectionV4));
        }
        for (DatastoreV4.KindExpression kindV4 : queryV4.getKindList()) {
            queryV1.addKind(this.toV1KindExpression((DatastoreV4.KindExpressionOrBuilder)kindV4));
        }
        if (queryV4.hasFilter()) {
            queryV1.setFilter(this.toV1Filter(resolver, (DatastoreV4.FilterOrBuilder)queryV4.getFilter()));
        }
        for (DatastoreV4.PropertyOrder orderV4 : queryV4.getOrderList()) {
            queryV1.addOrder(this.toV1PropertyOrder((DatastoreV4.PropertyOrderOrBuilder)orderV4));
        }
        for (DatastoreV4.PropertyReference groupByV4 : queryV4.getGroupByList()) {
            queryV1.addDistinctOn(this.toV1PropertyReference((DatastoreV4.PropertyReferenceOrBuilder)groupByV4));
        }
        if (queryV4.hasStartCursor()) {
            queryV1.setStartCursor(this.toV1CursorBytes(queryV4.getStartCursor()));
        }
        if (queryV4.hasEndCursor()) {
            queryV1.setEndCursor(this.toV1CursorBytes(queryV4.getEndCursor()));
        }
        queryV1.setOffset(queryV4.getOffset());
        if (queryV4.hasLimit()) {
            queryV1.getLimitBuilder().setValue(queryV4.getLimit());
        }
        return queryV1;
    }

    private ByteString toV1CursorBytes(ByteString cursorBytesV4) {
        if (cursorBytesV4.isEmpty()) {
            return CompiledCursorUtil.V1_EMPTY_CURSOR;
        }
        return cursorBytesV4;
    }

    private Filter.Builder toV1Filter(ProjectIdAppIdResolver resolver, DatastoreV4.FilterOrBuilder filterV4) throws InvalidConversionException {
        Filter.Builder filterV1 = Filter.newBuilder();
        InvalidConversionException.checkConversion(filterV4.getAllFields().size() == 1, "a filter must have exactly one of its fields set", new Object[0]);
        if (filterV4.hasCompositeFilter()) {
            filterV1.setCompositeFilter(this.toV1CompositeFilter(resolver, (DatastoreV4.CompositeFilterOrBuilder)filterV4.getCompositeFilter()));
        }
        if (filterV4.hasPropertyFilter()) {
            filterV1.setPropertyFilter(this.toV1PropertyFilter(resolver, (DatastoreV4.PropertyFilterOrBuilder)filterV4.getPropertyFilter()));
        }
        return filterV1;
    }

    private CompositeFilter.Builder toV1CompositeFilter(ProjectIdAppIdResolver resolver, DatastoreV4.CompositeFilterOrBuilder filterV4) throws InvalidConversionException {
        CompositeFilter.Builder filterV1 = CompositeFilter.newBuilder();
        switch (filterV4.getOperator()) {
            case AND: {
                filterV1.setOp(CompositeFilter.Operator.AND);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("composite filter operator", filterV4.getOperator());
            }
        }
        for (DatastoreV4.Filter subFilterV4 : filterV4.getFilterList()) {
            filterV1.addFilters(this.toV1Filter(resolver, (DatastoreV4.FilterOrBuilder)subFilterV4));
        }
        return filterV1;
    }

    private PropertyFilter.Builder toV1PropertyFilter(ProjectIdAppIdResolver resolver, DatastoreV4.PropertyFilterOrBuilder filterV4) throws InvalidConversionException {
        PropertyFilter.Builder filterV1 = PropertyFilter.newBuilder();
        if (filterV4.hasProperty()) {
            filterV1.setProperty(this.toV1PropertyReference((DatastoreV4.PropertyReferenceOrBuilder)filterV4.getProperty()));
        }
        switch (filterV4.getOperator()) {
            case LESS_THAN: {
                filterV1.setOp(PropertyFilter.Operator.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filterV1.setOp(PropertyFilter.Operator.LESS_THAN_OR_EQUAL);
                break;
            }
            case EQUAL: {
                filterV1.setOp(PropertyFilter.Operator.EQUAL);
                break;
            }
            case GREATER_THAN: {
                filterV1.setOp(PropertyFilter.Operator.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filterV1.setOp(PropertyFilter.Operator.GREATER_THAN_OR_EQUAL);
                break;
            }
            case HAS_ANCESTOR: {
                filterV1.setOp(PropertyFilter.Operator.HAS_ANCESTOR);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("property filter operator", filterV4.getOperator());
            }
        }
        if (filterV4.hasValue()) {
            filterV1.setValue(this.entityV4Converter.toV1Value(resolver, (EntityV4.ValueOrBuilder)filterV4.getValue()));
        }
        return filterV1;
    }

    private Projection.Builder toV1Projection(DatastoreV4.PropertyExpressionOrBuilder propertyExpressionV4) {
        Projection.Builder projectionV1 = Projection.newBuilder();
        if (propertyExpressionV4.hasProperty()) {
            projectionV1.setProperty(this.toV1PropertyReference((DatastoreV4.PropertyReferenceOrBuilder)propertyExpressionV4.getProperty()));
        }
        return projectionV1;
    }

    private KindExpression.Builder toV1KindExpression(DatastoreV4.KindExpressionOrBuilder kindExpressionV4) {
        KindExpression.Builder kindExpressionV1 = KindExpression.newBuilder();
        kindExpressionV1.setNameBytes(kindExpressionV4.getNameBytes());
        return kindExpressionV1;
    }

    private PropertyOrder.Builder toV1PropertyOrder(DatastoreV4.PropertyOrderOrBuilder propertyOrderV4) throws InvalidConversionException {
        PropertyOrder.Builder propertyOrderV1 = PropertyOrder.newBuilder();
        if (propertyOrderV4.hasProperty()) {
            propertyOrderV1.setProperty(this.toV1PropertyReference((DatastoreV4.PropertyReferenceOrBuilder)propertyOrderV4.getProperty()));
        }
        switch (propertyOrderV4.getDirection()) {
            case ASCENDING: {
                propertyOrderV1.setDirection(PropertyOrder.Direction.ASCENDING);
                break;
            }
            case DESCENDING: {
                propertyOrderV1.setDirection(PropertyOrder.Direction.DESCENDING);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("direction", propertyOrderV4.getDirection());
            }
        }
        return propertyOrderV1;
    }

    PropertyReference.Builder toV1PropertyReference(DatastoreV4.PropertyReferenceOrBuilder propertyReferenceV4) {
        PropertyReference.Builder propertyReferenceV1 = PropertyReference.newBuilder();
        propertyReferenceV1.setNameBytes(propertyReferenceV4.getNameBytes());
        return propertyReferenceV1;
    }

    public GqlQuery.Builder toV1GqlQuery(ProjectIdAppIdResolver resolver, DatastoreV4.GqlQueryOrBuilder queryV4) throws InvalidConversionException {
        GqlQuery.Builder queryV1 = GqlQuery.newBuilder();
        if (queryV4.hasQueryString()) {
            queryV1.setQueryString(queryV4.getQueryString());
        }
        queryV1.setAllowLiterals(queryV4.getAllowLiteral());
        HashSet<String> namedGqlQueryArgSet = new HashSet<String>();
        for (DatastoreV4.GqlQueryArg nameArgV4 : queryV4.getNameArgList()) {
            InvalidConversionException.checkConversion(nameArgV4.hasName(), "A named GQL query parameter has no name.", new Object[0]);
            ByteString parameterNameByteString = nameArgV4.getNameBytes();
            this.entityV4Converter.validateStringAsUtf8ForConversion(parameterNameByteString, "GQL query parameter name");
            String parameterName = nameArgV4.getName();
            InvalidConversionException.checkConversion(namedGqlQueryArgSet.add(parameterName), "Duplicate GQL query parameter name \"%s\".", nameArgV4.getName());
            queryV1.putNamedBindings(parameterName, this.toV1GqlQueryParameter(resolver, (DatastoreV4.GqlQueryArgOrBuilder)nameArgV4).build());
        }
        for (DatastoreV4.GqlQueryArg numberArgV4 : queryV4.getNumberArgList()) {
            InvalidConversionException.checkConversion(!numberArgV4.hasName(), "A numbered GQL query parameter has a name.", new Object[0]);
            queryV1.addPositionalBindings(this.toV1GqlQueryParameter(resolver, (DatastoreV4.GqlQueryArgOrBuilder)numberArgV4));
        }
        return queryV1;
    }

    private GqlQueryParameter.Builder toV1GqlQueryParameter(ProjectIdAppIdResolver resolver, DatastoreV4.GqlQueryArgOrBuilder gqlQueryArgV4) throws InvalidConversionException {
        GqlQueryParameter.Builder queryParamV1 = GqlQueryParameter.newBuilder();
        InvalidConversionException.checkConversion(!gqlQueryArgV4.hasValue() || !gqlQueryArgV4.hasCursor(), "A GQL query parameter has both a value and a cursor.", new Object[0]);
        if (gqlQueryArgV4.hasValue()) {
            queryParamV1.setValue(this.entityV4Converter.toV1Value(resolver, (EntityV4.ValueOrBuilder)gqlQueryArgV4.getValue()));
        } else if (gqlQueryArgV4.hasCursor()) {
            queryParamV1.setCursor(gqlQueryArgV4.getCursor());
        }
        return queryParamV1;
    }

    Mutation.Builder toV1Mutation(ProjectIdAppIdResolver resolver, DatastoreV4.MutationOrBuilder mutationV4) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!mutationV4.hasKey() || !mutationV4.hasEntity(), "Mutation has both a key and an entity.", new Object[0]);
        Mutation.Builder mutationV1 = Mutation.newBuilder();
        switch (mutationV4.getOp()) {
            case INSERT: {
                InvalidConversionException.checkConversion(mutationV4.hasEntity(), "Mutation is missing entity.", new Object[0]);
                mutationV1.setInsert(this.entityV4Converter.toV1Entity(resolver, (EntityV4.EntityOrBuilder)mutationV4.getEntity()));
                break;
            }
            case UPDATE: {
                InvalidConversionException.checkConversion(mutationV4.hasEntity(), "Mutation is missing entity.", new Object[0]);
                mutationV1.setUpdate(this.entityV4Converter.toV1Entity(resolver, (EntityV4.EntityOrBuilder)mutationV4.getEntity()));
                break;
            }
            case UPSERT: {
                InvalidConversionException.checkConversion(mutationV4.hasEntity(), "Mutation is missing entity.", new Object[0]);
                mutationV1.setUpsert(this.entityV4Converter.toV1Entity(resolver, (EntityV4.EntityOrBuilder)mutationV4.getEntity()));
                break;
            }
            case DELETE: {
                InvalidConversionException.checkConversion(mutationV4.hasKey(), "Mutation is missing key.", new Object[0]);
                mutationV1.setDelete(this.entityV4Converter.toV1Key(resolver, (EntityV4.KeyOrBuilder)mutationV4.getKey()));
                break;
            }
            case UNKNOWN: {
                throw new InvalidConversionException("unknown mutation operation");
            }
            default: {
                String string = String.valueOf(mutationV4.getOp());
                throw new InvalidConversionException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized mutation op: ").append(string).toString());
            }
        }
        return mutationV1;
    }

    public QueryResultBatch.Builder toV1QueryResultBatch(ProjectIdAppIdResolver resolver, DatastoreV4.QueryResultBatchOrBuilder batchV4) throws InvalidConversionException {
        QueryResultBatch.Builder batchV1 = this.toV1QueryResultBatchMetadata(batchV4);
        this.addResultsToV1QueryResultBatch(resolver, batchV1, batchV4);
        return batchV1;
    }

    public QueryResultBatch.Builder toV1QueryResultBatchMetadata(DatastoreV4.QueryResultBatchOrBuilder batchV4) throws InvalidConversionException {
        QueryResultBatch.Builder batchV1 = QueryResultBatch.newBuilder();
        batchV1.setSkippedResults(batchV4.getSkippedResults());
        if (batchV4.hasSkippedCursor()) {
            batchV1.setSkippedCursor(this.toV1CursorBytes(batchV4.getSkippedCursor()));
        }
        switch (batchV4.getEntityResultType()) {
            case FULL: {
                batchV1.setEntityResultType(EntityResult.ResultType.FULL);
                break;
            }
            case PROJECTION: {
                batchV1.setEntityResultType(EntityResult.ResultType.PROJECTION);
                break;
            }
            case KEY_ONLY: {
                batchV1.setEntityResultType(EntityResult.ResultType.KEY_ONLY);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("entity result type", batchV4.getEntityResultType());
            }
        }
        if (batchV4.hasEndCursor()) {
            batchV1.setEndCursor(this.toV1CursorBytes(batchV4.getEndCursor()));
        }
        switch (batchV4.getMoreResults()) {
            case NOT_FINISHED: {
                batchV1.setMoreResults(QueryResultBatch.MoreResultsType.NOT_FINISHED);
                break;
            }
            case MORE_RESULTS_AFTER_LIMIT: {
                batchV1.setMoreResults(QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT);
                break;
            }
            case NO_MORE_RESULTS: {
                batchV1.setMoreResults(QueryResultBatch.MoreResultsType.NO_MORE_RESULTS);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("more results", batchV4.getMoreResults());
            }
        }
        return batchV1;
    }

    private void addResultsToV1QueryResultBatch(ProjectIdAppIdResolver resolver, QueryResultBatch.Builder batchV1, DatastoreV4.QueryResultBatchOrBuilder batchV4) throws InvalidConversionException {
        for (DatastoreV4.EntityResult resultV4 : batchV4.getEntityResultList()) {
            batchV1.addEntityResults(this.toV1EntityResult(resolver, (DatastoreV4.EntityResultOrBuilder)resultV4));
        }
    }

    public EntityResult.Builder toV1EntityResult(ProjectIdAppIdResolver resolver, DatastoreV4.EntityResultOrBuilder resultV4) throws InvalidConversionException {
        EntityResult.Builder resultV1 = EntityResult.newBuilder();
        if (resultV4.hasEntity()) {
            resultV1.setEntity(this.entityV4Converter.toV1Entity(resolver, (EntityV4.EntityOrBuilder)resultV4.getEntity()));
        }
        if (resultV4.hasCursor()) {
            resultV1.setCursor(this.toV1CursorBytes(resultV4.getCursor()));
        }
        return resultV1;
    }
}

