/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.appengv4;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResult;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResultOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.FilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameter;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryParameterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpression;
import com.google.appengine.repackaged.com.google.datastore.v1.KindExpressionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Projection;
import com.google.appengine.repackaged.com.google.datastore.v1.ProjectionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrderOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReferenceOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatchOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.service.appengv4.EntityV4Converter;
import com.google.apphosting.datastore.service.cloudv1.CloudDatastoreV1ToAppEngV3Converter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CloudDatastoreV1ToAppEngV4Converter {
    private final EntityV4Converter entityV4Converter;

    private static ByteString toV4CursorBytes(ByteString cursorBytesV1) {
        return CloudDatastoreV1ToAppEngV3Converter.toV3CursorBytes(cursorBytesV1);
    }

    public CloudDatastoreV1ToAppEngV4Converter(EntityV4Converter entityConverter) {
        this.entityV4Converter = (EntityV4Converter)Preconditions.checkNotNull((Object)entityConverter);
    }

    public DatastoreV4.Query.Builder toV4Query(ProjectIdAppIdResolver resolver, QueryOrBuilder queryV1) throws InvalidConversionException {
        List groupByListV4;
        DatastoreV4.Query.Builder queryV4 = DatastoreV4.Query.newBuilder();
        for (Projection projectionV1 : queryV1.getProjectionList()) {
            queryV4.addProjection(this.toV4Projection((ProjectionOrBuilder)projectionV1));
        }
        for (KindExpression kindV1 : queryV1.getKindList()) {
            queryV4.addKind(this.toV4KindExpression((KindExpressionOrBuilder)kindV1));
        }
        if (queryV1.hasFilter()) {
            queryV4.setFilter(this.toV4Filter(resolver, (FilterOrBuilder)queryV1.getFilter()));
        }
        for (PropertyOrder orderV1 : queryV1.getOrderList()) {
            queryV4.addOrder(this.toV4PropertyOrder((PropertyOrderOrBuilder)orderV1));
        }
        for (PropertyReference groupByV1 : queryV1.getDistinctOnList()) {
            queryV4.addGroupBy(this.toV4PropertyReference((PropertyReferenceOrBuilder)groupByV1));
        }
        if (!queryV1.getStartCursor().isEmpty()) {
            queryV4.setStartCursor(CloudDatastoreV1ToAppEngV4Converter.toV4CursorBytes(queryV1.getStartCursor()));
        }
        if (!queryV1.getEndCursor().isEmpty()) {
            queryV4.setEndCursor(CloudDatastoreV1ToAppEngV4Converter.toV4CursorBytes(queryV1.getEndCursor()));
        }
        if (queryV1.getOffset() != 0) {
            queryV4.setOffset(queryV1.getOffset());
        }
        if (queryV1.hasLimit()) {
            queryV4.setLimit(queryV1.getLimit().getValue());
        }
        if (!(groupByListV4 = queryV4.getGroupByList()).isEmpty()) {
            HashSet groupByPropertyNames = Sets.newHashSet();
            for (DatastoreV4.PropertyReference groupBy : groupByListV4) {
                groupByPropertyNames.add(groupBy.getName());
            }
            for (DatastoreV4.PropertyExpression.Builder projection : queryV4.getProjectionBuilderList()) {
                if (groupByPropertyNames.contains(projection.getProperty().getName())) continue;
                projection.setAggregationFunction(DatastoreV4.PropertyExpression.AggregationFunction.FIRST);
            }
        }
        return queryV4;
    }

    private DatastoreV4.Filter.Builder toV4Filter(ProjectIdAppIdResolver resolver, FilterOrBuilder filterV1) throws InvalidConversionException {
        DatastoreV4.Filter.Builder filterV4 = DatastoreV4.Filter.newBuilder();
        switch (filterV1.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                filterV4.setCompositeFilter(this.toV4CompositeFilter(resolver, (CompositeFilterOrBuilder)filterV1.getCompositeFilter()));
                break;
            }
            case PROPERTY_FILTER: {
                filterV4.setPropertyFilter(this.toV4PropertyFilter(resolver, (PropertyFilterOrBuilder)filterV1.getPropertyFilter()));
                break;
            }
            case FILTERTYPE_NOT_SET: {
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("filter_type", filterV1.getFilterTypeCase());
            }
        }
        return filterV4;
    }

    private DatastoreV4.CompositeFilter.Builder toV4CompositeFilter(ProjectIdAppIdResolver resolver, CompositeFilterOrBuilder filterV1) throws InvalidConversionException {
        DatastoreV4.CompositeFilter.Builder filterV4 = DatastoreV4.CompositeFilter.newBuilder();
        switch (filterV1.getOp()) {
            case AND: {
                filterV4.setOperator(DatastoreV4.CompositeFilter.Operator.AND);
                break;
            }
            case OPERATOR_UNSPECIFIED: {
                InvalidConversionException.checkConversion(false, "a composite filter must specify an operator", new Object[0]);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("composite filter operator", filterV1.getOp());
            }
        }
        for (Filter subFilterV1 : filterV1.getFiltersList()) {
            filterV4.addFilter(this.toV4Filter(resolver, (FilterOrBuilder)subFilterV1));
        }
        return filterV4;
    }

    private DatastoreV4.PropertyFilter.Builder toV4PropertyFilter(ProjectIdAppIdResolver resolver, PropertyFilterOrBuilder filterV1) throws InvalidConversionException {
        DatastoreV4.PropertyFilter.Builder filterV4 = DatastoreV4.PropertyFilter.newBuilder();
        if (filterV1.hasProperty()) {
            filterV4.setProperty(this.toV4PropertyReference((PropertyReferenceOrBuilder)filterV1.getProperty()));
        }
        switch (filterV1.getOp()) {
            case LESS_THAN: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.LESS_THAN);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.LESS_THAN_OR_EQUAL);
                break;
            }
            case EQUAL: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.EQUAL);
                break;
            }
            case GREATER_THAN: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.GREATER_THAN);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.GREATER_THAN_OR_EQUAL);
                break;
            }
            case HAS_ANCESTOR: {
                filterV4.setOperator(DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR);
                break;
            }
            case HAS_PARENT: {
                InvalidConversionException.checkConversion(false, "unsupported operator", filterV1.getOp());
                break;
            }
            case OPERATOR_UNSPECIFIED: {
                InvalidConversionException.checkConversion(false, "a property filter must specify an operator", new Object[0]);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("property filter operator", filterV1.getOp());
            }
        }
        if (filterV1.hasValue()) {
            filterV4.setValue(this.entityV4Converter.toV4Value(resolver, filterV1.getValue()));
        }
        return filterV4;
    }

    private DatastoreV4.PropertyExpression.Builder toV4Projection(ProjectionOrBuilder projectionV1) {
        DatastoreV4.PropertyExpression.Builder propertyExpressionV4 = DatastoreV4.PropertyExpression.newBuilder();
        if (projectionV1.hasProperty()) {
            propertyExpressionV4.setProperty(this.toV4PropertyReference((PropertyReferenceOrBuilder)projectionV1.getProperty()));
        }
        return propertyExpressionV4;
    }

    private DatastoreV4.KindExpression.Builder toV4KindExpression(KindExpressionOrBuilder kindExpressionV1) {
        DatastoreV4.KindExpression.Builder kindExpressionV4 = DatastoreV4.KindExpression.newBuilder();
        kindExpressionV4.setName(kindExpressionV1.getName());
        return kindExpressionV4;
    }

    private DatastoreV4.PropertyOrder.Builder toV4PropertyOrder(PropertyOrderOrBuilder propertyOrderV1) throws InvalidConversionException {
        DatastoreV4.PropertyOrder.Builder propertyOrderV4 = DatastoreV4.PropertyOrder.newBuilder();
        if (propertyOrderV1.hasProperty()) {
            propertyOrderV4.setProperty(this.toV4PropertyReference((PropertyReferenceOrBuilder)propertyOrderV1.getProperty()));
        }
        switch (propertyOrderV1.getDirection()) {
            case ASCENDING: {
                propertyOrderV4.setDirection(DatastoreV4.PropertyOrder.Direction.ASCENDING);
                break;
            }
            case DESCENDING: {
                propertyOrderV4.setDirection(DatastoreV4.PropertyOrder.Direction.DESCENDING);
                break;
            }
            case DIRECTION_UNSPECIFIED: {
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("direction", propertyOrderV1.getDirection());
            }
        }
        return propertyOrderV4;
    }

    private DatastoreV4.PropertyReference.Builder toV4PropertyReference(PropertyReferenceOrBuilder propertyReferenceV1) {
        DatastoreV4.PropertyReference.Builder propertyReferenceV4 = DatastoreV4.PropertyReference.newBuilder();
        propertyReferenceV4.setName(propertyReferenceV1.getName());
        return propertyReferenceV4;
    }

    public DatastoreV4.GqlQuery.Builder toV4GqlQuery(ProjectIdAppIdResolver resolver, GqlQueryOrBuilder queryV1) throws InvalidConversionException {
        DatastoreV4.GqlQuery.Builder queryV4 = DatastoreV4.GqlQuery.newBuilder();
        queryV4.setQueryString(queryV1.getQueryString());
        queryV4.setAllowLiteral(queryV1.getAllowLiterals());
        for (Map.Entry positionalArg : queryV1.getNamedBindings().entrySet()) {
            queryV4.addNameArg(this.toV4GqlQueryParameter(resolver, (String)positionalArg.getKey(), (GqlQueryParameterOrBuilder)positionalArg.getValue()));
        }
        for (GqlQueryParameter numberArgV1 : queryV1.getPositionalBindingsList()) {
            queryV4.addNumberArg(this.toV4GqlQueryParameter(resolver, null, (GqlQueryParameterOrBuilder)numberArgV1));
        }
        return queryV4;
    }

    private DatastoreV4.GqlQueryArg.Builder toV4GqlQueryParameter(ProjectIdAppIdResolver resolver, String name, GqlQueryParameterOrBuilder gqlQueryParameterV1) throws InvalidConversionException {
        DatastoreV4.GqlQueryArg.Builder queryArgV4 = DatastoreV4.GqlQueryArg.newBuilder();
        if (name != null) {
            queryArgV4.setName(name);
        }
        switch (gqlQueryParameterV1.getParameterTypeCase()) {
            case VALUE: {
                queryArgV4.setValue(this.entityV4Converter.toV4Value(resolver, gqlQueryParameterV1.getValue()));
                break;
            }
            case CURSOR: {
                queryArgV4.setCursor(gqlQueryParameterV1.getCursor());
                break;
            }
            case PARAMETERTYPE_NOT_SET: {
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("GQL query parameter_type", gqlQueryParameterV1.getParameterTypeCase());
            }
        }
        return queryArgV4;
    }

    public DatastoreV4.QueryResultBatch.Builder toV4QueryResultBatch(ProjectIdAppIdResolver resolver, QueryResultBatchOrBuilder batchV1) throws InvalidConversionException {
        DatastoreV4.QueryResultBatch.Builder batchV4 = DatastoreV4.QueryResultBatch.newBuilder();
        if (batchV1.getSkippedResults() != 0) {
            batchV4.setSkippedResults(batchV1.getSkippedResults());
        }
        if (!batchV1.getSkippedCursor().isEmpty()) {
            batchV4.setSkippedCursor(batchV1.getSkippedCursor());
        }
        switch (batchV1.getEntityResultType()) {
            case FULL: {
                batchV4.setEntityResultType(DatastoreV4.EntityResult.ResultType.FULL);
                break;
            }
            case PROJECTION: {
                batchV4.setEntityResultType(DatastoreV4.EntityResult.ResultType.PROJECTION);
                break;
            }
            case KEY_ONLY: {
                batchV4.setEntityResultType(DatastoreV4.EntityResult.ResultType.KEY_ONLY);
                break;
            }
            case RESULT_TYPE_UNSPECIFIED: {
                InvalidConversionException.checkConversion(false, "a query result batch must specify an entity result type", new Object[0]);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("entity result type", batchV1.getEntityResultType());
            }
        }
        for (EntityResult resultV1 : batchV1.getEntityResultsList()) {
            batchV4.addEntityResult(this.toV4EntityResult(resolver, (EntityResultOrBuilder)resultV1));
        }
        if (!batchV1.getEndCursor().isEmpty()) {
            batchV4.setEndCursor(CloudDatastoreV1ToAppEngV4Converter.toV4CursorBytes(batchV1.getEndCursor()));
        }
        switch (batchV1.getMoreResults()) {
            case NOT_FINISHED: {
                batchV4.setMoreResults(DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED);
                break;
            }
            case MORE_RESULTS_AFTER_LIMIT: 
            case MORE_RESULTS_AFTER_CURSOR: 
            case NO_MORE_RESULTS: {
                batchV4.setMoreResults(DatastoreV4.QueryResultBatch.MoreResultsType.MORE_RESULTS_AFTER_LIMIT);
                break;
            }
            case MORE_RESULTS_TYPE_UNSPECIFIED: {
                InvalidConversionException.checkConversion(false, "a query result batch must specify a more results type", new Object[0]);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("more results", batchV1.getMoreResults());
            }
        }
        return batchV4;
    }

    public DatastoreV4.EntityResult.Builder toV4EntityResult(ProjectIdAppIdResolver resolver, EntityResultOrBuilder resultV1) throws InvalidConversionException {
        DatastoreV4.EntityResult.Builder resultV4 = DatastoreV4.EntityResult.newBuilder();
        if (resultV1.hasEntity()) {
            resultV4.setEntity(this.entityV4Converter.toV4Entity(resolver, (EntityOrBuilder)resultV1.getEntity()));
        }
        if (!resultV1.getCursor().isEmpty()) {
            resultV4.setCursor(resultV1.getCursor());
        }
        return resultV4;
    }
}

