/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.cloudv1;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.Entity;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResult;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResultOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.FilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.GeoRegion;
import com.google.appengine.repackaged.com.google.datastore.v1.GeoRegionOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionIdOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Projection;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatch;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatchOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.StContainsFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.appengine.repackaged.com.google.datastore.v1.ValueOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.type.LatLngOrBuilder;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.service.appengv3.CompiledCursorUtil;
import com.google.apphosting.datastore.service.cloudv1.EntityV3V1Converter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;

public class CloudDatastoreV1ToAppEngV3Converter {
    public static ByteString toV3CursorBytes(ByteString cursorBytesV1) {
        Preconditions.checkArgument((!cursorBytesV1.isEmpty() ? 1 : 0) != 0, (Object)"cannot convert empty v1 cursor bytes");
        if (cursorBytesV1.equals((Object)CompiledCursorUtil.V1_EMPTY_CURSOR)) {
            return ByteString.EMPTY;
        }
        return cursorBytesV1;
    }

    public DatastorePb.CompiledCursor toV3CompiledCursor(ByteString cursorBytesV1) throws InvalidConversionException {
        try {
            return (DatastorePb.CompiledCursor)DatastorePb.CompiledCursor.parser().parseFrom(CloudDatastoreV1ToAppEngV3Converter.toV3CursorBytes(cursorBytesV1));
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }

    public DatastorePb.Query toV3Query(ProjectIdAppIdResolver resolver, PartitionIdOrBuilder partitionId, QueryOrBuilder query) throws InvalidConversionException {
        DatastorePb.Query result = new DatastorePb.Query();
        result.setApp(resolver.toAppId(partitionId.getProjectId()));
        if (!partitionId.getDatabaseId().isEmpty()) {
            result.setDatabaseId(partitionId.getDatabaseId());
        }
        if (!partitionId.getNamespaceId().isEmpty()) {
            result.setNameSpace(partitionId.getNamespaceId());
        }
        result.setPersistOffset(true);
        result.setRequirePerfectPlan(true);
        result.setCompile(true);
        if (query.hasLimit()) {
            result.setLimit(query.getLimit().getValue());
        }
        if (query.getOffset() != 0) {
            result.setOffset(query.getOffset());
        }
        if (!query.getStartCursor().isEmpty()) {
            result.setCompiledCursor(this.toV3CompiledCursor(query.getStartCursor()));
        }
        if (!query.getEndCursor().isEmpty()) {
            result.setEndCompiledCursor(this.toV3CompiledCursor(query.getEndCursor()));
        }
        if (query.getKindCount() > 0) {
            InvalidConversionException.checkConversion(query.getKindCount() == 1, "multiple kinds not supported", new Object[0]);
            result.setKind(query.getKind(0).getName());
        }
        boolean hasKeyProjection = false;
        for (Projection prop : query.getProjectionList()) {
            byte[] propNameAsByteArray = prop.getProperty().getNameBytes().toByteArray();
            PropertyName propertyName = PropertyName.specialLookup(propNameAsByteArray);
            if (propertyName != null && propertyName.special() == SpecialPropertyDescriptor.KEY) {
                hasKeyProjection = true;
                continue;
            }
            result.addPropertyName(prop.getProperty().getName());
        }
        if (hasKeyProjection && result.propertyNameSize() == 0) {
            result.setKeysOnly(true);
        }
        for (Projection prop : query.getDistinctOnList()) {
            result.addGroupByPropertyName(prop.getName());
        }
        if (query.hasFilter()) {
            this.populateV3Filters(resolver, (FilterOrBuilder)query.getFilter(), result);
        }
        block7: for (PropertyOrder order : query.getOrderList()) {
            DatastorePb.Query.Order orderV3 = result.addOrder();
            orderV3.setProperty(order.getProperty().getName());
            switch (order.getDirection()) {
                case DIRECTION_UNSPECIFIED: {
                    continue block7;
                }
                case ASCENDING: {
                    orderV3.setDirection(DatastorePb.Query.Order.Direction.ASCENDING);
                    continue block7;
                }
                case DESCENDING: {
                    orderV3.setDirection(DatastorePb.Query.Order.Direction.DESCENDING);
                    continue block7;
                }
            }
            throw InvalidConversionException.unrecognizedEnumValue("direction", order.getDirection());
        }
        return result;
    }

    private void populateV3Filters(ProjectIdAppIdResolver resolver, FilterOrBuilder filter, DatastorePb.Query query) throws InvalidConversionException {
        switch (filter.getFilterTypeCase()) {
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propertyFilter = filter.getPropertyFilterOrBuilder();
                PropertyReference propertyReference = propertyFilter.getProperty();
                byte[] propertyNameAsByteArray = propertyReference.getNameBytes().toByteArray();
                PropertyFilter.Operator op = propertyFilter.getOp();
                ValueOrBuilder value = propertyFilter.getValueOrBuilder();
                if (op == PropertyFilter.Operator.HAS_ANCESTOR || op == PropertyFilter.Operator.HAS_PARENT) {
                    if (op == PropertyFilter.Operator.HAS_PARENT) {
                        InvalidConversionException.checkConversion(value.getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE || value.getValueTypeCase() == Value.ValueTypeCase.NULL_VALUE, "HAS_PARENT requires a key value or null", new Object[0]);
                    } else {
                        InvalidConversionException.checkConversion(value.getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE, "HAS_ANCESTOR requires a key value", new Object[0]);
                    }
                    PropertyName propertyName = PropertyName.specialLookup(propertyNameAsByteArray);
                    InvalidConversionException.checkConversion(propertyName != null && propertyName.special() == SpecialPropertyDescriptor.KEY, "property must be %s", PropertyPath.KEY.asStringLossy());
                    InvalidConversionException.checkConversion(!query.isShallow() && !query.hasAncestor(), "duplicate ancestor or parent constraint", new Object[0]);
                    query.setShallow(op == PropertyFilter.Operator.HAS_PARENT);
                    if (value.getValueTypeCase() != Value.ValueTypeCase.KEY_VALUE) break;
                    query.setAncestor(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, value.getKeyValueOrBuilder()));
                    break;
                }
                DatastorePb.Query.Filter result = query.addFilter();
                result.setOp(op.getNumber());
                InvalidConversionException.checkConversion(value.getArrayValue().getValuesCount() == 0, "unsupported value type, list_value, in property filter on '%s'", propertyReference.getName());
                result.addProperty().setMultiple(false).setNameAsBytes(propertyNameAsByteArray).setValue(EntityV3V1Converter.INSTANCE.toV3PropertyValue(resolver, (ValueOrBuilder)propertyFilter.getValue()));
                break;
            }
            case COMPOSITE_FILTER: {
                InvalidConversionException.checkConversion(filter.getCompositeFilter().getOp() == CompositeFilter.Operator.AND, "unsupported composite property operator", new Object[0]);
                for (Filter subFilter : filter.getCompositeFilterOrBuilder().getFiltersList()) {
                    this.populateV3Filters(resolver, (FilterOrBuilder)subFilter, query);
                }
                break;
            }
            case ST_CONTAINS_FILTER: {
                StContainsFilter stContainsFilter = filter.getStContainsFilter();
                DatastorePb.Query.Filter result = query.addFilter();
                result.addProperty().setMultiple(false).setName(stContainsFilter.getProperty().getName()).setValue(new OnestoreEntity.PropertyValue());
                result.setOp(DatastorePb.Query.Filter.Operator.CONTAINED_IN_REGION);
                result.setGeoRegion(this.toV3GeoRegion((GeoRegionOrBuilder)stContainsFilter.getContainedIn()));
                break;
            }
            case FILTERTYPE_NOT_SET: {
                query.addFilter();
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("filter_type", filter.getFilterTypeCase());
            }
        }
    }

    public DatastorePb.GeoRegion toV3GeoRegion(GeoRegionOrBuilder region) throws InvalidConversionException {
        DatastorePb.GeoRegion result = new DatastorePb.GeoRegion();
        switch (region.getShapeCase()) {
            case CIRCLE: {
                GeoRegion.Circle circle = region.getCircle();
                result.getMutableCircle().setRadiusMeters(circle.getRadiusMeters()).setCenter(this.toV3RegionPoint((LatLngOrBuilder)circle.getCenter()));
                break;
            }
            case RECTANGLE: {
                GeoRegion.Rectangle rectangle = region.getRectangle();
                result.getMutableRectangle().setSouthwest(this.toV3RegionPoint((LatLngOrBuilder)rectangle.getSouthwest())).setNortheast(this.toV3RegionPoint((LatLngOrBuilder)rectangle.getNortheast()));
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("shape", region.getShapeCase());
            }
        }
        return result;
    }

    public DatastorePb.RegionPoint toV3RegionPoint(LatLngOrBuilder latLng) {
        DatastorePb.RegionPoint result = new DatastorePb.RegionPoint();
        result.setLatitude(latLng.getLatitude());
        result.setLongitude(latLng.getLongitude());
        return result;
    }

    public DatastorePb.QueryResult toV3QueryResult(ProjectIdAppIdResolver resolver, QueryResultBatchOrBuilder batch) throws InvalidConversionException {
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        result.setMoreResults(batch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED);
        if (!batch.getSkippedCursor().isEmpty()) {
            result.setSkippedResultsCompiledCursor(this.toV3CompiledCursor(batch.getSkippedCursor()));
        }
        if (!batch.getEndCursor().isEmpty()) {
            result.setCompiledCursor(this.toV3CompiledCursor(batch.getEndCursor()));
        }
        if (batch.getEntityResultType() == EntityResult.ResultType.PROJECTION) {
            result.setIndexOnly(true);
        } else if (batch.getEntityResultType() == EntityResult.ResultType.KEY_ONLY) {
            result.setKeysOnly(true);
        }
        if (batch.getSkippedResults() != 0) {
            result.setSkippedResults(batch.getSkippedResults());
        }
        for (EntityResult entityResult : batch.getEntityResultsList()) {
            OnestoreEntity.EntityProto entity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)entityResult.getEntity());
            if (batch.getEntityResultType() != EntityResult.ResultType.FULL) {
                entity.setEntityGroup(OnestoreEntity.Path.IMMUTABLE_DEFAULT_INSTANCE);
            }
            result.addResult(entity);
            if (entityResult.getCursor().isEmpty()) continue;
            result.addResultCompiledCursor(this.toV3CompiledCursor(entityResult.getCursor()));
        }
        return result;
    }

    public DatastorePb.GetResponse.Entity toV3Entity(ProjectIdAppIdResolver resolver, EntityResultOrBuilder entityResult, boolean isMissing) throws InvalidConversionException {
        Entity entityV1 = entityResult.getEntity();
        DatastorePb.GetResponse.Entity entityV3 = new DatastorePb.GetResponse.Entity();
        if (isMissing) {
            entityV3.setKey(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)entityV1.getKey()));
        } else {
            entityV3.setEntity(EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)entityV1));
        }
        return entityV3;
    }
}

