/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.cloudv1;

import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.GqlQueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.TransactionOptions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.service.appengv3.TransactionConverter;
import com.google.apphosting.datastore.service.cloudv1.AppEngV3ToCloudDatastoreV1Converter;
import com.google.apphosting.datastore.service.cloudv1.BaseCloudDatastoreV1Converter;
import com.google.apphosting.datastore.service.cloudv1.CloudDatastoreV1IntraConverter;
import com.google.apphosting.datastore.service.cloudv1.CloudDatastoreV1ToAppEngV3Converter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.Config;
import javax.annotation.Nullable;

public class EmulatorCloudDatastoreV1Converter
extends BaseCloudDatastoreV1Converter {
    private final CloudDatastoreV1IntraConverter cloudDatastoreV1IntraConverter;

    public EmulatorCloudDatastoreV1Converter(Config.DatastoreConfig datastoreConfig, TransactionConverter transactionConverter) {
        this(transactionConverter, new CloudDatastoreV1ToAppEngV3Converter(), new AppEngV3ToCloudDatastoreV1Converter(datastoreConfig), new CloudDatastoreV1IntraConverter());
    }

    private EmulatorCloudDatastoreV1Converter(TransactionConverter transactionConverter, CloudDatastoreV1ToAppEngV3Converter cloudDatastoreV1ToAppEngV3Converter, AppEngV3ToCloudDatastoreV1Converter appEngV3ToCloudDatastoreV1Converter, CloudDatastoreV1IntraConverter cloudDatastoreV1IntraConverter) {
        super(transactionConverter, cloudDatastoreV1ToAppEngV3Converter, appEngV3ToCloudDatastoreV1Converter);
        this.cloudDatastoreV1IntraConverter = cloudDatastoreV1IntraConverter;
    }

    public Query.Builder toV1Query(GqlQueryOrBuilder gqlQueryV1, PartitionId partitionIdV1) throws InvalidConversionException {
        return this.cloudDatastoreV1IntraConverter.toV1Query(gqlQueryV1, partitionIdV1);
    }

    public BeginTransactionResponse.Builder toV1BeginTransactionResponse(DatastorePb.Transaction txnV3) throws InvalidConversionException {
        BeginTransactionResponse.Builder resV1 = BeginTransactionResponse.newBuilder();
        resV1.setTransaction(this.transactionConverter.toTransactionBytes(txnV3));
        return resV1;
    }

    public DatastorePb.Transaction toV3Transaction(RollbackRequestOrBuilder reqV1, String appId, String databaseId) throws InvalidConversionException {
        return this.transactionConverter.toV3Transaction(reqV1.getTransaction(), appId, databaseId);
    }

    public DatastorePb.BeginTransactionRequest.TransactionMode toV3TransactionMode(TransactionOptions opts) {
        switch (opts.getModeCase()) {
            case READ_ONLY: {
                return DatastorePb.BeginTransactionRequest.TransactionMode.READ_ONLY;
            }
            case READ_WRITE: {
                return DatastorePb.BeginTransactionRequest.TransactionMode.READ_WRITE;
            }
            case MODE_NOT_SET: {
                return DatastorePb.BeginTransactionRequest.TransactionMode.UNKNOWN;
            }
        }
        String string = String.valueOf(opts.getModeCase());
        throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Unkown transaction mode ").append(string).toString());
    }

    public RunQueryResponse.Builder toV1RunQueryResponse(ProjectIdAppIdResolver resolver, DatastorePb.QueryResult result, @Nullable Query parsedQuery, @Nullable ByteString newTxnBytes) throws InvalidConversionException {
        RunQueryResponse.Builder builder = RunQueryResponse.newBuilder();
        builder.setBatch(this.appEngV3ToCloudDatastoreV1Converter.toV1QueryResultBatch(resolver, result));
        if (newTxnBytes != null) {
            builder.setTransaction(newTxnBytes);
        }
        if (parsedQuery != null) {
            builder.setQuery(parsedQuery);
        }
        return builder;
    }
}

