/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.exception.ValidationException;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.service.common.PropertyPathValidator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyPathToMaskConverter {
    private final PropertyPathValidator propertyPathValidator;

    public PropertyPathToMaskConverter(PropertyPathValidator propertyPathValidator) {
        this.propertyPathValidator = propertyPathValidator;
    }

    public PropertyMask validateAndConvertPathsToMask(Collection<PropertyPath> propertyPaths) throws InvalidConversionException {
        try {
            for (PropertyPath propertyPath : propertyPaths) {
                this.propertyPathValidator.validatePropertyPathForMask(propertyPath);
            }
        }
        catch (ValidationException exception) {
            throw new InvalidConversionException(exception.getMessage(), exception);
        }
        return this.convertPathsToMaskHelper(propertyPaths);
    }

    private PropertyMask convertPathsToMaskHelper(Collection<PropertyPath> propertyPaths) throws InvalidConversionException {
        boolean includeKeyPath = false;
        HashMap<PropertyName, PropertyMask> nestedMasks = new HashMap<PropertyName, PropertyMask>();
        ArrayListMultimap nestedPaths = ArrayListMultimap.create();
        for (PropertyPath propertyPath : propertyPaths) {
            boolean isEndOfPath;
            PropertyPathSegment segment = propertyPath.segment();
            InvalidConversionException.checkConversion(segment instanceof PropertyPathSegment.Member, "Property mask paths currently support only \".\".", new Object[0]);
            PropertyName propertyName = ((PropertyPathSegment.Member)segment).name();
            PropertyPath propertyPathNext = propertyPath.next();
            boolean bl = isEndOfPath = propertyPathNext == null;
            if (propertyName.special() == SpecialPropertyDescriptor.KEY) {
                includeKeyPath = true;
                continue;
            }
            if (isEndOfPath) {
                nestedMasks.put(propertyName, PropertyMask.FULL);
                nestedPaths.removeAll((Object)propertyName);
                continue;
            }
            if (nestedMasks.containsKey(propertyName)) continue;
            nestedPaths.put((Object)propertyName, (Object)propertyPathNext);
        }
        for (Map.Entry entry : nestedPaths.asMap().entrySet()) {
            PropertyName propertyName = (PropertyName)entry.getKey();
            Collection subPropertyPaths = (Collection)entry.getValue();
            nestedMasks.put(propertyName, this.convertPathsToMaskHelper(subPropertyPaths));
        }
        return new PropertyMask(includeKeyPath, nestedMasks);
    }
}

