/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.apphosting.datastore.exception.ValidationException;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;

public class PropertyPathValidator {
    public static final PropertyPathValidator INSTANCE = new PropertyPathValidator();

    protected PropertyPathValidator() {
    }

    public void validatePropertyPath(PropertyPath propertyPath) throws ValidationException {
        if (propertyPath == null) {
            return;
        }
        PropertyPath nextPropertyPath;
        while ((nextPropertyPath = propertyPath.next()) != null) {
            PropertyPathSegment segment = propertyPath.segment();
            if (!(segment instanceof PropertyPathSegment.Member)) continue;
            PropertyPathSegment.Member memberSegment = (PropertyPathSegment.Member)segment;
            ValidationException.validateAssertion(memberSegment.name().special() != SpecialPropertyDescriptor.KEY, "a property path cannot traverse the %s property", SpecialPropertyDescriptor.KEY.getPropertyName());
            propertyPath = nextPropertyPath;
        }
        return;
    }

    public void validatePropertyPathForMask(PropertyPath propertyPath) throws ValidationException {
        this.validatePropertyPath(propertyPath);
    }

    public void validatePropertyMask(PropertyMask propertyMask) throws ValidationException {
    }

    public void validatePropertyMaskForWrite(PropertyMask propertyMask) throws ValidationException {
    }
}

