/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import mediautil.gen.BasicIo;
import mediautil.gen.FileFormatException;
import mediautil.gen.Log;
import mediautil.gen.ProgressCallback;
import mediautil.gen.directio.IterativeReader;
import mediautil.gen.directio.IterativeWriter;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.BasicJpegIo;
import mediautil.image.jpeg.CIFF;
import mediautil.image.jpeg.Exif;
import mediautil.image.jpeg.Flashpix;
import mediautil.image.jpeg.IterativeReadVars;
import mediautil.image.jpeg.IterativeWriteVars;
import mediautil.image.jpeg.JFXX;
import mediautil.image.jpeg.JPEG;
import mediautil.image.jpeg.LLJTranException;
import mediautil.image.jpeg.TiffExif;

public class LLJTran
extends BasicJpegIo
implements IterativeReader,
IterativeWriter {
    public static final String JFIF = "JFIF";
    public static final String FPXR = "FPXR";
    public static final String JPEG = "JPEG";
    public static final int NONE = 0;
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final int TRANSPOSE = 3;
    public static final int TRANSVERSE = 4;
    public static final int ROT_90 = 5;
    public static final int ROT_180 = 6;
    public static final int ROT_270 = 7;
    public static final int CROP = 8;
    public static final int COMMENT = 9;
    protected static final int DCTSIZE2 = 64;
    protected static final int DCTSIZE = 8;
    protected static final int BYTE_SIZE = 8;
    private static final int HUFF_LOOKAHEAD = 8;
    public static final int READ_NONE = 0;
    public static final int READ_INFO = 1;
    public static final int READ_HEADER = 2;
    public static final int READ_ALL = 3;
    public static final int OPT_XFORM_APPX = 1;
    public static final int OPT_XFORM_THUMBNAIL = 2;
    public static final int OPT_XFORM_TRIM = 4;
    public static final int OPT_XFORM_ADJUST_EDGES = 8;
    public static final int OPT_XFORM_ORIENTATION = 16;
    public static final int OPT_WRITE_APPXS = 256;
    public static final int OPT_WRITE_COMMENTS = 512;
    public static final int OPT_WRITE_ALL = 768;
    public static final int OPT_WRITE_OPTIMIZE_HUFF = 1024;
    public static final int OPT_DEFAULTS = 777;
    public static final int REPLACE = 0;
    public static final int RETAIN = 1;
    public static final int REMOVE = 2;
    public static final int IMPERFECT_X = 1;
    public static final int IMPERFECT_Y = 2;
    protected static final int HEADER_SECTION = 2;
    protected static final int BODY_SECTION = 4;
    protected static final int INFO_SECTION = 1;
    protected static final int ALL_SECTIONS = 7;
    private static final int MAX_CLEN = 32;
    private static final int MAX_APPXS_BLOCKLEN = 1024;
    protected static final int[] jpegzigzagorder = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    protected static final int[] jpegnaturalorder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63};
    private static final byte[] stdHuffTables = new byte[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125, 1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, -127, -111, -95, 8, 35, 66, -79, -63, 21, 82, -47, -16, 36, 51, 98, 114, -126, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, 17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119, 0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, -127, 8, 20, 66, -111, -95, -79, -63, 9, 35, 51, 82, -16, 21, 98, 114, -47, 10, 22, 36, 52, -31, 37, -15, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, -126, -125, -124, -123, -122, -121, -120, -119, -118, -110, -109, -108, -107, -106, -105, -104, -103, -102, -94, -93, -92, -91, -90, -89, -88, -87, -86, -78, -77, -76, -75, -74, -73, -72, -71, -70, -62, -61, -60, -59, -58, -57, -56, -55, -54, -46, -45, -44, -43, -42, -41, -40, -39, -38, -30, -29, -28, -27, -26, -25, -24, -23, -22, -14, -13, -12, -11, -10, -9, -8, -7, -6};
    protected String artist;
    private String enc;
    private boolean partialYMCU;
    private boolean partialXMCU;
    private static final int APPXS_NONE = 0;
    private static final int APPXS_JFIF = 1;
    private static final int APPXS_JFXX = 2;
    private static final int APPXS_EXIF = 3;
    private static final int APPXS_CIFF = 4;
    private static final int APPXS_FPXR = 4;
    private int restarts_to_go;
    private HuffDecoder decoder;
    private HuffEncoder encoder;
    protected int writecounter;
    protected int readcounter;
    private boolean gatheringStats;
    private int[][] app_store;
    private int components_in_scan;
    private int components_in_frame;
    private int frm_precision;
    private int[] comp_ids;
    private int[] dc_table;
    private int[] ac_table;
    private int _Ss;
    private int _Se;
    private int _Ah;
    private int _Al;
    private int frm_x;
    private int frm_y;
    private int[] V;
    private int[] H;
    private int[] QT;
    private int[] ID;
    private int maxHi;
    private int maxVi;
    private int widthMCU;
    private int heightMCU;
    private int mcusize;
    protected int restart_interval;
    private int[][] dc_valoffset;
    private int[][] dc_maxcode;
    private int[][] dc_huffval;
    private int[] dc_ix;
    private int[][] ac_valoffset;
    private int[][] ac_maxcode;
    private int[][] ac_huffval;
    private int[][] dc_huffbits;
    private int[][] ac_huffbits;
    private int[] ac_ix;
    private int[][] q_table;
    private int[] q_ix;
    private int[] q_prec;
    private int[][][][][] dct_coefs;
    protected int[][] tmp_dct = new int[2][64];
    private Rectangle cropBounds = new Rectangle();
    private int[][][] enc_ac_matrix;
    private int[][][] enc_dc_matrix;
    private HuffGenerator huffGen;
    private ProgressCallback readProgressCallback;
    private ProgressCallback writeProgressCallback;
    protected int unprocessed_marker;
    private String unprocessedError;
    private boolean xferDone = false;
    protected boolean valid;
    protected boolean canBeProcessed;
    protected int readUpto;
    protected File file;
    protected InputStream inStream;
    protected InputStream currentStream;
    protected byte[] markerid;
    protected AbstractImageInfo imageinfo;
    protected byte[][] appxs;
    private int appHdrIndex = -1;
    protected String out_comment;
    protected boolean appxs_read;
    protected boolean retainDct;
    private byte prevHuffOption;
    private IterativeReadVars iReadVars;
    private IterativeWriteVars iWriteVars;
    private Exception lljtError;
    private String errorMsg;
    private static final String[] uptoName = new String[]{"None", "Info", "Header", "Body"};
    public static final byte[] dummyExifHeader = new byte[]{-1, -31, 3, 55, 69, 120, 105, 102, 0, 0, 73, 73, 42, 0, 8, 0, 0, 0, 9, 0, 40, 1, 3, 0, 1, 0, 0, 0, 2, 0, 0, 0, 18, 1, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 50, 1, 2, 0, 20, 0, 0, 0, 122, 0, 0, 0, 27, 1, 5, 0, 1, 0, 0, 0, -114, 0, 0, 0, 16, 1, 2, 0, 21, 0, 0, 0, -106, 0, 0, 0, 26, 1, 5, 0, 1, 0, 0, 0, -85, 0, 0, 0, 15, 1, 2, 0, 8, 0, 0, 0, -77, 0, 0, 0, 19, 2, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 105, -121, 4, 0, 1, 0, 0, 0, -69, 0, 0, 0, -23, 2, 0, 0, 50, 48, 48, 50, 58, 48, 51, 58, 49, 56, 32, 49, 52, 58, 48, 56, 58, 52, 52, 0, -76, 0, 0, 0, 1, 0, 0, 0, 85, 110, 107, 110, 111, 119, 110, 32, 102, 114, 111, 109, 32, 76, 76, 74, 84, 114, 97, 110, 0, -76, 0, 0, 0, 1, 0, 0, 0, 85, 110, 107, 110, 111, 119, 110, 0, 30, 0, 23, -94, 3, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, -93, 7, 0, 1, 0, 0, 0, 3, 0, 0, 0, 2, -111, 5, 0, 1, 0, 0, 0, 41, 2, 0, 0, 1, -111, 7, 0, 4, 0, 0, 0, 1, 2, 3, 0, 16, -94, 3, 0, 1, 0, 0, 0, 2, 0, 0, 0, 15, -94, 5, 0, 1, 0, 0, 0, 49, 2, 0, 0, 14, -94, 5, 0, 1, 0, 0, 0, 57, 2, 0, 0, 3, -96, 3, 0, 1, 0, 0, 0, -80, 4, 0, 0, 2, -96, 3, 0, 1, 0, 0, 0, 64, 6, 0, 0, 1, -96, 3, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, -96, 7, 0, 4, 0, 0, 0, 48, 49, 48, 48, 10, -110, 5, 0, 1, 0, 0, 0, 65, 2, 0, 0, 9, -110, 3, 0, 1, 0, 0, 0, 16, 0, 0, 0, -99, -126, 5, 0, 1, 0, 0, 0, 73, 2, 0, 0, 4, -112, 2, 0, 20, 0, 0, 0, 81, 2, 0, 0, 6, -92, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, -112, 2, 0, 20, 0, 0, 0, 101, 2, 0, 0, 7, -110, 3, 0, 1, 0, 0, 0, 5, 0, 0, 0, 4, -92, 5, 0, 1, 0, 0, 0, 121, 2, 0, 0, -102, 82, 5, 0, 1, 0, 0, 0, -127, 2, 0, 0, 3, -92, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 5, -110, 5, 0, 1, 0, 0, 0, -119, 2, 0, 0, 0, -112, 7, 0, 4, 0, 0, 0, 48, 50, 50, 48, 2, -92, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 4, -110, 10, 0, 1, 0, 0, 0, -111, 2, 0, 0, 1, -92, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 2, -110, 5, 0, 1, 0, 0, 0, -103, 2, 0, 0, 1, -110, 10, 0, 1, 0, 0, 0, -95, 2, 0, 0, -122, -110, 7, 0, 10, 0, 0, 0, -87, 2, 0, 0, 5, -96, 4, 0, 1, 0, 0, 0, -77, 2, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, -128, 79, 18, 0, -101, 0, 0, 0, 0, 106, 24, 0, -50, 0, 0, 0, 6, 2, 0, 0, 32, 0, 0, 0, -116, 0, 0, 0, 10, 0, 0, 0, 50, 48, 48, 50, 58, 48, 51, 58, 49, 56, 32, 49, 52, 58, 48, 56, 58, 52, 52, 0, 50, 48, 48, 50, 58, 48, 51, 58, 49, 56, 32, 49, 52, 58, 48, 56, 58, 52, 52, 0, 64, 6, 0, 0, 64, 6, 0, 0, 1, 0, 0, 0, 100, 0, 0, 0, -118, -8, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 3, 0, 0, 0, 94, -99, 7, 0, 0, 0, 1, 0, -43, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 2, 16, 3, 0, 1, 0, 0, 0, -80, 4, 0, 0, 1, 16, 3, 0, 1, 0, 0, 0, 64, 6, 0, 0, 2, 0, 7, 0, 4, 0, 0, 0, 48, 49, 48, 48, 1, 0, 2, 0, 4, 0, 0, 0, 82, 57, 56, 0, 0, 0, 0, 0, 4, 0, 40, 1, 3, 0, 1, 0, 0, 0, 2, 0, 0, 0, 27, 1, 5, 0, 1, 0, 0, 0, 31, 3, 0, 0, 26, 1, 5, 0, 1, 0, 0, 0, 39, 3, 0, 0, 3, 1, 3, 0, 1, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, -76, 0, 0, 0, 1, 0, 0, 0, -76, 0, 0, 0, 1, 0, 0, 0};
    public static final String PROGRAMNAME = "LLJTran";

    private void commonInit() {
        this.iWriteVars = new IterativeWriteVars();
        this.iReadVars = new IterativeReadVars();
    }

    public LLJTran(File file) {
        this.commonInit();
        this.file = file;
        this.markerid = new byte[2];
        this.prevHuffOption = (byte)-1;
        this.readProgressCallback = null;
        this.writeProgressCallback = null;
    }

    public LLJTran(InputStream inStream) {
        this.commonInit();
        this.markerid = new byte[2];
        this.inStream = inStream;
        this.prevHuffOption = (byte)-1;
        this.readProgressCallback = null;
        this.writeProgressCallback = null;
    }

    public void resetInput(InputStream inStream) {
        if (this.readUpto > 1) {
            throw new RuntimeException("Restting Input not allowed if current input read beyond READ_INFO");
        }
        if (inStream == null) {
            if (this.file == null) {
                throw new RuntimeException("inStream null and no existing file to read from");
            }
        } else {
            this.file = null;
        }
        this.closeInternalInputStream();
        this.inStream = inStream;
        this.readUpto = 0;
        this.unprocessed_marker = 0;
    }

    public void resetInput(File file) {
        if (this.readUpto > 1) {
            throw new RuntimeException("Restting Input not allowed if current input read beyond READ_INFO");
        }
        this.closeInternalInputStream();
        this.file = file;
        this.inStream = null;
        this.readUpto = 0;
        this.unprocessed_marker = 0;
    }

    public void setEncoding(String enc) {
        this.enc = enc;
    }

    public String getEncoding() {
        return this.enc;
    }

    public String getName() {
        if (this.file == null) {
            return "Unknown/Stream";
        }
        return this.file.getName();
    }

    public String toString() {
        return this.getName();
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object o) {
        return o instanceof LLJTran && ((LLJTran)o).getFile().equals(this.file);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getPendingErrorMsg() {
        return this.unprocessedError;
    }

    protected void setErrorMsg(String msg) {
        this.errorMsg = msg;
    }

    public Exception getException() {
        return this.lljtError;
    }

    protected void setException(Exception e) {
        this.lljtError = e;
    }

    protected InputStream createInputStream() {
        block4: {
            try {
                if (!this.valid) break block4;
                this.readcounter = 0;
                this.writecounter = 0;
                if (this.file == null) {
                    if (this.inStream != null) {
                        return this.inStream;
                    }
                    this.valid = false;
                    break block4;
                }
                return new BufferedInputStream(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e) {
                this.valid = false;
            }
        }
        return null;
    }

    public AbstractImageInfo getImageInfo() {
        return this.imageinfo;
    }

    public String getComment() {
        return this.out_comment;
    }

    public void setComment(String comment) {
        this.out_comment = comment;
    }

    public String getLocationName() {
        return this.file == null ? null : this.file.getAbsolutePath();
    }

    public void setReadProgressCallback(ProgressCallback callback) {
        this.readProgressCallback = callback;
    }

    public void setWriteProgressCallback(ProgressCallback callback) {
        this.writeProgressCallback = callback;
    }

    public ProgressCallback getReadProgressCallback() {
        return this.readProgressCallback;
    }

    public ProgressCallback getWriteProgressCallback() {
        return this.writeProgressCallback;
    }

    protected boolean transformAppHeader(int op, int options, boolean modifyImageInfo) {
        boolean retVal = false;
        if (this.imageinfo != null && this.appxs != null && this.appHdrIndex >= 0) {
            try {
                ByteArrayOutputStream buf = new ByteArrayOutputStream(2048);
                buf.write(this.markerid);
                buf.write(this.markerid);
                this.imageinfo.writeInfo(this.appxs[this.appHdrIndex], buf, op, options, modifyImageInfo, this.frm_x, this.frm_y);
                int len = buf.size() - 4;
                if (len > 0) {
                    byte appCode = this.appxs[this.appHdrIndex][1];
                    this.appxs[this.appHdrIndex] = buf.toByteArray();
                    this.appxs[this.appHdrIndex][0] = -1;
                    this.appxs[this.appHdrIndex][1] = appCode;
                    LLJTran.bn2s(this.appxs[this.appHdrIndex], 2, len + 2, 2);
                    retVal = true;
                } else if (Log.debugLevel >= 2) {
                    System.err.println("Warning: transform: Unable to transform App Hdr possibly because the format is not fully supported");
                }
                buf.close();
                buf = null;
            }
            catch (Exception e) {
                if (Log.debugLevel >= 1) {
                    e.printStackTrace(System.err);
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        return retVal;
    }

    private void validateCropBounds(Rectangle bounds) {
        if (bounds.width <= 0 || bounds.height <= 0 || bounds.x < 0 || bounds.x >= this.frm_x || bounds.y < 0 || bounds.y >= this.frm_y) {
            throw new ArrayIndexOutOfBoundsException("Invalid Crop Request");
        }
        int xBoundary = this.getMCUWidth();
        int yBoundary = this.getMCUHeight();
        int rem = bounds.x % xBoundary;
        this.cropBounds.x = bounds.x - rem;
        if (rem > xBoundary / 2 && this.cropBounds.x + xBoundary < this.frm_x) {
            this.cropBounds.x += xBoundary;
        }
        rem = bounds.y % yBoundary;
        this.cropBounds.y = bounds.y - rem;
        if (rem > yBoundary / 2 && this.cropBounds.y + yBoundary < this.frm_y) {
            this.cropBounds.y += yBoundary;
        }
        this.cropBounds.width = this.cropBounds.x + bounds.width > this.frm_x ? this.frm_x - this.cropBounds.x : bounds.width;
        this.cropBounds.height = this.cropBounds.y + bounds.height > this.frm_y ? this.frm_y - this.cropBounds.y : bounds.height;
    }

    public int checkPerfect(int op, Rectangle cropBounds) {
        int retVal = 0;
        int xBoundary = this.getMCUWidth();
        int yBoundary = this.getMCUHeight();
        if (op == 8) {
            if (cropBounds.x % xBoundary != 0) {
                retVal |= 1;
            }
            if (cropBounds.y % yBoundary != 0) {
                retVal |= 2;
            }
        }
        if ((op == 7 || op == 4 || op == 6 || op == 1) && this.frm_x % xBoundary != 0) {
            retVal |= 1;
        }
        if ((op == 5 || op == 4 || op == 6 || op == 2) && this.frm_y % yBoundary != 0) {
            retVal |= 2;
        }
        return retVal;
    }

    public void transform(int op) {
        this.transform(op, 777);
    }

    public void transform(int op, int options) {
        if (op == 8) {
            op = 0;
        }
        this.transform(op, options, null);
    }

    public void transform(int op, int options, Rectangle bounds) {
        block10: {
            this.prevHuffOption = (byte)-1;
            if (this.readUpto < 3) {
                throw new RuntimeException("Transform cannot be performed since No Jpeg has been successfully Read");
            }
            if ((options & 1) == 0) {
                options &= 0xFFFFFFFD;
            }
            if ((options & 2) != 0 && !this.appxs_read && Log.debugLevel >= 2) {
                System.err.println("Warning: Thumbnail transformation cannot be performed since keep_appxs was passed as false while reading");
            }
            if (op == 8) {
                this.validateCropBounds(bounds);
            }
            this.adjustImageParameters(op, options);
            switch (op) {
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.transposeImageParameters();
                    this.transposeQTable();
                    break;
                }
            }
            try {
                if ((options & 1) != 0) {
                    this.transformAppHeader(op, options, true);
                }
                this.writeDCT(null, op, options, 0, true);
            }
            catch (IOException e) {
                if (Log.debugLevel < 1) break block10;
                String string = String.valueOf(e.getMessage());
                System.err.println(string.length() != 0 ? "Warning:transform: Exception while transforming Thumbnail: ".concat(string) : new String("Warning:transform: Exception while transforming Thumbnail: "));
                e.printStackTrace(System.err);
            }
        }
    }

    public void transform(OutputStream outStream, int op) throws IOException {
        this.transform(outStream, op, 777);
    }

    public void transform(OutputStream outStream, int op, int options) throws IOException {
        if (op == 8) {
            op = 0;
        }
        this.transform(outStream, op, options, null);
    }

    public void transform(OutputStream outStream, int op, int options, Rectangle bounds) throws IOException {
        this.transform(outStream, op, options, bounds, 0);
    }

    public void transform(OutputStream outStream, int op, int options, Rectangle bounds, int restart_interval) throws IOException {
        this.transform(outStream, op, options, bounds, restart_interval, null);
    }

    public IterativeWriter initWrite(OutputStream outStream, int op, int options, Rectangle bounds, int restart_interval) throws IOException {
        return this.initWrite(outStream, op, options, bounds, restart_interval, false);
    }

    public IterativeWriter initWrite(OutputStream outStream, int op, int options, Rectangle bounds, int restart_interval, boolean pullDownMode) throws IOException {
        return this.initWrite(outStream, op, options, bounds, restart_interval, pullDownMode, null);
    }

    protected IterativeWriter initWrite(OutputStream outStream, int op, int options, Rectangle bounds, int restart_interval, boolean pullDownMode, Class custom_appx) throws IOException {
        boolean writeAppxs;
        this.prevHuffOption = (byte)-1;
        this.iWriteVars.maxWriteRequest = 0;
        this.iWriteVars.minWriteRequest = 100000000;
        this.iWriteVars.restoreVars = true;
        this.iWriteVars.saveAppxs = null;
        boolean bl = writeAppxs = (options & 0x100) != 0;
        if (op == 0 || !writeAppxs) {
            options &= 0xFFFFFFFE;
        }
        if ((options & 1) == 0) {
            options &= 0xFFFFFFFD;
        }
        if (this.readUpto < 3) {
            throw new RuntimeException("Transform cannot be performed since No Jpeg has been successfully Read");
        }
        if (op == 8) {
            this.validateCropBounds(bounds);
        }
        if (!this.appxs_read) {
            if ((options & 2) != 0 && Log.debugLevel >= 2) {
                System.err.println("Warning:transform: Thumbnail transformation cannot be performed since keep_appxs was passed as false while reading");
            }
            if (writeAppxs && Log.debugLevel >= 2) {
                System.err.println("Warning:transform: Cannot write APPXS since keep_appxs was passed as false while reading");
            }
        }
        if (op != 0) {
            this.iWriteVars.svX = this.frm_x;
            this.iWriteVars.svY = this.frm_y;
            this.iWriteVars.svWidthMCU = this.widthMCU;
            this.iWriteVars.svHeightMCU = this.heightMCU;
            this.adjustImageParameters(op, options);
            switch (op) {
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.transposeImageParameters();
                    this.transposeQTable();
                    break;
                }
            }
            if ((options & 1) != 0 && this.appxs != null && this.appHdrIndex >= 0) {
                this.iWriteVars.saveAppxs = this.appxs[this.appHdrIndex];
                this.transformAppHeader(op, options, false);
            }
        }
        return this.initWriteJpeg(outStream, op, null, options, custom_appx, restart_interval, pullDownMode);
    }

    public void wrapupIterativeWrite(IterativeWriter writer) {
        if (this.iWriteVars.state != 7) {
            if (this.iWriteVars.restoreVars && this.iWriteVars.op != 0) {
                switch (this.iWriteVars.op) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        this.transposeImageParameters();
                        this.transposeQTable();
                        break;
                    }
                }
                if (this.iWriteVars.saveAppxs != null) {
                    this.appxs[this.appHdrIndex] = this.iWriteVars.saveAppxs;
                }
                this.frm_x = this.iWriteVars.svX;
                this.frm_y = this.iWriteVars.svY;
                this.widthMCU = this.iWriteVars.svWidthMCU;
                this.heightMCU = this.iWriteVars.svHeightMCU;
            }
            this.iWriteVars.freeMemory();
            this.iWriteVars.state = 7;
        }
    }

    protected void transform(OutputStream outStream, int op, int options, Rectangle bounds, int restart_interval, Class custom_appx) throws IOException {
        this.initWrite(outStream, op, options, bounds, restart_interval, false, custom_appx);
        while (this.nextWrite(10000000) == 0) {
        }
    }

    private byte[] generateHuffTables(HuffGenerator huff) throws IOException {
        if (huff != null) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            huff.writeHuffTables(bs);
            this.data = bs.toByteArray();
        } else {
            this.data = stdHuffTables;
        }
        this.dc_valoffset = new int[0][0];
        this.dc_maxcode = new int[0][0];
        this.dc_huffval = new int[0][0];
        this.enc_dc_matrix = new int[0][][];
        this.dc_huffbits = new int[0][0];
        this.dc_ix = new int[0];
        this.ac_valoffset = new int[0][0];
        this.ac_maxcode = new int[0][0];
        this.ac_huffval = new int[0][0];
        this.enc_ac_matrix = new int[0][][];
        this.ac_huffbits = new int[0][0];
        this.ac_ix = new int[0];
        this.readDHT(null, this.data.length);
        byte[] retVal = this.data;
        this.data = null;
        return retVal;
    }

    public void save(OutputStream os) throws IOException {
        this.save(os, 777, 0);
    }

    public void save(OutputStream os, int options) throws IOException {
        this.save(os, options, 0);
    }

    public void save(OutputStream os, int options, int restart_interval) throws IOException {
        boolean writeAppxs;
        boolean bl = writeAppxs = (options & 0x100) != 0;
        if (this.readUpto < 3) {
            throw new RuntimeException("Jpeg cannot be written since No Jpeg has been successfully Read");
        }
        if (writeAppxs && !this.appxs_read && Log.debugLevel >= 2) {
            System.err.println("Warning:save: Cannot write APPXS since keep_appxs was passed as false while reading");
        }
        IterativeWriter iWriter = this.initWrite(os, 0, options, null, restart_interval);
        while (iWriter.nextWrite(10000000) == 0) {
        }
    }

    public int writeThumbnail(OutputStream out) throws IOException {
        int len;
        int offset;
        int retVal = 0;
        if (this.appxs != null && this.appHdrIndex >= 0 && this.imageinfo != null && (offset = this.imageinfo.getThumbnailOffset()) > 0 && (len = this.imageinfo.getThumbnailLength()) > 0) {
            out.write(this.appxs[this.appHdrIndex], offset + 4, len);
            retVal = len;
        }
        return retVal;
    }

    public InputStream getThumbnailAsStream() {
        int len;
        int offset;
        ByteArrayInputStream retVal = null;
        if (this.appxs != null && this.appHdrIndex >= 0 && this.imageinfo != null && (offset = this.imageinfo.getThumbnailOffset()) > 0 && (len = this.imageinfo.getThumbnailLength()) > 0) {
            retVal = new ByteArrayInputStream(this.appxs[this.appHdrIndex], offset + 4, len);
        }
        return retVal;
    }

    public boolean setThumbnail(byte[] newThumbnailData, int startIndex, int len, String thumbnailExt) throws IOException {
        boolean retVal = false;
        if (len > 45000) {
            throw new IOException("Size of Thumbnail is greater than 45000 bytes");
        }
        if (this.appxs != null && this.appHdrIndex >= 0 && this.imageinfo != null) {
            int bytesWritten;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(2048);
            buf.write(this.markerid);
            buf.write(this.markerid);
            if (this.imageinfo.setThumbnail(newThumbnailData, startIndex, len, thumbnailExt, buf) && (bytesWritten = buf.size() - 4) > 0) {
                byte[] newAppxs = buf.toByteArray();
                newAppxs[0] = -1;
                newAppxs[1] = this.appxs[this.appHdrIndex][1];
                LLJTran.bn2s(newAppxs, 2, newAppxs.length - 2, 2);
                this.appxs[this.appHdrIndex] = newAppxs;
                retVal = true;
            }
        }
        return retVal;
    }

    public boolean refreshAppx() {
        boolean retVal = false;
        if (this.imageinfo != null) {
            retVal = this.transformAppHeader(0, 0, true);
        }
        return retVal;
    }

    public boolean removeThumbnail() {
        boolean retVal = false;
        if (this.imageinfo != null && this.imageinfo.removeThumbnailTags()) {
            retVal = this.transformAppHeader(0, 0, true);
        }
        return retVal;
    }

    private void adjustImageParameters(int op, int options) {
        int xBoundary = this.getMCUWidth();
        int yBoundary = this.getMCUHeight();
        if (op == 8) {
            this.frm_x = this.cropBounds.width;
            this.frm_y = this.cropBounds.height;
            this.widthMCU = (this.frm_x + xBoundary - 1) / xBoundary;
            this.heightMCU = (this.frm_y + yBoundary - 1) / yBoundary;
        }
        int yMCURem = this.frm_y % yBoundary;
        int xMCURem = this.frm_x % xBoundary;
        this.partialYMCU = yMCURem != 0;
        boolean bl = this.partialXMCU = xMCURem != 0;
        if ((options & 4) != 0) {
            if (this.partialYMCU && (op == 5 || op == 4 || op == 6 || op == 2) && this.heightMCU > 1) {
                this.partialYMCU = false;
                this.frm_y -= yMCURem;
                --this.heightMCU;
            }
            if (this.partialXMCU && (op == 7 || op == 4 || op == 6 || op == 1) && this.widthMCU > 1) {
                this.partialXMCU = false;
                this.frm_x -= xMCURem;
                --this.widthMCU;
            }
        }
    }

    protected void writeJpeg(OutputStream os, int op, String comment, int options, Rectangle bounds, Class custom_appx, int restart_interval, boolean pullDownMode) throws IOException {
        if (op == 8) {
            this.validateCropBounds(bounds);
        }
        this.initWriteJpeg(os, op, comment, options, custom_appx, restart_interval, pullDownMode);
        this.iWriteVars.restoreVars = false;
        while (this.nextWrite(10000000) == 0) {
        }
        if (Log.debugLevel >= 3) {
            String string = String.valueOf(Integer.toHexString(this.writecounter));
            int n = this.writecounter;
            System.out.println(new StringBuilder(44 + String.valueOf(string).length()).append("0x").append(string).append("(").append(n).append(") byte(s) Written Successfully").toString());
        }
    }

    private IterativeWriter initWriteJpeg(OutputStream os, int op, String comment, int options, Class custom_appx, int restart_interval, boolean pullDownMode) throws IOException {
        if (pullDownMode && (op == 5 || op == 7 || op == 3 || op == 4)) {
            throw new RuntimeException(new StringBuilder(73).append("PullDownMode not allowed for Vertical<->Horizontal transform: ").append(op).toString());
        }
        this.writecounter = 0;
        HuffGenerator lHuffGen = null;
        byte optimizeHuff = (byte)((options & 0x400) != 0 ? 1 : 0);
        byte[] huffTables = null;
        this.iWriteVars.os = os;
        this.iWriteVars.op = op;
        this.iWriteVars.comment = comment;
        this.iWriteVars.options = options;
        this.iWriteVars.custom_appx = custom_appx;
        this.iWriteVars.restart_interval = restart_interval;
        this.iWriteVars.pullDownMode = pullDownMode;
        if (this.canBeProcessed && this.prevHuffOption != optimizeHuff) {
            this.prevHuffOption = optimizeHuff;
            if (optimizeHuff != 0) {
                block7: {
                    if (this.huffGen == null) {
                        this.huffGen = new HuffGenerator();
                    }
                    this.huffGen.init();
                    this.gatheringStats = true;
                    try {
                        this.writeDCT(null, op, options, 0, false);
                    }
                    catch (IOException e) {
                        if (Log.debugLevel < 1) break block7;
                        String string = String.valueOf(e.getMessage());
                        System.err.println(string.length() != 0 ? "Totally Unexpected IOException: ".concat(string) : new String("Totally Unexpected IOException: "));
                        e.printStackTrace(System.err);
                    }
                }
                this.gatheringStats = false;
                lHuffGen = this.huffGen;
            }
            huffTables = this.generateHuffTables(lHuffGen);
            if (lHuffGen != null) {
                lHuffGen.freeMemory();
            }
        }
        this.iWriteVars.huffTables = huffTables;
        this.iWriteVars.state = 0;
        return this;
    }

    @Override
    public int nextWrite(int numBytes) throws IOException {
        if (this.iWriteVars.state == 7) {
            throw new IllegalStateException("nextWrite Called without initialization or after write completion");
        }
        if (numBytes > this.iWriteVars.maxWriteRequest) {
            this.iWriteVars.maxWriteRequest = numBytes;
        }
        if (numBytes < this.iWriteVars.minWriteRequest) {
            this.iWriteVars.minWriteRequest = numBytes;
        }
        OutputStream os = this.iWriteVars.os;
        int op = this.iWriteVars.op;
        int options = this.iWriteVars.options;
        int restart_interval = this.iWriteVars.restart_interval;
        int nextState = this.iWriteVars.state;
        int markCounter = this.writecounter;
        int remaining = numBytes;
        do {
            switch (nextState) {
                case 0: {
                    this.writeMarkerSOI(os);
                    nextState = 1;
                    if ((options & 0x100) == 0) break;
                    nextState = 2;
                    this.writeNewMarker(os, this.iWriteVars.custom_appx);
                    this.initWriteMarkerAppXs();
                    break;
                }
                case 2: {
                    if (this.writeNextMarkerAppXs(remaining)) break;
                    nextState = 1;
                    break;
                }
                case 1: {
                    nextState = 3;
                    if ((options & 0x200) != 0) {
                        if (this.iWriteVars.comment == null || this.iWriteVars.comment.length() == 0) {
                            this.writeMarkerComment(os, this.out_comment, this.enc);
                            break;
                        }
                        this.writeMarkerComment(os, this.iWriteVars.comment, this.enc);
                        break;
                    }
                }
                case 3: {
                    this.writeMarkerDQT(os);
                    nextState = 4;
                    break;
                }
                case 4: {
                    this.writeMarkerDHT(os, this.iWriteVars.huffTables);
                    this.writeMarkerDRI(os, restart_interval);
                    nextState = this.canBeProcessed ? 5 : 7;
                    break;
                }
                case 5: {
                    this.writeMarkerSOF0(os);
                    this.writeMarkerSOS(os);
                    this.initWriteDCT(os, op, options, restart_interval, false);
                    nextState = 6;
                    break;
                }
                case 6: {
                    if (this.writeNextDCT(remaining)) break;
                    this.writeMarkerEOI(os);
                    nextState = 7;
                }
            }
        } while ((remaining = numBytes - (this.writecounter - markCounter)) > 0 && nextState != 7);
        int retVal = 0;
        if (nextState == 7) {
            if (this.iWriteVars.pullDownMode) {
                this.freeMemory();
            } else {
                this.wrapupIterativeWrite(this);
            }
            retVal = 1;
        }
        this.iWriteVars.state = nextState;
        return retVal;
    }

    public void freeMemory() {
        this.dct_coefs = null;
        this.dc_valoffset = null;
        this.dc_maxcode = null;
        this.dc_huffval = null;
        this.enc_dc_matrix = null;
        this.dc_huffbits = null;
        this.dc_ix = null;
        this.ac_valoffset = null;
        this.ac_maxcode = null;
        this.ac_huffval = null;
        this.enc_ac_matrix = null;
        this.ac_huffbits = null;
        this.ac_ix = null;
        this.q_table = null;
        this.q_ix = null;
        this.q_prec = null;
        this.appxs = null;
        this.appHdrIndex = -1;
        this.encoder = null;
        this.closeInternalInputStream();
    }

    private void allocateTables() {
        this.dc_valoffset = new int[0][0];
        this.dc_maxcode = new int[0][0];
        this.dc_huffval = new int[0][0];
        this.enc_dc_matrix = new int[0][][];
        this.dc_huffbits = new int[0][0];
        this.dc_ix = new int[0];
        this.ac_valoffset = new int[0][0];
        this.ac_maxcode = new int[0][0];
        this.ac_huffval = new int[0][0];
        this.enc_ac_matrix = new int[0][][];
        this.ac_huffbits = new int[0][0];
        this.ac_ix = new int[0];
        this.q_table = new int[0][0];
        this.q_ix = new int[0];
        this.q_prec = new int[0];
    }

    public void read(boolean keep_appxs) throws LLJTranException {
        this.read(3, keep_appxs);
    }

    private int processAppMarker(byte[] markerData, int offset, AbstractImageInfo[] imageinfo, boolean[] retHandledAppHdr) throws FileFormatException {
        boolean handledAppHdr = false;
        int markerType = 0;
        if (LLJTran.isSignature(markerData, offset, JFIF)) {
            markerType = 1;
            int version = this.bs2i(5, 2);
            int units = this.bs2i(7, 1);
            int xden = this.bs2i(8, 2);
            int yden = this.bs2i(10, 2);
            int x = this.bs2i(12, 1);
            int y = this.bs2i(13, 1);
            int thumbnailsize = 3 * x * y;
            if (x > 0 && y > 0 && Log.debugLevel >= 3) {
                System.out.println(new StringBuilder(41).append("Thumbnail ").append(x).append("x").append(y).append(" in APP0").toString());
            }
        } else if (LLJTran.isSignature(markerData, offset, "JFXX")) {
            markerType = 2;
            handledAppHdr = true;
        } else if (LLJTran.isSignature(markerData, offset, "Exif")) {
            markerType = 3;
            handledAppHdr = true;
        } else if ((LLJTran.isSignature(markerData, offset, "II") || LLJTran.isSignature(markerData, offset, "MM")) && LLJTran.isSignature(markerData, offset + 6, "HEAP")) {
            markerType = 4;
            handledAppHdr = true;
        } else if (LLJTran.isSignature(markerData, offset, FPXR)) {
            markerType = 4;
        }
        if (retHandledAppHdr != null) {
            retHandledAppHdr[0] = handledAppHdr;
        }
        if (imageinfo != null && handledAppHdr) {
            if (offset != 0) {
                byte[] newData = new byte[markerData.length - offset];
                System.arraycopy(markerData, offset, newData, 0, markerData.length - offset);
                markerData = newData;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(markerData);
            switch (markerType) {
                case 2: {
                    imageinfo[0] = new JFXX((InputStream)is, markerData, this.readcounter, this.getName(), this.out_comment, this);
                    break;
                }
                case 3: {
                    imageinfo[0] = new Exif((InputStream)is, markerData, this.readcounter, this.getName(), this.out_comment, this);
                    break;
                }
                case 4: {
                    imageinfo[0] = new CIFF((InputStream)is, markerData, this.readcounter, this.getName(), this.out_comment, this);
                    break;
                }
            }
        }
        return markerType;
    }

    private String initReadInternal(int sections, boolean keep_appxs, boolean throwException) {
        String retVal = null;
        this.iReadVars.maxReadRequest = 0;
        this.iReadVars.minReadRequest = 100000000;
        this.iReadVars.sections = sections &= 7;
        this.iReadVars.keep_appxs = keep_appxs;
        this.iReadVars.throwException = throwException;
        this.iReadVars.appxsCleared = false;
        this.appxs_read = keep_appxs;
        if (this.unprocessed_marker == 0 && (sections & 2) == 0 && (sections & 4) != 0) {
            retVal = "Attempt to Read only the Body section when Header has not been successfully read";
        }
        if (this.out_comment == null) {
            this.out_comment = "";
        }
        if (this.file != null) {
            this.valid = this.file.isFile();
        } else {
            boolean bl = this.valid = this.inStream != null;
        }
        if (retVal == null && !this.valid) {
            String string = String.valueOf(this.getName());
            String string2 = retVal = string.length() != 0 ? "Invalid input: ".concat(string) : new String("Invalid input: ");
        }
        if (this.xferDone) {
            retVal = "Cannot Read Further, Input has been Transferred using xferInfo()";
        }
        if (retVal == null) {
            InputStream is = this.currentStream;
            if (is == null) {
                is = this.createInputStream();
            }
            this.iReadVars.is = is;
            if (this.valid) {
                this.currentStream = is;
                this.valid = false;
                this.canBeProcessed = true;
            } else {
                String string = String.valueOf(this.getName());
                retVal = string.length() != 0 ? "Unable to Read from input: ".concat(string) : new String("Unable to Read from input: ");
            }
        }
        this.iReadVars.stage = 1;
        return retVal;
    }

    public void initRead(int readUpto, boolean keep_appxs, boolean throwException) throws LLJTranException {
        String msg = null;
        if (readUpto < 1 || readUpto > 3) {
            msg = new StringBuilder(60).append("Error:read: Invalid value ").append(readUpto).append(" for parameter readUpto").toString();
        } else if (readUpto <= this.readUpto) {
            if (Log.debugLevel >= 2) {
                String string = String.valueOf(uptoName[this.readUpto]);
                System.err.println(new StringBuilder(69 + String.valueOf(string).length()).append("Warning:initRead: Have already read ").append(string).append(", Exitting without doing anything").toString());
            }
        } else if (this.unprocessedError != null) {
            msg = this.unprocessedError;
        } else {
            int sections = 0;
            if (this.readUpto < 1) {
                sections = 1;
            }
            if (readUpto >= 2) {
                if (this.readUpto < 2) {
                    sections |= 2;
                }
                if (readUpto >= 3) {
                    sections |= 4;
                }
            }
            this.iReadVars.readUpto = readUpto;
            msg = this.initReadInternal(sections, keep_appxs, throwException);
            if (msg != null) {
                String string = String.valueOf(msg);
                String string2 = msg = string.length() != 0 ? "Error:initRead: ".concat(string) : new String("Error:initRead: ");
            }
        }
        if (msg != null) {
            throw new LLJTranException(msg);
        }
    }

    private void wrapupIterativeRead() {
        this.readUpto = this.iReadVars.readUpto;
    }

    public void read(int readUpto, boolean keep_appxs) throws LLJTranException {
        this.initRead(readUpto, keep_appxs, false);
        try {
            while (this.nextRead(10000000) == 0) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String msg = this.getErrorMsg();
        if (msg != null) {
            throw new LLJTranException(msg);
        }
    }

    public int getReadUpto() {
        return this.readUpto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextRead(int numBytes) throws IOException {
        int stage;
        int retVal;
        String msg;
        int sections;
        block101: {
            InputStream is = this.iReadVars.is;
            boolean keep_appxs = this.iReadVars.keep_appxs;
            sections = this.iReadVars.sections;
            msg = null;
            retVal = 0;
            int remaining = numBytes;
            stage = this.iReadVars.stage;
            if (numBytes > this.iReadVars.maxReadRequest) {
                this.iReadVars.maxReadRequest = numBytes;
            }
            if (numBytes < this.iReadVars.minReadRequest) {
                this.iReadVars.minReadRequest = numBytes;
            }
            int markCounter = this.readcounter;
            try {
                block29: while (sections != 0) {
                    block104: {
                        int len;
                        Object curImageInfo;
                        Object handledAppHdr;
                        block105: {
                            block103: {
                                if (this.unprocessedError != null) {
                                    msg = this.unprocessedError;
                                    break;
                                }
                                if (stage < 1 || stage >= 5) {
                                    msg = "read: nextRead called without initRead or called after completion of read";
                                    break;
                                }
                                if (stage != 2) break block103;
                                if (this.readNextDCT(remaining)) break block104;
                                stage = 4;
                            }
                            if (stage != 3) break block105;
                            if (this.readNextAppx(remaining)) break block104;
                            stage = 1;
                            if (keep_appxs) {
                                String string;
                                int markerType;
                                this.addAppx();
                                handledAppHdr = new boolean[1];
                                if (sections == 1) {
                                    this.valid = true;
                                }
                                if (Log.debugLevel >= 4) {
                                    String string2 = String.valueOf(new String(this.data, 0, 4));
                                    System.out.println(string2.length() != 0 ? "Signature ".concat(string2) : new String("Signature "));
                                }
                                curImageInfo = null;
                                if ((sections & 1) != 0) {
                                    curImageInfo = new AbstractImageInfo[1];
                                }
                                if ((markerType = this.processAppMarker(this.data, 4, (AbstractImageInfo[])curImageInfo, (boolean[])handledAppHdr)) == 0 && this.imageinfo == null) {
                                    len = this.data.length;
                                    if (Log.debugLevel >= 4) {
                                        string = String.valueOf(Integer.toHexString(this.markerid[1]));
                                        int n = len;
                                        String string3 = new String(this.data, 0, len);
                                        System.out.println(new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(string3).length()).append("unhandled APP marker ").append(string).append(" length ").append(n).append(" data ").append(string3).toString());
                                    }
                                }
                                if (curImageInfo != null && curImageInfo[0] != null) {
                                    this.imageinfo = curImageInfo[0];
                                }
                                if (handledAppHdr[0] && this.imageinfo != null && keep_appxs) {
                                    this.appHdrIndex = this.appxs.length - 1;
                                }
                                if (Log.debugLevel >= 4) {
                                    string = String.valueOf(this.imageinfo);
                                    System.out.println(new StringBuilder(11 + String.valueOf(string).length()).append("Image info ").append(string).toString());
                                }
                            }
                        }
                        if (this.unprocessed_marker == 0) {
                            if (is.read(this.markerid) != this.markerid.length) {
                                msg = "Unexpected End Of Input";
                                break;
                            }
                            this.readcounter += this.markerid.length;
                        } else {
                            this.markerid[0] = -1;
                            this.markerid[1] = (byte)this.unprocessed_marker;
                            this.unprocessed_marker = 0;
                        }
                        if (stage == 4 && (this.markerid[0] != -1 || this.markerid[1] != -39)) {
                            this.valid = true;
                            stage = 5;
                            if (Log.debugLevel < 2) break;
                            handledAppHdr = String.valueOf(Integer.toHexString(this.markerid[0]));
                            curImageInfo = String.valueOf(Integer.toHexString(this.markerid[1]));
                            System.err.println(new StringBuilder(73 + String.valueOf(handledAppHdr).length() + String.valueOf(curImageInfo).length()).append("Warning:read: Found Bytes 0x").append((String)handledAppHdr).append(", 0x").append((String)curImageInfo).append(" instead of EOI, Ignoring remaining input").toString());
                            break;
                        }
                        if (this.markerid[0] != -1) {
                            if (this.readcounter == this.markerid.length) {
                                this.intel = this.markerid[0] == 73 && this.markerid[1] == 73;
                                boolean bl = this.motorola = this.markerid[0] == 77 && this.markerid[1] == 77;
                                if (this.intel || this.motorola) {
                                    this.data = new byte[6];
                                    if (is.read(this.data) == this.data.length && (this.intel && this.data[0] == 42 && this.data[1] == 0 || this.motorola && this.data[1] == 42 && this.data[0] == 0)) {
                                        this.readcounter += this.data.length;
                                        this.imageinfo = new TiffExif(is, this.data, this.readcounter, this.getName(), this.intel, this);
                                    }
                                } else if (this.markerid[0] == Flashpix.SIGNATURE[0] && this.markerid[1] == Flashpix.SIGNATURE[1]) {
                                    this.data = new byte[6];
                                    if (is.read(this.data) == this.data.length && this.data[0] == Flashpix.SIGNATURE[2] && this.data[1] == Flashpix.SIGNATURE[3] && this.data[2] == Flashpix.SIGNATURE[4] && this.data[3] == Flashpix.SIGNATURE[5] && this.data[4] == Flashpix.SIGNATURE[6] && this.data[5] == Flashpix.SIGNATURE[7]) {
                                        this.readcounter += this.data.length;
                                    }
                                }
                            }
                            this.valid = this.imageinfo != null;
                            this.canBeProcessed = false;
                            msg = "Not a Jpeg File";
                            break;
                        }
                        byte markercode = this.markerid[1];
                        switch (markercode) {
                            case -40: {
                                this.allocateTables();
                                break;
                            }
                            case -32: 
                            case -31: 
                            case -30: 
                            case -29: 
                            case -28: 
                            case -27: 
                            case -26: 
                            case -25: 
                            case -24: 
                            case -23: 
                            case -22: 
                            case -21: 
                            case -20: 
                            case -19: 
                            case -18: 
                            case -17: {
                                this.initReadAppx(markercode);
                                stage = 3;
                                break;
                            }
                            case -37: {
                                if (sections == 1) {
                                    this.valid = true;
                                    this.data = this.markerid;
                                    this.unprocessed_marker = markercode;
                                    stage = 5;
                                    break block29;
                                }
                                len = this.readMarker(is);
                                int pos = 0;
                                while (pos < len) {
                                    int tabnum = this.q_prec.length;
                                    int[] wt1d = new int[tabnum + 1];
                                    System.arraycopy(this.q_ix, 0, wt1d, 0, tabnum);
                                    this.q_ix = wt1d;
                                    this.q_ix[tabnum] = this.data[pos] & 0xF;
                                    wt1d = new int[tabnum + 1];
                                    System.arraycopy(this.q_prec, 0, wt1d, 0, tabnum);
                                    this.q_prec = wt1d;
                                    this.q_prec[tabnum] = (this.data[pos++] >> 4 & 0xF) == 0 ? 8 : 16;
                                    int[][] wt2d = new int[tabnum + 1][64];
                                    System.arraycopy(this.q_table, 0, wt2d, 0, tabnum);
                                    this.q_table = wt2d;
                                    int lim = pos + 64;
                                    if (lim > len) {
                                        lim = len;
                                    }
                                    int i22 = 0;
                                    while (pos < lim) {
                                        this.q_table[tabnum][i22] = this.data[pos++] & 0xFF;
                                        ++i22;
                                    }
                                }
                                break;
                            }
                            case -60: {
                                if (sections == 1) {
                                    this.valid = true;
                                    this.data = this.markerid;
                                    this.unprocessed_marker = markercode;
                                    stage = 5;
                                    break block29;
                                }
                                len = this.readDHT(is, 0);
                                break;
                            }
                            case -64: 
                            case -63: {
                                int i;
                                if (sections == 1) {
                                    this.valid = true;
                                    this.data = this.markerid;
                                    if (Log.debugLevel >= 3) {
                                        String tabnum = String.valueOf("Abandoned M_SOF0 -64   ");
                                        byte i22 = this.markerid[1];
                                        System.out.println(new StringBuilder(4 + String.valueOf(tabnum).length()).append(tabnum).append(i22).toString());
                                    }
                                    this.unprocessed_marker = markercode;
                                    stage = 5;
                                    break block29;
                                }
                                len = this.readMarker(is);
                                this.frm_precision = this.data[0] & 0xFF;
                                this.frm_x = this.bs2i(3, 2);
                                this.frm_y = this.bs2i(1, 2);
                                this.components_in_frame = this.data[5] & 0xFF;
                                if (Log.debugLevel >= 3) {
                                    int tabnum = this.frm_precision;
                                    System.out.println(new StringBuilder(28).append("Frame, precision ").append(tabnum).toString());
                                    tabnum = this.frm_x;
                                    int i22 = this.frm_y;
                                    System.out.println(new StringBuilder(30).append("X= ").append(tabnum).append(", Y= ").append(i22).toString());
                                    tabnum = this.components_in_frame;
                                    String i22 = String.valueOf(this.getLocationName());
                                    System.out.println(new StringBuilder(25 + String.valueOf(i22).length()).append("Components ").append(tabnum).append(" (").append(i22).append(")").toString());
                                }
                                this.V = new int[this.components_in_frame];
                                this.H = new int[this.components_in_frame];
                                this.QT = new int[this.components_in_frame];
                                this.ID = new int[this.components_in_frame];
                                int pos = 6;
                                this.maxVi = 0;
                                this.maxHi = 0;
                                int sampling = 0;
                                this.mcusize = 0;
                                for (i = 0; i < this.components_in_frame; ++i) {
                                    this.ID[i] = this.data[pos++] & 0xFF;
                                    sampling = (sampling << 8) + (this.data[pos] & 0xFF);
                                    this.H[i] = this.data[pos] >> 4 & 0xF;
                                    if (this.H[i] > this.maxHi) {
                                        this.maxHi = this.H[i];
                                    }
                                    this.V[i] = this.data[pos++] & 0xF;
                                    if (this.V[i] > this.maxVi) {
                                        this.maxVi = this.V[i];
                                    }
                                    this.mcusize += this.H[i] * this.V[i];
                                    this.QT[i] = this.data[pos++] & 0xFF;
                                }
                                this.widthMCU = (this.frm_x + 8 * this.maxHi - 1) / (8 * this.maxHi);
                                this.heightMCU = (this.frm_y + 8 * this.maxVi - 1) / (8 * this.maxVi);
                                if (Log.debugLevel < 3) break;
                                i = this.widthMCU;
                                int n = this.heightMCU;
                                System.out.println(new StringBuilder(35).append("Size in MCU ").append(i).append("x").append(n).toString());
                                break;
                            }
                            case -62: {
                                len = this.readMarker(is);
                                if (Log.debugLevel >= 1) {
                                    String i = String.valueOf(this.getLocationName());
                                    System.err.println(new StringBuilder(41 + String.valueOf(i).length()).append("Progressive, Huffman not supported in  (").append(i).append(")").toString());
                                }
                                this.canBeProcessed = false;
                                msg = "Progressive, Huffman not supported";
                                if ((sections & 4) == 0) break;
                                this.addMarker(len, markercode);
                                break;
                            }
                            case -55: {
                                len = this.readMarker(is);
                                if (Log.debugLevel >= 1) {
                                    String i = String.valueOf(this.getLocationName());
                                    System.err.println(new StringBuilder(48 + String.valueOf(i).length()).append("Extended sequential, arithmetic not supported (").append(i).append(")").toString());
                                }
                                this.canBeProcessed = false;
                                msg = "Extended sequential, arithmetic not supported";
                                if ((sections & 4) == 0) break;
                                this.addMarker(len, markercode);
                                break;
                            }
                            case -54: {
                                len = this.readMarker(is);
                                if (Log.debugLevel >= 1) {
                                    String i = String.valueOf(this.getLocationName());
                                    System.err.println(new StringBuilder(40 + String.valueOf(i).length()).append("Progressive, arithmetic not supported (").append(i).append(")").toString());
                                }
                                this.canBeProcessed = false;
                                msg = "Progressive, arithmetic not supported";
                                if ((sections & 4) == 0) break;
                                this.addMarker(len, markercode);
                                break;
                            }
                            case -61: 
                            case -59: 
                            case -58: 
                            case -57: 
                            case -56: 
                            case -53: 
                            case -51: 
                            case -50: 
                            case -49: {
                                len = this.readMarker(is);
                                if (Log.debugLevel >= 1) {
                                    String i = String.valueOf(this.getLocationName());
                                    System.err.println(new StringBuilder(311 + String.valueOf(i).length()).append("One of the unsupported SOF markers:\nLossless, Huffman\nDifferential sequential, Huffman\nDifferential progressive, Huffman\nDifferential lossless, Huffman\nReserved for JPEG extensions\nLossless, arithmetic\nDifferential sequential, arithmetic\nDifferential progressive, arithmetic\nDifferential lossless, arithmetic (").append(i).append(")").toString());
                                }
                                this.canBeProcessed = false;
                                msg = "Unsupported SOF marker";
                                if ((sections & 4) == 0) break;
                                this.addMarker(len, markercode);
                                break;
                            }
                            case -38: {
                                if ((sections & 4) == 0) {
                                    this.valid = true;
                                    this.unprocessed_marker = markercode;
                                    stage = 5;
                                    break block29;
                                }
                                len = this.readMarker(is);
                                if (this.canBeProcessed) {
                                    this.components_in_scan = this.data[0] & 0xFF;
                                    int pos = 1;
                                    this.comp_ids = new int[this.components_in_scan];
                                    this.dc_table = new int[this.components_in_scan];
                                    this.ac_table = new int[this.components_in_scan];
                                    for (int i = 0; i < this.components_in_scan; ++i) {
                                        this.comp_ids[i] = this.data[pos++] & 0xFF;
                                        this.dc_table[i] = this.data[pos] >> 4 & 0xF;
                                        this.ac_table[i] = this.data[pos++] & 0xF;
                                    }
                                    this._Ss = this.data[pos++] & 0xFF;
                                    this._Se = this.data[pos++] & 0xFF;
                                    this._Ah = this.data[pos] >> 4 & 0xF;
                                    this._Al = this.data[pos] & 0xF;
                                    this.initReadDCT();
                                    stage = 2;
                                    break;
                                }
                                this.addMarker(len, markercode);
                                if (Log.debugLevel >= 2) {
                                    System.err.println("Warning: Read raw dct");
                                }
                                this.readRawDCT(is);
                                this.valid = true;
                                break block29;
                            }
                            case -2: {
                                len = this.readMarker(is);
                                if (this.out_comment.length() > 0) {
                                    String i = String.valueOf(this.out_comment);
                                    this.out_comment = new StringBuilder(1 + String.valueOf(i).length()).append(i).append("\n").toString();
                                }
                                try {
                                    String string = String.valueOf(this.out_comment);
                                    String string4 = String.valueOf(new String(this.data, 0, len, this.enc));
                                    this.out_comment = string4.length() != 0 ? string.concat(string4) : new String(string);
                                }
                                catch (UnsupportedEncodingException uee) {
                                    String string = String.valueOf(this.out_comment);
                                    String string5 = String.valueOf(new String(this.data, 0, len));
                                    this.out_comment = string5.length() != 0 ? string.concat(string5) : new String(string);
                                }
                                catch (NullPointerException npe) {
                                    String string = String.valueOf(this.out_comment);
                                    String string6 = String.valueOf(new String(this.data, 0, len));
                                    this.out_comment = string6.length() != 0 ? string.concat(string6) : new String(string);
                                }
                                break;
                            }
                            case -39: {
                                this.valid = true;
                                stage = 5;
                                break block29;
                            }
                            case -35: {
                                if (sections == 1) {
                                    this.valid = true;
                                    this.data = this.markerid;
                                    this.unprocessed_marker = markercode;
                                    stage = 5;
                                    break block29;
                                }
                                len = this.readMarker(is);
                                if (len != 2) {
                                    int n = len;
                                    String string = String.valueOf(this.getLocationName());
                                    throw new IOException(new StringBuilder(41 + String.valueOf(string).length()).append("Wrong length of DRI marker ").append(n).append(" (").append(string).append(")").toString());
                                }
                                this.restart_interval = this.bs2i(0, 2);
                                if (Log.debugLevel < 3) break;
                                int n = this.restart_interval;
                                System.out.println(new StringBuilder(28).append("Restart interval ").append(n).toString());
                                break;
                            }
                            case -1: {
                                break;
                            }
                            default: {
                                len = this.readMarker(is);
                                if ((0xFFFFFFF0 & markercode) == -16) {
                                    msg = "Not a Jpeg File but an MP3 file";
                                    break block29;
                                }
                                if (Log.debugLevel < 2) break;
                                String string = String.valueOf(Integer.toHexString(markercode));
                                int n = len;
                                String string7 = String.valueOf(this.getLocationName());
                                System.err.println(new StringBuilder(41 + String.valueOf(string).length() + String.valueOf(string7).length()).append("Unsupported marker ").append(string).append(" length ").append(n).append(" (").append(string7).append(")").toString());
                            }
                        }
                        if (markercode >= -62 && markercode <= -49 && markercode != -60 && markercode != -56) {
                            this.frm_precision = this.data[0] & 0xFF;
                            this.frm_x = this.bs2i(3, 2);
                            this.frm_y = this.bs2i(1, 2);
                            this.components_in_frame = this.data[5] & 0xFF;
                        }
                    }
                    if ((remaining = numBytes - (this.readcounter - markCounter)) > 0) continue;
                }
                if ((sections & 1) != 0 && this.imageinfo == null) {
                    this.imageinfo = new JPEG(this.frm_x, this.frm_y, this.frm_precision * this.components_in_frame, this);
                }
                if (this.valid) {
                    if ((sections & 4) == 0) {
                        this.unprocessedError = msg;
                        msg = null;
                    } else if (Log.debugLevel >= 3) {
                        String markercode = String.valueOf(Integer.toHexString(this.readcounter));
                        int n = this.readcounter;
                        String string = String.valueOf(this.getName());
                        System.out.println(new StringBuilder(32 + String.valueOf(markercode).length() + String.valueOf(string).length()).append("0x").append(markercode).append("(").append(n).append(") byte(s) read in ").append(string).toString());
                    }
                }
                this.iReadVars.stage = stage;
                if (msg == null || this.unprocessedError != null && this.unprocessedError.indexOf("Previous Error") == 0) break block101;
            }
            catch (Exception e) {
                block102: {
                    try {
                        this.valid = false;
                        msg = "Unexpected Error encountered during Read";
                        this.setException(e);
                        if (Log.debugLevel >= 1) {
                            e.printStackTrace(System.err);
                        }
                        this.iReadVars.stage = stage;
                        if (msg == null || this.unprocessedError != null && this.unprocessedError.indexOf("Previous Error") == 0) break block102;
                    }
                    catch (Throwable throwable) {
                        this.iReadVars.stage = stage;
                        if (msg != null && (this.unprocessedError == null || this.unprocessedError.indexOf("Previous Error") != 0)) {
                            String string = String.valueOf(msg);
                            String string8 = this.unprocessedError = string.length() != 0 ? "Previous Error: ".concat(string) : new String("Previous Error: ");
                        }
                        if (msg != null || stage == 5) {
                            retVal = 1;
                        }
                        if (retVal == 1 && this.currentStream != null && ((sections & 4) != 0 || msg != null) && this.currentStream != this.inStream) {
                            try {
                                this.currentStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            this.currentStream = null;
                        }
                        if (stage == 5) {
                            this.wrapupIterativeRead();
                        }
                        this.setErrorMsg(msg);
                        if (msg != null && this.iReadVars.throwException) {
                            String string = String.valueOf(msg);
                            throw new IOException(string.length() != 0 ? "Image Read Error In LLJTran:: ".concat(string) : new String("Image Read Error In LLJTran:: "));
                        }
                        throw throwable;
                    }
                    String string = String.valueOf(msg);
                    String string9 = this.unprocessedError = string.length() != 0 ? "Previous Error: ".concat(string) : new String("Previous Error: ");
                }
                if (msg != null || stage == 5) {
                    retVal = 1;
                }
                if (retVal == 1 && this.currentStream != null && ((sections & 4) != 0 || msg != null) && this.currentStream != this.inStream) {
                    try {
                        this.currentStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.currentStream = null;
                }
                if (stage == 5) {
                    this.wrapupIterativeRead();
                }
                this.setErrorMsg(msg);
                if (msg != null && this.iReadVars.throwException) {
                    String string = String.valueOf(msg);
                    throw new IOException(string.length() != 0 ? "Image Read Error In LLJTran:: ".concat(string) : new String("Image Read Error In LLJTran:: "));
                }
            }
            String string = String.valueOf(msg);
            String string10 = this.unprocessedError = string.length() != 0 ? "Previous Error: ".concat(string) : new String("Previous Error: ");
        }
        if (msg != null || stage == 5) {
            retVal = 1;
        }
        if (retVal == 1 && this.currentStream != null && ((sections & 4) != 0 || msg != null) && this.currentStream != this.inStream) {
            try {
                this.currentStream.close();
            }
            catch (IOException markercode) {
                // empty catch block
            }
            this.currentStream = null;
        }
        if (stage == 5) {
            this.wrapupIterativeRead();
        }
        this.setErrorMsg(msg);
        if (msg != null && this.iReadVars.throwException) {
            String string = String.valueOf(msg);
            throw new IOException(string.length() != 0 ? "Image Read Error In LLJTran:: ".concat(string) : new String("Image Read Error In LLJTran:: "));
        }
        return retVal;
    }

    protected String readInternal(int sections, boolean keep_appxs) {
        String retVal = this.initReadInternal(sections, keep_appxs, false);
        if (retVal == null) {
            String savedMsg = this.getErrorMsg();
            this.setErrorMsg(null);
            try {
                while (this.nextRead(10000000) == 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            retVal = this.getErrorMsg();
            this.setErrorMsg(savedMsg);
        }
        return retVal;
    }

    public void xferInfo(InputStream is, OutputStream os, int appxsOption, int commentOption) throws LLJTranException {
        boolean internalTransfer;
        String msg;
        block31: {
            msg = null;
            int pendingMarker = 0;
            int jpegMarkers = 0;
            internalTransfer = false;
            if (is == null) {
                pendingMarker = this.unprocessed_marker;
                if (this.readUpto == 1) {
                    if (this.xferDone) {
                        msg = "Cannot Read Further, Input has been Transferred using xferInfo()";
                    }
                    if (appxsOption == 1 || commentOption == 1) {
                        msg = "Cannot Retain appxs or comments when tranferring from internal stream";
                    }
                    is = this.iReadVars.is;
                } else {
                    msg = "Can transfer from internal stream only if previously read upto READ_INFO";
                }
            }
            if (is == this.iReadVars.is) {
                this.xferDone = true;
                internalTransfer = true;
            }
            if (msg == null) {
                try {
                    this.writeMarkerSOI(os);
                    if (appxsOption == 0) {
                        this.writeMarkerAppXs(os);
                    }
                    if (commentOption == 0) {
                        this.writeMarkerComment(os, this.out_comment, this.enc);
                    }
                    if (this.data.length < 1024) {
                        this.data = new byte[1024];
                    }
                    do {
                        if (pendingMarker == 0) {
                            if (is.read(this.markerid) != this.markerid.length) {
                                msg = "Unexpected End Of Input";
                                break;
                            }
                            if (this.markerid[0] != -1) {
                                msg = "Invalid Marker found";
                                break;
                            }
                        } else {
                            this.markerid[0] = -1;
                            this.markerid[1] = (byte)pendingMarker;
                            pendingMarker = 0;
                        }
                        byte markercode = this.markerid[1];
                        switch (markercode) {
                            case -40: {
                                break;
                            }
                            case -32: 
                            case -31: 
                            case -30: 
                            case -29: 
                            case -28: 
                            case -27: 
                            case -26: 
                            case -25: 
                            case -24: 
                            case -23: 
                            case -22: 
                            case -21: 
                            case -20: 
                            case -19: 
                            case -18: 
                            case -17: {
                                this.xferMarker(is, os, markercode, appxsOption != 1 && (appxsOption == 2 || !internalTransfer));
                                break;
                            }
                            case -2: {
                                this.xferMarker(is, os, markercode, commentOption != 1 && (commentOption == 2 || !internalTransfer));
                                break;
                            }
                            case -35: {
                                this.xferMarker(is, os, markercode, false);
                                break;
                            }
                            case -1: {
                                break;
                            }
                            case -64: 
                            case -63: 
                            case -62: 
                            case -61: 
                            case -60: 
                            case -59: 
                            case -58: 
                            case -57: 
                            case -56: 
                            case -55: 
                            case -54: 
                            case -53: 
                            case -51: 
                            case -50: 
                            case -49: 
                            case -37: {
                                ++jpegMarkers;
                                this.xferMarker(is, os, markercode, false);
                                break;
                            }
                            case -38: {
                                if (jpegMarkers >= 3) {
                                    this.xferMarker(is, os, markercode, false);
                                    this.xferData(is, os, -1);
                                    os.flush();
                                    break block31;
                                }
                                msg = "All Jpeg Markers not Encountered. A likely error";
                                break;
                            }
                            case -39: {
                                msg = "Unexpected EOI marker found";
                                break;
                            }
                            default: {
                                if (Log.debugLevel >= 2) {
                                    String string = String.valueOf(Integer.toHexString(markercode));
                                    System.err.println(string.length() != 0 ? "Warning: xferAppxs(): Unhandled Marker ".concat(string) : new String("Warning: xferAppxs(): Unhandled Marker "));
                                }
                                this.xferMarker(is, os, markercode, false);
                            }
                        }
                    } while (msg == null);
                }
                catch (Exception e) {
                    msg = "Unexpected Error encountered during Read";
                    if (Log.debugLevel < 1) break block31;
                    e.printStackTrace(System.err);
                }
            }
        }
        if (internalTransfer) {
            this.closeInternalInputStream();
        }
        if (msg != null) {
            throw new LLJTranException(msg);
        }
    }

    public void closeInternalInputStream() {
        if (this.inStream == null && this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentStream = null;
            this.unprocessed_marker = 0;
        }
    }

    public int getWidth() {
        return this.frm_x;
    }

    public int getHeight() {
        return this.frm_y;
    }

    public int getWidthInMCU() {
        return this.widthMCU;
    }

    public int getHeightInMCU() {
        return this.heightMCU;
    }

    public int getMaxHSamplingFactor() {
        return this.maxHi;
    }

    public int getMaxVSamplingFactor() {
        return this.maxVi;
    }

    public int getMCUWidth() {
        return 8 * this.maxHi;
    }

    public int getMCUHeight() {
        return 8 * this.maxVi;
    }

    public int getNumComponents() {
        return this.components_in_frame;
    }

    public int getHSamplingFactor(int componentIndex) {
        return this.H[componentIndex];
    }

    public int getVSamplingFactor(int componentIndex) {
        return this.V[componentIndex];
    }

    public int getRestartInterval() {
        return this.restart_interval;
    }

    public int getNumQTables() {
        return this.q_table.length;
    }

    public int[] getQTable(int tableIndex) {
        int[] qTable = this.q_table[tableIndex];
        int[] retVal = new int[qTable.length];
        for (int i = 0; i < qTable.length; ++i) {
            retVal[i] = qTable[jpegzigzagorder[i]];
        }
        return retVal;
    }

    public int getQTableIndexForComponent(int componentIndex) {
        int i;
        int tableIndex = -1;
        int tableNum = this.QT[componentIndex];
        for (i = 0; i < this.q_ix.length && this.q_ix[i] != tableNum; ++i) {
        }
        if (i < this.q_ix.length) {
            tableIndex = i;
        }
        return tableIndex;
    }

    public int getNumAppxs() {
        int retVal = 0;
        if (this.appxs != null) {
            retVal = this.appxs.length;
        }
        return retVal;
    }

    public int getAppxMarker(int index) {
        return 0xFF & this.appxs[index][1];
    }

    public int getAppxLen(int index) {
        return this.appxs[index].length;
    }

    public int getAppx(int index, byte[] markerData, int startIndex, int len) {
        byte[] appxsData = null;
        appxsData = this.appxs[index];
        System.arraycopy(appxsData, 0, markerData, startIndex, len);
        return appxsData.length;
    }

    public int getImageInfoAppxIndex() {
        return this.appHdrIndex;
    }

    public void setAppx(int index, byte[] markerData, int startIndex, int len, boolean forImageInfo) {
        block10: {
            this.validateAppxs(markerData, startIndex, len);
            byte[] newAppxs = new byte[len];
            System.arraycopy(markerData, startIndex, newAppxs, 0, len);
            this.appxs[index] = newAppxs;
            if (forImageInfo) {
                AbstractImageInfo[] curImageInfo = new AbstractImageInfo[1];
                try {
                    this.processAppMarker(newAppxs, 4, curImageInfo, null);
                }
                catch (Exception e) {
                    if (Log.debugLevel >= 1) {
                        System.err.println("Error Parsing ImageInfo:");
                        e.printStackTrace(System.err);
                    }
                    curImageInfo[0] = null;
                }
                this.imageinfo = curImageInfo[0];
                this.appHdrIndex = index;
            } else if (index == this.appHdrIndex) {
                this.imageinfo = null;
            }
            if (this.imageinfo == null) {
                this.appHdrIndex = -1;
                if (this.frm_x != 0 && this.frm_y != 0) {
                    try {
                        this.imageinfo = new JPEG(this.frm_x, this.frm_y, this.frm_precision * this.components_in_frame, this);
                    }
                    catch (Exception e) {
                        if (Log.debugLevel < 1) break block10;
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    public void insertAppx(int index, byte[] markerData, int startIndex, int len, boolean forImageInfo) {
        this.validateAppxs(markerData, startIndex, len);
        if (index == 0 && this.appxs == null) {
            this.appxs = new byte[0][];
        }
        byte[][] ta = new byte[this.appxs.length + 1][];
        byte[] indexTest = ta[index];
        if (index > 0) {
            System.arraycopy(this.appxs, 0, ta, 0, index);
        }
        if (index < this.appxs.length) {
            System.arraycopy(this.appxs, index, ta, index + 1, this.appxs.length - index);
        }
        this.appxs = ta;
        if (index <= this.appHdrIndex) {
            ++this.appHdrIndex;
        }
        this.setAppx(index, markerData, startIndex, len, forImageInfo);
    }

    public void addAppx(byte[] markerData, int startIndex, int len, boolean forImageInfo) {
        this.insertAppx(this.getNumAppxs(), markerData, startIndex, len, forImageInfo);
    }

    public void removeAppx(int index) {
        block7: {
            byte[][] ta = new byte[this.appxs.length - 1][];
            if (index > 0) {
                System.arraycopy(this.appxs, 0, ta, 0, index);
            }
            if (index < this.appxs.length - 1) {
                System.arraycopy(this.appxs, index + 1, ta, index, this.appxs.length - index - 1);
            }
            this.appxs = ta;
            if (index == this.appHdrIndex) {
                this.imageinfo = null;
                if (this.frm_x != 0 && this.frm_y != 0) {
                    try {
                        this.imageinfo = new JPEG(this.frm_x, this.frm_y, this.frm_precision * this.components_in_frame, this);
                    }
                    catch (Exception e) {
                        if (Log.debugLevel < 1) break block7;
                        e.printStackTrace(System.err);
                    }
                }
            }
        }
        if (index > this.appHdrIndex) {
            --this.appHdrIndex;
        }
    }

    private void validateAppxs(byte[] markerData, int startIndex, int len) {
        RuntimeException e = null;
        byte firstByte = markerData[0];
        byte secondByte = markerData[1];
        if (firstByte != -1 || secondByte < -31 || secondByte > -17) {
            String string = String.valueOf(Integer.toHexString(firstByte));
            String string2 = String.valueOf(Integer.toHexString(secondByte));
            e = new RuntimeException(new StringBuilder(60 + String.valueOf(string).length() + String.valueOf(string2).length()).append("validateAppxs: Incorrect 1st two bytes for App marker: 0x").append(string).append(":0x").append(string2).toString());
        }
        if (e == null) {
            this.data = markerData;
            int expectedLen = this.bs2i(startIndex + 2, 2) + 2;
            if (len != expectedLen) {
                int n = expectedLen - 2;
                int n2 = len - 2;
                e = new RuntimeException(new StringBuilder(89).append("validateAppxs: Incorrect Length ").append(n).append(" in 3rd and 4th bytes.  expected = ").append(n2).toString());
            }
        }
        if (e != null) {
            throw e;
        }
        byte testByte = markerData[startIndex + len - 1];
    }

    protected void addMarker(int len, byte markercode) {
    }

    private void initReadAppx(byte markercode) throws IOException {
        if (this.iReadVars.is.read(this.markerid) != this.markerid.length) {
            throw new FileFormatException("Wrong length read for marker header");
        }
        this.readcounter += this.markerid.length;
        this.data = this.markerid;
        int len = this.bs2i(0, 2);
        if (this.iReadVars.keep_appxs) {
            if (!this.iReadVars.appxsCleared) {
                this.appxs = null;
                this.imageinfo = null;
                this.iReadVars.appxsCleared = true;
            }
            this.data = new byte[len + 2];
            this.data[0] = -1;
            this.data[1] = markercode;
            System.arraycopy(this.markerid, 0, this.data, 2, 2);
        }
        this.iReadVars.appxLen = len + 2;
        this.iReadVars.appxPos = 4;
    }

    private boolean readNextAppx(int numBytes) throws IOException {
        boolean retVal;
        InputStream is = this.iReadVars.is;
        int len = this.iReadVars.appxLen - this.iReadVars.appxPos;
        if (len > numBytes) {
            retVal = true;
            len = numBytes;
        } else {
            retVal = false;
        }
        int readLen = this.iReadVars.keep_appxs ? BasicIo.read(is, this.data, this.iReadVars.appxPos, len, len) : (int)BasicIo.skip(is, len);
        this.iReadVars.appxPos += readLen;
        this.readcounter += readLen;
        if (readLen < len) {
            retVal = false;
        }
        return retVal;
    }

    private void addAppx() {
        if (this.appxs == null) {
            this.appxs = new byte[0][];
        }
        byte[][] ta = new byte[this.appxs.length + 1][];
        System.arraycopy(this.appxs, 0, ta, 0, this.appxs.length);
        this.appxs = ta;
        this.appxs[this.appxs.length - 1] = this.data;
    }

    private int xferData(InputStream is, OutputStream os, int len) throws IOException {
        int bytesRead = 0;
        int remaining = len;
        int requestLen = this.data.length;
        if (len == -1) {
            remaining = requestLen;
        }
        while (remaining > 0) {
            int readLen;
            if (requestLen > remaining) {
                requestLen = remaining;
            }
            if ((readLen = is.read(this.data, 0, requestLen)) < 0) break;
            if (readLen <= 0) continue;
            os.write(this.data, 0, readLen);
            bytesRead += readLen;
            if (len == -1) continue;
            remaining -= readLen;
        }
        return bytesRead;
    }

    private void xferMarker(InputStream is, OutputStream os, int markercode, boolean skip) throws IOException {
        if (!skip) {
            os.write(-1);
            os.write(markercode);
        }
        if (is.read(this.markerid) != this.markerid.length) {
            throw new FileFormatException("Wrong length read for marker header");
        }
        byte[] saveData = this.data;
        this.data = this.markerid;
        int len = this.bs2i(0, 2) - 2;
        this.data = saveData;
        if (skip) {
            LLJTran.skip(is, len);
        } else {
            os.write(this.markerid);
            this.xferData(is, os, len);
        }
    }

    private int readMarker(InputStream is) throws IOException, FileFormatException {
        if (is.read(this.markerid) != this.markerid.length) {
            throw new FileFormatException("Wrong length read for marker header");
        }
        this.readcounter += this.markerid.length;
        this.data = this.markerid;
        int len = this.bs2i(0, 2) - 2;
        this.data = new byte[len];
        LLJTran.read(is, this.data);
        this.readcounter += len;
        return len;
    }

    private void initWriteMarkerAppXs() throws IOException {
        this.iWriteVars.currentAppx = 0;
        this.iWriteVars.currentAppxPos = 0;
    }

    private boolean writeNextMarkerAppXs(int numBytes) throws IOException {
        int i = this.iWriteVars.currentAppx;
        OutputStream os = this.iWriteVars.os;
        int pos = this.iWriteVars.currentAppxPos;
        boolean retVal = false;
        int remaining = numBytes;
        if (this.appxs != null) {
            retVal = true;
            while (true) {
                int newPos;
                if (i >= this.appxs.length) {
                    retVal = false;
                    break;
                }
                if (remaining <= 0) break;
                byte[] curAppxs = this.appxs[i];
                int len = curAppxs.length - pos;
                if (len > remaining) {
                    len = remaining;
                    newPos = pos + remaining;
                } else {
                    ++i;
                    newPos = 0;
                }
                os.write(curAppxs, pos, len);
                pos = newPos;
                remaining -= len;
                this.writecounter += len;
            }
            this.iWriteVars.currentAppx = i;
            this.iWriteVars.currentAppxPos = pos;
            if (i >= this.appxs.length) {
                retVal = false;
            }
        }
        return retVal;
    }

    protected void writeMarkerAppXs(OutputStream os) throws IOException {
        if (this.appxs == null) {
            return;
        }
        for (int i = 0; i < this.appxs.length; ++i) {
            os.write(this.appxs[i]);
            ++this.writecounter;
        }
    }

    protected void writeMarkerSOI(OutputStream os) throws IOException {
        os.write(-1);
        os.write(-40);
        this.writecounter += 2;
    }

    protected void writeNewMarker(OutputStream os, Class custom_appx) throws IOException {
        block12: {
            if (custom_appx == null) {
                return;
            }
            if (custom_appx == JFXX.class) {
                byte[] b = JFXX.getMarkerData();
                os.write(b);
                this.writecounter += b.length;
            } else if (custom_appx == Exif.class) {
                byte[] b = Exif.getMarkerData();
                os.write(b);
                this.writecounter += b.length;
            } else if (custom_appx == AbstractImageInfo.class) {
                String name = this.getName();
                int dp = name.lastIndexOf(46);
                if (dp > 0) {
                    name = name.substring(0, dp + 1);
                } else {
                    String string = String.valueOf(name);
                    name = new StringBuilder(1 + String.valueOf(string).length()).append(string).append(".").toString();
                }
                if (this.file != null) {
                    String string = String.valueOf(name);
                    String string2 = String.valueOf("Exif");
                    File ff = new File(this.file.getParent(), string2.length() != 0 ? string.concat(string2) : new String(string));
                    if (ff.exists()) {
                        try {
                            byte[] buf = new byte[(int)ff.length()];
                            FileInputStream fis = new FileInputStream(ff);
                            LLJTran.read(fis, buf);
                            os.write(buf);
                            ++this.writecounter;
                            fis.close();
                        }
                        catch (IOException e) {
                            if (Log.debugLevel < 1) break block12;
                            String string3 = String.valueOf(e);
                            System.err.println(new StringBuilder(33 + String.valueOf(string3).length()).append("Exception in reading exif marker ").append(string3).toString());
                        }
                    }
                }
            }
        }
    }

    protected void writeMarkerComment(OutputStream os, byte[] comment_data) throws IOException {
        if (comment_data != null && comment_data.length > 0) {
            os.write(-1);
            os.write(-2);
            int size = 2;
            os.write((size += comment_data.length) >> 8);
            os.write(size & 0xFF);
            os.write(comment_data);
            this.writecounter += size + 2;
        }
    }

    protected void writeMarkerComment(OutputStream os, String comment, String enc) throws IOException {
        try {
            this.data = comment.getBytes(enc);
        }
        catch (UnsupportedEncodingException uee) {
            this.data = comment.getBytes();
        }
        catch (NullPointerException npe) {
            this.data = comment.getBytes();
        }
        this.writeMarkerComment(os, this.data);
    }

    protected void writeMarkerDHT(OutputStream os, byte[] huffTables) throws IOException {
        int i;
        os.write(-1);
        os.write(-60);
        int size = 2;
        if (huffTables != null) {
            size += huffTables.length;
        } else {
            for (i = 0; i < this.ac_ix.length; ++i) {
                size += 17 + this.ac_huffval[i].length;
            }
            for (i = 0; i < this.dc_ix.length; ++i) {
                size += 17 + this.dc_huffval[i].length;
            }
        }
        os.write(size >> 8);
        os.write(size & 0xFF);
        if (huffTables != null) {
            os.write(huffTables);
        } else {
            int k;
            for (i = 0; i < this.dc_ix.length; ++i) {
                os.write(this.dc_ix[i]);
                for (k = 0; k < this.dc_huffbits[i].length; ++k) {
                    os.write(this.dc_huffbits[i][k]);
                }
                for (k = 0; k < this.dc_huffval[i].length; ++k) {
                    os.write(this.dc_huffval[i][k]);
                }
            }
            for (i = 0; i < this.ac_ix.length; ++i) {
                os.write(this.ac_ix[i] + 16);
                for (k = 0; k < this.ac_huffbits[i].length; ++k) {
                    os.write(this.ac_huffbits[i][k]);
                }
                for (k = 0; k < this.ac_huffval[i].length; ++k) {
                    os.write(this.ac_huffval[i][k]);
                }
            }
        }
        this.writecounter += size + 2;
    }

    protected void writeMarkerDQT(OutputStream os) throws IOException {
        if (!this.valid) {
            String string = String.valueOf(this.getLocationName());
            throw new IOException(new StringBuilder(63 + String.valueOf(string).length()).append("Can't write marker DQT, because an error happened at reading (").append(string).append(")").toString());
        }
        os.write(-1);
        os.write(-37);
        int size = 2 + this.q_ix.length * 65;
        os.write(size >> 8);
        os.write(size & 0xFF);
        for (int i = 0; i < this.q_ix.length; ++i) {
            os.write(this.q_ix[i] + (this.q_prec[i] == 8 ? 0 : 16));
            for (int k = 0; k < 64; ++k) {
                os.write(this.q_table[i][k]);
            }
        }
        this.writecounter += size + 2;
    }

    protected void writeMarkerDRI(OutputStream os, int restart_interval) throws IOException {
        if (restart_interval > 0) {
            os.write(-1);
            os.write(-35);
            os.write(0);
            os.write(4);
            os.write(restart_interval >> 8);
            os.write(restart_interval & 0xFF);
            this.writecounter += 6;
        }
    }

    protected void writeMarkerSOF0(OutputStream os) throws IOException {
        os.write(-1);
        os.write(-64);
        int size = 8 + this.components_in_frame * 3;
        os.write(size >> 8 & 0xFF);
        os.write(size & 0xFF);
        os.write(this.frm_precision);
        os.write(this.frm_y >> 8);
        os.write(this.frm_y & 0xFF);
        os.write(this.frm_x >> 8);
        os.write(this.frm_x & 0xFF);
        os.write(this.components_in_frame);
        for (int i = 0; i < this.components_in_frame; ++i) {
            os.write(this.ID[i]);
            os.write((this.H[i] << 4) + this.V[i]);
            os.write(this.QT[i]);
        }
        this.writecounter += size + 2;
    }

    protected void writeMarkerSOS(OutputStream os) throws IOException {
        os.write(-1);
        os.write(-38);
        int size = 3 + this.components_in_scan * 2 + 1 + 1 + 1;
        os.write(size >> 8);
        os.write(size & 0xFF);
        os.write(this.components_in_scan);
        for (int i = 0; i < this.components_in_scan; ++i) {
            os.write(this.comp_ids[i]);
            os.write((this.dc_table[i] << 4) + this.ac_table[i]);
        }
        os.write(this._Ss);
        os.write(this._Se);
        os.write((this._Ah << 4) + this._Al);
        this.writecounter += size + 2;
    }

    protected void writeMarkerEOI(OutputStream os) throws IOException {
        os.write(-1);
        os.write(-39);
        this.writecounter += 2;
    }

    void readRawDCT(InputStream is) throws IOException {
    }

    protected int readDHT(InputStream is, int lenAvailable) throws IOException {
        int numsymbols;
        int result = lenAvailable;
        if (result <= 0) {
            result = this.readMarker(is);
        }
        int base = 0;
        do {
            int[] wt1d;
            int[][][] wt3d;
            int[][] wt2d;
            int[][] enc_matrix;
            boolean is_ac = (this.data[base] & 0xFF) > 15;
            int tbl_ix = is_ac ? (this.data[base] & 0xFF) - 16 : this.data[base] & 0xFF;
            int tabnum = 0;
            if (!is_ac) {
                enc_matrix = new int[12][2];
                tabnum = this.dc_valoffset.length;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.dc_valoffset, 0, wt2d, 0, tabnum);
                this.dc_valoffset = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.dc_maxcode, 0, wt2d, 0, tabnum);
                this.dc_maxcode = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.dc_huffval, 0, wt2d, 0, tabnum);
                this.dc_huffval = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.dc_huffbits, 0, wt2d, 0, tabnum);
                this.dc_huffbits = wt2d;
                wt3d = new int[tabnum + 1][][];
                System.arraycopy(this.enc_dc_matrix, 0, wt3d, 0, tabnum);
                this.enc_dc_matrix = wt3d;
                wt1d = new int[tabnum + 1];
                System.arraycopy(this.dc_ix, 0, wt1d, 0, tabnum);
                this.dc_ix = wt1d;
                this.dc_ix[tabnum] = tbl_ix;
            } else {
                enc_matrix = new int[255][2];
                tabnum = this.ac_valoffset.length;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.ac_valoffset, 0, wt2d, 0, tabnum);
                this.ac_valoffset = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.ac_maxcode, 0, wt2d, 0, tabnum);
                this.ac_maxcode = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.ac_huffval, 0, wt2d, 0, tabnum);
                this.ac_huffval = wt2d;
                wt2d = new int[tabnum + 1][];
                System.arraycopy(this.ac_huffbits, 0, wt2d, 0, tabnum);
                this.ac_huffbits = wt2d;
                wt3d = new int[tabnum + 1][][];
                System.arraycopy(this.enc_ac_matrix, 0, wt3d, 0, tabnum);
                this.enc_ac_matrix = wt3d;
                wt1d = new int[tabnum + 1];
                System.arraycopy(this.ac_ix, 0, wt1d, 0, tabnum);
                this.ac_ix = wt1d;
                this.ac_ix[tabnum] = tbl_ix;
            }
            int[] huffsize = new int[257];
            int[] huffcode = new int[257];
            int[] huffbits = new int[16];
            int p = 0;
            for (int l = 1; l <= 16; ++l) {
                int ii;
                huffbits[l - 1] = ii = this.data[base + l] & 0xFF;
                while (ii-- > 0) {
                    huffsize[p++] = l;
                }
            }
            huffsize[p] = 0;
            numsymbols = p;
            int code = 0;
            int si = huffsize[0];
            p = 0;
            while (huffsize[p] != 0) {
                while (huffsize[p] == si) {
                    huffcode[p++] = code++;
                }
                if (code >= 1 << si) {
                    String string = String.valueOf(this.getLocationName());
                    throw new IOException(new StringBuilder(25 + String.valueOf(string).length()).append("Bad huffman code table (").append(string).append(")").toString());
                }
                code <<= 1;
                ++si;
            }
            int[] valoffset = new int[17];
            int[] maxcode = new int[18];
            p = 0;
            for (int l = 1; l <= 16; ++l) {
                if (this.data[base + l] != 0) {
                    valoffset[l] = p - huffcode[p];
                    maxcode[l] = huffcode[(p += this.data[base + l] & 0xFF) - 1];
                    continue;
                }
                maxcode[l] = -1;
            }
            maxcode[17] = -1;
            int[] huffval = new int[numsymbols];
            for (int l = 0; l < numsymbols; ++l) {
                huffval[l] = this.data[base + l + 17] & 0xFF;
                enc_matrix[huffval[l]][0] = huffcode[l];
                enc_matrix[huffval[l]][1] = huffsize[l];
            }
            if (!is_ac) {
                this.dc_valoffset[tabnum] = valoffset;
                this.dc_maxcode[tabnum] = maxcode;
                this.dc_huffval[tabnum] = huffval;
                this.enc_dc_matrix[tabnum] = enc_matrix;
                this.dc_huffbits[tabnum] = huffbits;
                continue;
            }
            this.ac_valoffset[tabnum] = valoffset;
            this.ac_maxcode[tabnum] = maxcode;
            this.ac_huffval[tabnum] = huffval;
            this.enc_ac_matrix[tabnum] = enc_matrix;
            this.ac_huffbits[tabnum] = huffbits;
        } while ((base += numsymbols + 17) < result);
        return result;
    }

    private void initReadDCT() throws IOException {
        this.iReadVars.currentProgress = 0.01;
        this.iReadVars.callbackProgress = 0.0;
        this.iReadVars.last_dc = new int[this.components_in_scan];
        this.iReadVars.DCT = new int[2][64];
        this.iReadVars.next_restart_num = 0;
        this.restarts_to_go = this.restart_interval;
        if ((this._Ss != 0 || this._Se != 63 || this._Ah != 0 || this._Al != 0) && Log.debugLevel >= 1) {
            int n = this._Ss;
            int n2 = this._Se;
            int n3 = this._Ah;
            int n4 = this._Al;
            System.err.println(new StringBuilder(81).append("Not sequential image, Ss=").append(n).append(" Se=").append(n2).append(" Ah=").append(n3).append(" Al=").append(n4).toString());
        }
        this.decoder = new HuffDecoder(this.iReadVars.is);
        this.dct_coefs = new int[this.heightMCU][][][][];
        this.iReadVars.progressPerMcu = 0.99 / (double)this.heightMCU / (double)this.widthMCU;
        if (this.readProgressCallback != null && this.iReadVars.currentProgress - this.iReadVars.callbackProgress > this.readProgressCallback.getCallbackInterval()) {
            this.iReadVars.callbackProgress = this.iReadVars.currentProgress;
            this.readProgressCallback.progressHandler(this.iReadVars.callbackProgress, (int)Math.round(this.iReadVars.callbackProgress * 100.0));
        }
        this.iReadVars.ix = 0;
        this.iReadVars.iy = 0;
    }

    private boolean readNextDCT(int numBytes) throws IOException {
        int iy;
        InputStream is = this.iReadVars.is;
        int ix = this.iReadVars.ix;
        int markCounter = this.readcounter;
        int[] last_dc = this.iReadVars.last_dc;
        int[][] DCT = this.iReadVars.DCT;
        int[] DCT_0 = DCT[0];
        int[] DCT_1 = DCT[1];
        int next_restart_num = this.iReadVars.next_restart_num;
        double currentProgress = this.iReadVars.currentProgress;
        double progressPerMcu = this.iReadVars.progressPerMcu;
        double callbackProgress = this.iReadVars.callbackProgress;
        boolean retVal = true;
        block2: for (iy = this.iReadVars.iy; iy < this.heightMCU; ++iy) {
            int[][][][] dct_coefs_iy = this.dct_coefs[iy];
            if (dct_coefs_iy == null) {
                this.dct_coefs[iy] = new int[this.widthMCU][this.mcusize][][];
                dct_coefs_iy = this.dct_coefs[iy];
            }
            while (ix < this.widthMCU) {
                block24: {
                    int[][][] dct_coefs_iy_ix = dct_coefs_iy[ix];
                    if (this.readcounter - markCounter >= numBytes) break block2;
                    int mcuc = 0;
                    try {
                        int b2;
                        for (int c = 0; c < this.components_in_scan; ++c) {
                            for (b2 = 0; b2 < this.V[c] * this.H[c]; ++b2) {
                                this.decoder.setTables(false, this.dc_table[c]);
                                last_dc[c] = this.decoder.extend(this.decoder.decode(1)) + last_dc[c];
                                int curcoef = 0;
                                DCT_0[curcoef] = last_dc[c];
                                DCT_1[curcoef++] = 0;
                                this.decoder.setTables(true, this.ac_table[c]);
                                for (int ci = 1; ci < 64; ++ci) {
                                    int ac = this.decoder.decode(1);
                                    int v = ac >> 4;
                                    if ((ac &= 0xF) != 0) {
                                        if ((ci += v) > 63) {
                                            if (Log.debugLevel >= 1) {
                                                int n = ci;
                                                System.err.println(new StringBuilder(35).append("Error: Invalid AC index ").append(n).toString());
                                            }
                                            ci = 63;
                                        }
                                        DCT_0[curcoef] = ac = this.decoder.extend(ac);
                                        DCT_1[curcoef++] = ci;
                                        continue;
                                    }
                                    if (v != 15) break;
                                    ci += v;
                                }
                                dct_coefs_iy_ix[mcuc] = new int[2][curcoef];
                                int[][] dct_coefs_iy_ix_mcuc = dct_coefs_iy_ix[mcuc];
                                System.arraycopy(DCT_0, 0, dct_coefs_iy_ix_mcuc[0], 0, curcoef);
                                System.arraycopy(DCT_1, 0, dct_coefs_iy_ix_mcuc[1], 0, curcoef);
                                ++mcuc;
                            }
                        }
                        --this.restarts_to_go;
                        if (this.restart_interval != 0 && this.restarts_to_go == 0) {
                            int markercode = this.unprocessed_marker;
                            this.unprocessed_marker = 0;
                            if (markercode == 0) {
                                markercode = is.read();
                                ++this.readcounter;
                                if (markercode != 255) {
                                    String b2 = String.valueOf(Integer.toHexString(markercode));
                                    String string = String.valueOf(Integer.toHexString(this.readcounter));
                                    String string2 = String.valueOf(this.getLocationName());
                                    throw new IOException(new StringBuilder(55 + String.valueOf(b2).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append("0x").append(b2).append(" found instead of restart marker prefix 0xff at 0x").append(string).append(" (").append(string2).append(")").toString());
                                }
                                do {
                                    markercode = is.read();
                                    ++this.readcounter;
                                } while (markercode == 255);
                            }
                            if (markercode == 208 + next_restart_num) {
                                next_restart_num = next_restart_num + 1 & 7;
                            } else if (iy == this.heightMCU - 1 && ix == this.widthMCU - 1) {
                                this.unprocessed_marker = markercode;
                            } else {
                                b2 = this.readcounter;
                                String string = String.valueOf(Integer.toHexString(this.readcounter));
                                String string3 = String.valueOf(this.getLocationName());
                                throw new IOException(new StringBuilder(51 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Restart markers are messed up at ").append(b2).append("(0x").append(string).append(") (").append(string3).append(")").toString());
                            }
                            this.restarts_to_go = this.restart_interval;
                            for (int k = 0; k < last_dc.length; ++k) {
                                last_dc[k] = 0;
                            }
                            this.decoder.restart();
                        } else if (this.unprocessed_marker != 0) {
                            String markercode = String.valueOf(Integer.toHexString(this.unprocessed_marker));
                            int n = this.restart_interval;
                            int n2 = this.restarts_to_go;
                            String string = String.valueOf(Integer.toHexString(this.readcounter));
                            String string4 = String.valueOf(this.getLocationName());
                            throw new IOException(new StringBuilder(100 + String.valueOf(markercode).length() + String.valueOf(string).length() + String.valueOf(string4).length()).append("Unexpected Restart marker 0x").append(markercode).append(" with restart_interval=").append(n).append(" and restarts_to_go=").append(n2).append(" at ").append(string).append(" (").append(string4).append(")").toString());
                        }
                    }
                    catch (RestartException re) {
                        this.restarts_to_go = 0;
                        if (Log.debugLevel < 3) break block24;
                        System.out.println("Restart exception ");
                    }
                }
                currentProgress += progressPerMcu;
                if (this.readProgressCallback != null && currentProgress - callbackProgress > this.readProgressCallback.getCallbackInterval()) {
                    callbackProgress = currentProgress;
                    this.readProgressCallback.progressHandler(callbackProgress, (int)Math.round(callbackProgress * 100.0));
                }
                ++ix;
            }
            ix = 0;
        }
        this.iReadVars.ix = ix;
        this.iReadVars.iy = iy;
        this.iReadVars.next_restart_num = next_restart_num;
        this.iReadVars.currentProgress = currentProgress;
        this.iReadVars.callbackProgress = callbackProgress;
        if (iy >= this.heightMCU) {
            retVal = false;
            this.iReadVars.last_dc = null;
            this.iReadVars.DCT = null;
            this.decoder = null;
        }
        return retVal;
    }

    protected void readDCT(InputStream is) throws IOException {
        this.iReadVars.is = is;
        this.initReadDCT();
        while (this.readNextDCT(10000000)) {
        }
    }

    private void transposeImageParameters() {
        int t = this.frm_x;
        this.frm_x = this.frm_y;
        this.frm_y = t;
        for (int c = 0; c < this.components_in_scan; ++c) {
            t = this.V[c];
            this.V[c] = this.H[c];
            this.H[c] = t;
        }
        t = this.widthMCU;
        this.widthMCU = this.heightMCU;
        this.heightMCU = t;
        t = this.maxHi;
        this.maxHi = this.maxVi;
        this.maxVi = t;
    }

    private void transposeQTable() {
        for (int k = 0; k < this.q_table.length; ++k) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < i; ++j) {
                    int t = this.q_table[k][jpegzigzagorder[i * 8 + j]];
                    this.q_table[k][LLJTran.jpegzigzagorder[i * 8 + j]] = this.q_table[k][jpegzigzagorder[j * 8 + i]];
                    this.q_table[k][LLJTran.jpegzigzagorder[j * 8 + i]] = t;
                }
            }
        }
    }

    private void initWriteDCT(OutputStream os, int op, int options, int restart_interval, boolean transformDct) throws IOException {
        if (!this.valid) {
            String string = String.valueOf(this.getLocationName());
            throw new IOException(new StringBuilder(56 + String.valueOf(string).length()).append("Can't write DCT, because an error happened at reading (").append(string).append(")").toString());
        }
        this.iWriteVars.os = os;
        this.iWriteVars.op = op;
        this.iWriteVars.options = options;
        this.iWriteVars.restart_interval = restart_interval;
        this.iWriteVars.transformDct = transformDct;
        this.iWriteVars.new_dct_coefs = null;
        this.iWriteVars.currentProgress = 0.01;
        this.iWriteVars.callbackProgress = 0.0;
        this.iWriteVars.last_dc = null;
        this.encoder = null;
        this.iWriteVars.restarts_to_go = restart_interval;
        boolean edgeOption = (options & 8) != 0;
        boolean handleXEdge = false;
        boolean handleYEdge = false;
        boolean reuseDctRows = true;
        if (edgeOption) {
            handleXEdge = this.partialXMCU;
            handleYEdge = this.partialYMCU;
        }
        if (this.widthMCU != this.dct_coefs[0].length || op == 3 || op == 5 || op == 7 || op == 4) {
            reuseDctRows = false;
        }
        this.iWriteVars.handleXEdge = handleXEdge;
        this.iWriteVars.handleYEdge = handleYEdge;
        this.iWriteVars.progressPerMcu = 0.99 / (double)this.dct_coefs.length / (double)this.dct_coefs[0].length;
        if (!transformDct && this.writeProgressCallback != null && this.iWriteVars.currentProgress - this.iWriteVars.callbackProgress > this.writeProgressCallback.getCallbackInterval()) {
            this.iWriteVars.callbackProgress = this.iWriteVars.currentProgress;
            this.writeProgressCallback.progressHandler(this.iWriteVars.callbackProgress, (int)Math.round(this.iWriteVars.callbackProgress * 100.0));
        }
        if (transformDct) {
            if (reuseDctRows) {
                this.iWriteVars.new_dct_coefs = new int[this.heightMCU][][][][];
                if (this.heightMCU > 0) {
                    this.iWriteVars.new_dct_coefs[0] = new int[this.widthMCU][][][];
                }
            } else {
                this.iWriteVars.new_dct_coefs = new int[this.heightMCU][this.widthMCU][][][];
            }
            if (this.heightMCU > 0 && this.widthMCU > 0) {
                this.iWriteVars.new_dct_coefs[0][0] = new int[this.mcusize][][];
            }
        } else {
            reuseDctRows = false;
            this.iWriteVars.last_dc = new int[this.components_in_scan];
            this.encoder = new HuffEncoder(os);
        }
        this.retainDct = !transformDct;
        int xCropOffsetMCU = 0;
        int yCropOffsetMCU = 0;
        if (op == 8) {
            xCropOffsetMCU = this.cropBounds.x / this.getMCUWidth();
            yCropOffsetMCU = this.cropBounds.y / this.getMCUHeight();
        }
        this.iWriteVars.reuseDctRows = reuseDctRows;
        this.iWriteVars.xCropOffsetMCU = xCropOffsetMCU;
        this.iWriteVars.yCropOffsetMCU = yCropOffsetMCU;
        this.iWriteVars.new_ix = 0;
        this.iWriteVars.new_iy = 0;
    }

    private boolean writeNextDCT(int numBytes) throws IOException {
        boolean retVal = true;
        OutputStream os = this.iWriteVars.os;
        int op = this.iWriteVars.op;
        int options = this.iWriteVars.options;
        boolean transformDct = this.iWriteVars.transformDct;
        int[][][][][] new_dct_coefs = this.iWriteVars.new_dct_coefs;
        int[][][] new_mcu = null;
        int[] last_dc = this.iWriteVars.last_dc;
        boolean handleXEdge = this.iWriteVars.handleXEdge;
        boolean handleYEdge = this.iWriteVars.handleYEdge;
        boolean reuseDctRows = this.iWriteVars.reuseDctRows;
        int xCropOffsetMCU = this.iWriteVars.xCropOffsetMCU;
        int yCropOffsetMCU = this.iWriteVars.yCropOffsetMCU;
        int iy = 0;
        int new_ix = this.iWriteVars.new_ix;
        int new_iy = this.iWriteVars.new_iy;
        int[][][][] new_dct_row = null;
        int markCounter = this.writecounter;
        int restart_interval = this.iWriteVars.restart_interval;
        int restarts_to_go = this.iWriteVars.restarts_to_go;
        double currentProgress = this.iWriteVars.currentProgress;
        double callbackProgress = this.iWriteVars.callbackProgress;
        double progressPerMcu = this.iWriteVars.progressPerMcu;
        boolean pullDownMode = this.iWriteVars.pullDownMode;
        if (transformDct && new_iy < this.heightMCU) {
            new_dct_row = new_dct_coefs[new_iy];
            if (new_ix < this.widthMCU) {
                new_mcu = new_dct_coefs[new_iy][new_ix];
            }
        }
        block21: while (new_iy < this.heightMCU) {
            if (reuseDctRows) {
                new_dct_coefs[new_iy] = new_dct_row;
            }
            while (new_ix < this.widthMCU) {
                int ix;
                if (transformDct) {
                    new_dct_coefs[new_iy][new_ix] = new_mcu;
                }
                if (this.writecounter - markCounter >= numBytes) break block21;
                int off = 0;
                int new_off = 0;
                int dctOp = op;
                switch (op) {
                    case 3: {
                        ix = new_iy;
                        iy = new_ix;
                        break;
                    }
                    case 5: {
                        ix = new_iy;
                        iy = this.widthMCU - 1 - new_ix;
                        if (!handleYEdge) break;
                        if (iy > 0) {
                            --iy;
                            break;
                        }
                        iy = this.widthMCU - 1;
                        dctOp = 3;
                        break;
                    }
                    case 7: {
                        ix = this.heightMCU - 1 - new_iy;
                        iy = new_ix;
                        if (!handleXEdge) break;
                        if (ix > 0) {
                            --ix;
                            break;
                        }
                        ix = this.heightMCU - 1;
                        dctOp = 3;
                        break;
                    }
                    case 4: {
                        ix = this.heightMCU - 1 - new_iy;
                        iy = this.widthMCU - 1 - new_ix;
                        if (handleXEdge) {
                            if (ix > 0) {
                                --ix;
                            } else {
                                ix = this.heightMCU - 1;
                                dctOp = 5;
                            }
                        }
                        if (!handleYEdge) break;
                        if (iy > 0) {
                            --iy;
                            break;
                        }
                        iy = this.widthMCU - 1;
                        dctOp = dctOp == 4 ? 7 : 3;
                        break;
                    }
                    case 1: {
                        ix = this.widthMCU - 1 - new_ix;
                        iy = new_iy;
                        if (!handleXEdge) break;
                        if (ix > 0) {
                            --ix;
                            break;
                        }
                        ix = this.widthMCU - 1;
                        dctOp = 0;
                        break;
                    }
                    case 2: {
                        ix = new_ix;
                        iy = this.heightMCU - 1 - new_iy;
                        if (!handleYEdge) break;
                        if (iy > 0) {
                            --iy;
                            break;
                        }
                        iy = this.heightMCU - 1;
                        dctOp = 0;
                        break;
                    }
                    case 6: {
                        ix = this.widthMCU - 1 - new_ix;
                        iy = this.heightMCU - 1 - new_iy;
                        if (handleXEdge) {
                            if (ix > 0) {
                                --ix;
                            } else {
                                ix = this.widthMCU - 1;
                                dctOp = 2;
                            }
                        }
                        if (!handleYEdge) break;
                        if (iy > 0) {
                            --iy;
                            break;
                        }
                        iy = this.heightMCU - 1;
                        dctOp = dctOp == 6 ? 1 : 0;
                        break;
                    }
                    case 8: {
                        ix = new_ix + xCropOffsetMCU;
                        iy = new_iy + yCropOffsetMCU;
                        dctOp = 0;
                        break;
                    }
                    default: {
                        ix = new_ix;
                        iy = new_iy;
                    }
                }
                int[][][] next_mcu = this.dct_coefs[iy][ix];
                try {
                    for (int c = 0; c < this.components_in_scan; ++c) {
                        if (!transformDct) {
                            this.encoder.setTables(this.ac_table[c], this.dc_table[c]);
                        }
                        switch (dctOp) {
                            case 3: {
                                int[][] new_dct;
                                int[][] dct;
                                int my;
                                int mx;
                                for (mx = 0; mx < this.V[c]; ++mx) {
                                    for (my = 0; my < this.H[c]; ++my) {
                                        dct = next_mcu[off + my * this.V[c] + mx];
                                        new_dct = this.transposeDCT(dct);
                                        if (transformDct) {
                                            new_mcu[new_off++] = new_dct;
                                            continue;
                                        }
                                        last_dc[c] = this.encoder.encode(new_dct, last_dc[c], dct[0].length);
                                    }
                                }
                                break;
                            }
                            case 5: {
                                int[][] new_dct;
                                int[][] dct;
                                int my;
                                int mx;
                                for (mx = 0; mx < this.V[c]; ++mx) {
                                    for (my = this.H[c] - 1; my >= 0; --my) {
                                        dct = next_mcu[off + my * this.V[c] + mx];
                                        new_dct = this.rotate90DCT(dct);
                                        if (transformDct) {
                                            new_mcu[new_off++] = new_dct;
                                            continue;
                                        }
                                        last_dc[c] = this.encoder.encode(new_dct, last_dc[c], dct[0].length);
                                    }
                                }
                                break;
                            }
                            case 7: {
                                int[][] new_dct;
                                int[][] dct;
                                int my;
                                int mx;
                                for (mx = this.V[c] - 1; mx >= 0; --mx) {
                                    for (my = 0; my < this.H[c]; ++my) {
                                        dct = next_mcu[off + my * this.V[c] + mx];
                                        new_dct = this.rotate270DCT(dct);
                                        if (transformDct) {
                                            new_mcu[new_off++] = new_dct;
                                            continue;
                                        }
                                        last_dc[c] = this.encoder.encode(new_dct, last_dc[c], dct[0].length);
                                    }
                                }
                                break;
                            }
                            case 4: {
                                int[][] new_dct;
                                int[][] dct;
                                int my;
                                int mx;
                                for (mx = this.V[c] - 1; mx >= 0; --mx) {
                                    for (my = this.H[c] - 1; my >= 0; --my) {
                                        dct = next_mcu[off + my * this.V[c] + mx];
                                        new_dct = this.transverseDCT(dct);
                                        if (transformDct) {
                                            new_mcu[new_off++] = new_dct;
                                            continue;
                                        }
                                        last_dc[c] = this.encoder.encode(new_dct, last_dc[c], dct[0].length);
                                    }
                                }
                                break;
                            }
                            case 1: {
                                int mx;
                                int my;
                                int[][] new_dct;
                                int[][] dct;
                                for (my = 0; my < this.V[c]; ++my) {
                                    for (mx = this.H[c] - 1; mx >= 0; --mx) {
                                        dct = next_mcu[off + my * this.H[c] + mx];
                                        new_dct = this.flipHDct(dct);
                                        if (transformDct) {
                                            new_mcu[new_off++] = new_dct;
                                            continue;
                                        }
                                        last_dc[c] = this.encoder.encode(new_dct, last_dc[c], dct[0].length);
                                    }
                                }
                                break;
                            }
                            case 2: {
                                int mx;
                                int my;
                                int[][] new_dct;
                                int[][] dct;
                                for (my = this.V[c] - 1; my >= 0; --my) {
                                    for (mx = 0; mx < this.H[c]; ++mx) {
                                        dct = next_mcu[off + my * this.H[c] + mx];
                                        new_dct = this.flipVDct(dct);
                                        if (transformDct) {
                                            new_mcu[new_off++] = new_dct;
                                            continue;
                                        }
                                        last_dc[c] = this.encoder.encode(new_dct, last_dc[c], dct[0].length);
                                    }
                                }
                                break;
                            }
                            case 6: {
                                int mx;
                                int my;
                                int[][] new_dct;
                                int[][] dct;
                                for (my = this.V[c] - 1; my >= 0; --my) {
                                    for (mx = this.H[c] - 1; mx >= 0; --mx) {
                                        dct = next_mcu[off + my * this.H[c] + mx];
                                        new_dct = this.rotate180Dct(dct);
                                        if (transformDct) {
                                            new_mcu[new_off++] = new_dct;
                                            continue;
                                        }
                                        last_dc[c] = this.encoder.encode(new_dct, last_dc[c], dct[0].length);
                                    }
                                }
                                break;
                            }
                            default: {
                                for (int b = 0; b < this.V[c] * this.H[c]; ++b) {
                                    int[][] dct = next_mcu[off + b];
                                    if (transformDct) {
                                        new_mcu[new_off++] = dct;
                                        continue;
                                    }
                                    last_dc[c] = this.encoder.encode(dct, last_dc[c], dct[0].length);
                                }
                            }
                        }
                        off += this.V[c] * this.H[c];
                    }
                    if (transformDct) {
                        new_mcu = next_mcu;
                    } else {
                        if (restart_interval != 0 && --restarts_to_go == 0) {
                            restarts_to_go = restart_interval;
                            if (this._Ss == 0) {
                                for (int k = 0; k < last_dc.length; ++k) {
                                    last_dc[k] = 0;
                                }
                            }
                            this.encoder.restart();
                        }
                        currentProgress += progressPerMcu;
                        if (this.writeProgressCallback != null && currentProgress - callbackProgress > this.writeProgressCallback.getCallbackInterval()) {
                            callbackProgress = currentProgress;
                            this.writeProgressCallback.progressHandler(callbackProgress, (int)Math.round(callbackProgress * 100.0));
                        }
                    }
                }
                catch (RestartException re) {
                    restarts_to_go = 0;
                }
                ++new_ix;
            }
            new_ix = 0;
            new_dct_row = this.dct_coefs[iy];
            if (pullDownMode) {
                this.dct_coefs[iy] = null;
            }
            ++new_iy;
        }
        this.iWriteVars.new_ix = new_ix;
        this.iWriteVars.new_iy = new_iy;
        this.iWriteVars.restarts_to_go = restarts_to_go;
        this.iWriteVars.currentProgress = currentProgress;
        this.iWriteVars.callbackProgress = callbackProgress;
        if (new_iy >= this.heightMCU) {
            retVal = false;
            if (transformDct) {
                this.dct_coefs = new_dct_coefs;
            } else {
                this.encoder.flush();
            }
            this.encoder = null;
        }
        return retVal;
    }

    private void writeDCT(OutputStream os, int op, int options, int restart_interval, boolean transformDct) throws IOException {
        this.initWriteDCT(os, op, options, restart_interval, transformDct);
        while (this.writeNextDCT(10000000)) {
        }
    }

    private static void copyDct(int[][] srcDct, int[][] destDct) {
        for (int i = 0; i < srcDct.length; ++i) {
            System.arraycopy(srcDct[i], 0, destDct[i], 0, srcDct[i].length);
        }
    }

    private static void compactDct(int[] tmpCoef, int[][] destDct) {
        int k = 1;
        for (int i = 1; i < tmpCoef.length; ++i) {
            if (tmpCoef[i] == 0) continue;
            destDct[1][k] = i;
            destDct[0][k] = tmpCoef[i];
            ++k;
        }
    }

    protected int[][] transposeDCT(int[][] dct) {
        int i;
        int[] tmpCoef = this.tmp_dct[0];
        for (i = 0; i < tmpCoef.length; ++i) {
            tmpCoef[i] = 0;
        }
        for (i = 0; i < dct[0].length; ++i) {
            int k = jpegnaturalorder[dct[1][i]];
            k = ((k & 7) << 3) + (k >> 3);
            tmpCoef[LLJTran.jpegzigzagorder[k]] = dct[0][i];
        }
        int[][] retVal = this.retainDct ? this.tmp_dct : dct;
        LLJTran.compactDct(tmpCoef, retVal);
        return retVal;
    }

    protected int[][] rotate90DCT(int[][] dct) {
        int i;
        int[] tmpCoef = this.tmp_dct[0];
        for (i = 0; i < tmpCoef.length; ++i) {
            tmpCoef[i] = 0;
        }
        for (i = 0; i < dct[0].length; ++i) {
            int k = jpegnaturalorder[dct[1][i]];
            k = ((k & 7) << 3) + (k >> 3);
            tmpCoef[LLJTran.jpegzigzagorder[k]] = (k & 1) == 1 ? -dct[0][i] : dct[0][i];
        }
        int[][] retVal = this.retainDct ? this.tmp_dct : dct;
        LLJTran.compactDct(tmpCoef, retVal);
        return retVal;
    }

    protected int[][] rotate270DCT(int[][] dct) {
        int i;
        int[] tmpCoef = this.tmp_dct[0];
        for (i = 0; i < tmpCoef.length; ++i) {
            tmpCoef[i] = 0;
        }
        for (i = 0; i < dct[0].length; ++i) {
            int k = jpegnaturalorder[dct[1][i]];
            k = ((k & 7) << 3) + (k >> 3);
            tmpCoef[LLJTran.jpegzigzagorder[k]] = (k & 8) == 8 ? -dct[0][i] : dct[0][i];
        }
        int[][] retVal = this.retainDct ? this.tmp_dct : dct;
        LLJTran.compactDct(tmpCoef, retVal);
        return retVal;
    }

    protected int[][] transverseDCT(int[][] dct) {
        int i;
        int[] tmpCoef = this.tmp_dct[0];
        for (i = 0; i < tmpCoef.length; ++i) {
            tmpCoef[i] = 0;
        }
        for (i = 0; i < dct[0].length; ++i) {
            int k = jpegnaturalorder[dct[1][i]];
            boolean neg = (k & 1) != 0;
            k = ((k & 7) << 3) + (k >> 3);
            tmpCoef[LLJTran.jpegzigzagorder[k]] = (neg ^= (k & 1) != 0) ? -dct[0][i] : dct[0][i];
        }
        int[][] retVal = this.retainDct ? this.tmp_dct : dct;
        LLJTran.compactDct(tmpCoef, retVal);
        return retVal;
    }

    protected int[][] flipHDct(int[][] dct) {
        int[][] retVal = dct;
        int len = dct[0].length;
        if (this.retainDct) {
            LLJTran.copyDct(dct, this.tmp_dct);
            retVal = this.tmp_dct;
        }
        for (int k = 0; k < len; ++k) {
            if ((jpegnaturalorder[retVal[1][k]] & 1) == 0) continue;
            retVal[0][k] = -retVal[0][k];
        }
        return retVal;
    }

    protected int[][] flipVDct(int[][] dct) {
        int[][] retVal = dct;
        int len = dct[0].length;
        if (this.retainDct) {
            LLJTran.copyDct(dct, this.tmp_dct);
            retVal = this.tmp_dct;
        }
        for (int k = 0; k < len; ++k) {
            if ((jpegnaturalorder[retVal[1][k]] & 8) != 8) continue;
            retVal[0][k] = -retVal[0][k];
        }
        return retVal;
    }

    protected int[][] rotate180Dct(int[][] dct) {
        int[][] retVal = dct;
        int len = dct[0].length;
        if (this.retainDct) {
            LLJTran.copyDct(dct, this.tmp_dct);
            retVal = this.tmp_dct;
        }
        for (int k = 0; k < len; ++k) {
            if ((jpegnaturalorder[retVal[1][k]] & 9) != 1 && (jpegnaturalorder[retVal[1][k]] & 9) != 8) continue;
            retVal[0][k] = -retVal[0][k];
        }
        return retVal;
    }

    public int getRequestSize(int which) {
        int retVal = -1;
        switch (which) {
            case 0: {
                retVal = this.iReadVars.minReadRequest;
                break;
            }
            case 1: {
                retVal = this.iReadVars.maxReadRequest;
                break;
            }
            case 2: {
                retVal = this.iWriteVars.minWriteRequest;
                break;
            }
            case 3: {
                retVal = this.iWriteVars.maxWriteRequest;
                break;
            }
        }
        return retVal;
    }

    private class RestartException
    extends Exception {
        int scan;

        RestartException(LLJTran lLJTran, int scan) {
            this.scan = scan;
        }
    }

    private class HuffGenerator {
        private int[][] dc_count;
        private int[][] ac_count;

        public void init() {
            this.dc_count = new int[LLJTran.this.dc_ix.length][257];
            this.ac_count = new int[LLJTran.this.ac_ix.length][257];
        }

        public void freeMemory() {
            this.dc_count = null;
            this.ac_count = null;
        }

        public void updateDCCount(int tableIndex, int symbol) {
            int[] nArray = this.dc_count[tableIndex];
            int n = symbol;
            nArray[n] = nArray[n] + 1;
        }

        public void updateACCount(int tableIndex, int symbol) {
            int[] nArray = this.ac_count[tableIndex];
            int n = symbol;
            nArray[n] = nArray[n] + 1;
        }

        private void genOptimalTable(OutputStream os, int[] freq) throws IOException {
            int j;
            int i;
            int[] bits = new int[33];
            int[] codesize = new int[257];
            int[] others = new int[257];
            for (i = 0; i < 257; ++i) {
                others[i] = -1;
            }
            freq[256] = 1;
            block1: while (true) {
                int c1 = -1;
                int v = 1000000000;
                for (i = 0; i <= 256; ++i) {
                    if (freq[i] <= 0 || freq[i] > v) continue;
                    v = freq[i];
                    c1 = i;
                }
                int c2 = -1;
                v = 1000000000;
                for (i = 0; i <= 256; ++i) {
                    if (freq[i] <= 0 || freq[i] > v || i == c1) continue;
                    v = freq[i];
                    c2 = i;
                }
                if (c2 < 0) break;
                int n = c1;
                freq[n] = freq[n] + freq[c2];
                freq[c2] = 0;
                int n2 = c1;
                codesize[n2] = codesize[n2] + 1;
                while (others[c1] >= 0) {
                    int n3 = c1 = others[c1];
                    codesize[n3] = codesize[n3] + 1;
                }
                others[c1] = c2;
                int n4 = c2;
                codesize[n4] = codesize[n4] + 1;
                while (true) {
                    if (others[c2] < 0) continue block1;
                    int n5 = c2 = others[c2];
                    codesize[n5] = codesize[n5] + 1;
                }
                break;
            }
            for (i = 0; i <= 256; ++i) {
                if (codesize[i] <= 0) continue;
                if (codesize[i] > 32) {
                    int n = codesize[i];
                    int n6 = i;
                    throw new RuntimeException(new StringBuilder(92).append("Internal Error regenerating Huff Tables: Code Length ").append(n).append(" for symbol ").append(n6).append(" > 32").toString());
                }
                int n = codesize[i];
                bits[n] = bits[n] + 1;
            }
            for (i = 32; i > 16; --i) {
                while (bits[i] > 0) {
                    j = i - 2;
                    while (bits[j] == 0) {
                        --j;
                    }
                    int n = i;
                    bits[n] = bits[n] - 2;
                    int n7 = i - 1;
                    bits[n7] = bits[n7] + 1;
                    int n8 = j + 1;
                    bits[n8] = bits[n8] + 2;
                    int n9 = j;
                    bits[n9] = bits[n9] - 1;
                }
            }
            while (bits[i] == 0) {
                --i;
            }
            int n = i;
            bits[n] = bits[n] - 1;
            for (i = 1; i <= 16; ++i) {
                os.write(bits[i]);
            }
            for (i = 1; i <= 32; ++i) {
                for (j = 0; j <= 255; ++j) {
                    if (codesize[j] != i) continue;
                    os.write(j);
                }
            }
        }

        private void writeHuffTables(OutputStream os) throws IOException {
            int htInfo;
            int tableIndex;
            for (tableIndex = 0; tableIndex < LLJTran.this.dc_ix.length; ++tableIndex) {
                htInfo = LLJTran.this.dc_ix[tableIndex];
                os.write(htInfo);
                this.genOptimalTable(os, this.dc_count[tableIndex]);
            }
            for (tableIndex = 0; tableIndex < LLJTran.this.ac_ix.length; ++tableIndex) {
                htInfo = 16 + LLJTran.this.ac_ix[tableIndex];
                os.write(htInfo);
                this.genOptimalTable(os, this.ac_count[tableIndex]);
            }
        }
    }

    private class HuffEncoder {
        private int bufferputbits;
        private int bufferputbuffer;
        private OutputStream outputstream;
        private int[][] dc_ecodetable;
        private int[][] ac_ecodetable;
        int next_restart_num;
        int acTblIndex;
        int dcTblIndex;

        public HuffEncoder(OutputStream os) {
            this.outputstream = os;
        }

        void setTables(int iac, int idc) {
            int i;
            boolean dt_found = false;
            boolean at_found = false;
            for (i = 0; i < LLJTran.this.ac_ix.length; ++i) {
                if (LLJTran.this.ac_ix[i] != iac) continue;
                if (!LLJTran.this.gatheringStats) {
                    this.ac_ecodetable = LLJTran.this.enc_ac_matrix[i];
                }
                this.acTblIndex = i;
                at_found = true;
                break;
            }
            for (i = 0; i < LLJTran.this.dc_ix.length; ++i) {
                if (LLJTran.this.dc_ix[i] != idc) continue;
                if (!LLJTran.this.gatheringStats) {
                    this.dc_ecodetable = LLJTran.this.enc_dc_matrix[i];
                }
                this.dcTblIndex = i;
                dt_found = true;
                break;
            }
            if (!(at_found && dt_found || Log.debugLevel < 1)) {
                boolean bl = at_found;
                boolean bl2 = dt_found;
                System.err.println(new StringBuilder(67).append("One of tables not found for a ").append(iac).append(" ").append(bl).append(" d ").append(idc).append(" ").append(bl2).toString());
            }
        }

        int encode(int[][] coef, int last_dc, int len) throws IOException, RestartException {
            if (coef == null || coef[0] == null) {
                throw new RestartException(LLJTran.this, 0);
            }
            int temp2 = coef[0][0] - last_dc;
            int temp = temp2;
            if (temp < 0) {
                temp = -temp;
                --temp2;
            }
            int nbits = 0;
            while (temp != 0) {
                ++nbits;
                temp >>= 1;
            }
            if (LLJTran.this.gatheringStats) {
                LLJTran.this.huffGen.updateDCCount(this.dcTblIndex, nbits);
            } else {
                this.writeCode(this.dc_ecodetable[nbits][0], this.dc_ecodetable[nbits][1]);
            }
            if (nbits != 0) {
                this.writeCode(temp2, nbits);
            }
            for (int k = 1; k < len; ++k) {
                int r;
                for (r = coef[1][k] - coef[1][k - 1] - 1; r > 15; r -= 16) {
                    if (LLJTran.this.gatheringStats) {
                        LLJTran.this.huffGen.updateACCount(this.acTblIndex, 240);
                        continue;
                    }
                    this.writeCode(this.ac_ecodetable[240][0], this.ac_ecodetable[240][1]);
                }
                temp2 = coef[0][k];
                temp = temp2;
                if (temp < 0) {
                    temp = -temp;
                    --temp2;
                }
                nbits = 1;
                while ((temp >>= 1) != 0) {
                    ++nbits;
                }
                int i = (r << 4) + nbits;
                if (LLJTran.this.gatheringStats) {
                    LLJTran.this.huffGen.updateACCount(this.acTblIndex, i);
                } else {
                    this.writeCode(this.ac_ecodetable[i][0], this.ac_ecodetable[i][1]);
                }
                this.writeCode(temp2, nbits);
            }
            if (63 - coef[1][len - 1] > 0) {
                if (LLJTran.this.gatheringStats) {
                    LLJTran.this.huffGen.updateACCount(this.acTblIndex, 0);
                } else {
                    this.writeCode(this.ac_ecodetable[0][0], this.ac_ecodetable[0][1]);
                }
            }
            return coef[0][0];
        }

        void restart() throws IOException {
            if (LLJTran.this.gatheringStats) {
                return;
            }
            this.flush();
            this.outputstream.write(-1);
            this.outputstream.write(208 + this.next_restart_num);
            LLJTran.this.writecounter += 2;
            this.next_restart_num = this.next_restart_num + 1 & 7;
            this.bufferputbuffer = 0;
            this.bufferputbits = 0;
        }

        void writeCode(int code, int size) throws IOException {
            if (LLJTran.this.gatheringStats) {
                return;
            }
            if (size == 0) {
                throw new RuntimeException("Runtime Error: Missing Huffman Table Entry");
            }
            int putbuffer = code;
            int putbits = this.bufferputbits;
            putbuffer &= (1 << size) - 1;
            putbuffer <<= 24 - (putbits += size);
            putbuffer |= this.bufferputbuffer;
            while (putbits >= 8) {
                int c = putbuffer >> 16 & 0xFF;
                this.outputstream.write(c);
                ++LLJTran.this.writecounter;
                if (c == 255) {
                    this.outputstream.write(0);
                    ++LLJTran.this.writecounter;
                }
                putbuffer <<= 8;
                putbits -= 8;
            }
            this.bufferputbuffer = putbuffer;
            this.bufferputbits = putbits;
        }

        void flush() throws IOException {
            int c;
            int putbits;
            if (LLJTran.this.gatheringStats) {
                return;
            }
            int putbuffer = this.bufferputbuffer;
            for (putbits = this.bufferputbits; putbits >= 8; putbits -= 8) {
                c = putbuffer >> 16 & 0xFF;
                this.outputstream.write(c);
                ++LLJTran.this.writecounter;
                if (c == 255) {
                    this.outputstream.write(0);
                    ++LLJTran.this.writecounter;
                }
                putbuffer <<= 8;
            }
            if (putbits > 0) {
                c = putbuffer >> 16 & 65280 >> putbits & 0xFF;
                this.outputstream.write(c);
                ++LLJTran.this.writecounter;
            }
            this.bufferputbuffer = putbuffer;
            this.bufferputbits = putbits;
        }
    }

    private class HuffDecoder {
        private InputStream is;
        int bit_buff;
        int bit_buff_len;
        int marker;
        int next_restart_num;
        int[] cur_maxcode;
        int[] cur_huffval;
        int[] cur_valoffset;

        HuffDecoder(InputStream is) {
            this.is = is;
        }

        void setTables(boolean ac, int index) {
            if (ac) {
                for (int i = 0; i < LLJTran.this.ac_ix.length; ++i) {
                    if (LLJTran.this.ac_ix[i] != index) continue;
                    this.cur_maxcode = LLJTran.this.ac_maxcode[i];
                    this.cur_huffval = LLJTran.this.ac_huffval[i];
                    this.cur_valoffset = LLJTran.this.ac_valoffset[i];
                    break;
                }
            } else {
                for (int i = 0; i < LLJTran.this.dc_ix.length; ++i) {
                    if (LLJTran.this.dc_ix[i] != index) continue;
                    this.cur_maxcode = LLJTran.this.dc_maxcode[i];
                    this.cur_huffval = LLJTran.this.dc_huffval[i];
                    this.cur_valoffset = LLJTran.this.dc_valoffset[i];
                    break;
                }
            }
        }

        void checkBitBuffer(int len) throws IOException, RestartException {
            if (this.bit_buff_len < len) {
                if (len > 16) {
                    int n = this.bit_buff_len;
                    String string = String.valueOf(LLJTran.this.getLocationName());
                    throw new IOException(new StringBuilder(76 + String.valueOf(string).length()).append("An attempt to read more than 16 bit (inbuff=").append(n).append(", len=").append(len).append(") (").append(string).append(")").toString());
                }
                do {
                    int nextbyte = this.read();
                    if (LLJTran.this.unprocessed_marker != 0) break;
                    this.bit_buff <<= 8;
                    this.bit_buff |= nextbyte;
                    this.bit_buff_len += 8;
                } while (this.bit_buff_len < len);
            }
        }

        int read() throws IOException, RestartException {
            int result = -1;
            if (LLJTran.this.unprocessed_marker == 0) {
                result = this.is.read();
                ++LLJTran.this.readcounter;
                if (result == -1) {
                    int n = LLJTran.this.readcounter;
                    String string = String.valueOf(LLJTran.this.getLocationName());
                    throw new IOException(new StringBuilder(37 + String.valueOf(string).length()).append("End of file reached at ").append(n).append(" (").append(string).append(")").toString());
                }
                if (result == 255) {
                    do {
                        result = this.is.read();
                        ++LLJTran.this.readcounter;
                    } while (result == 255);
                    if (result == 0) {
                        result = 255;
                    } else {
                        LLJTran.this.unprocessed_marker = result;
                    }
                }
            }
            return result;
        }

        int getBits(int len) throws IOException, RestartException {
            int retVal = 0;
            this.checkBitBuffer(len);
            if (this.bit_buff_len > 0) {
                if (this.bit_buff_len >= len) {
                    this.bit_buff_len -= len;
                    retVal = this.bit_buff >> this.bit_buff_len & 65535 >> 16 - len;
                } else {
                    int defecit = len - this.bit_buff_len;
                    this.bit_buff_len = 0;
                    retVal = this.bit_buff << defecit & 65535 >> 16 - len;
                }
            }
            return retVal;
        }

        int extend(int n_bits) throws IOException, RestartException {
            if (n_bits == 0) {
                return 0;
            }
            int result = this.getBits(n_bits);
            return result < 1 << n_bits - 1 ? result + ((-1 << n_bits) + 1) : result;
        }

        int decode(int min_bits) throws IOException, RestartException {
            int code;
            int l = min_bits;
            for (code = this.getBits(l); code > this.cur_maxcode[l]; code |= this.getBits(1)) {
                String string;
                String string2;
                if (code < 0 && Log.debugLevel >= 1) {
                    string2 = String.valueOf(Integer.toHexString(code));
                    string = String.valueOf(Integer.toHexString(this.cur_maxcode[l]));
                    System.err.println(new StringBuilder(23 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Negative code 0x").append(string2).append(" max 0x").append(string).toString());
                }
                code <<= 1;
                if (++l <= 16) continue;
                string2 = String.valueOf(Integer.toHexString(code));
                string = String.valueOf(Integer.toHexString(this.cur_maxcode[l]));
                String string3 = String.valueOf(Integer.toHexString(LLJTran.this.readcounter));
                String string4 = String.valueOf(LLJTran.this.getLocationName());
                throw new IOException(new StringBuilder(57 + String.valueOf(string2).length() + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Corrupted JPEG data: bad Huffman code, 0x").append(string2).append(" max 0x").append(string).append(" at 0x").append(string3).append(" (").append(string4).append(")").toString());
            }
            return this.cur_huffval[code + this.cur_valoffset[l]];
        }

        void restart() {
            this.bit_buff_len = 0;
            this.bit_buff = 0;
        }
    }
}

