/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.exception;

import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.exception.DatastoreException;

public class ValidationException
extends DatastoreException {
    public static final String DIFFERENT_APP_ID_MESSAGE = "mismatched app ids within request: ";
    public static final String DIFFERENT_DATABASE_MESSAGE = "mismatched databases within request: ";
    public static final String TRANSACTION_WITH_FAILOVER_MESSAGE = "read operations inside transactions can't allow failover";
    public static final String MISSING_APP_ID = "The app id is the empty string.";
    public static final String NEED_ANCESTOR_ERROR = "global queries do not support strong consistency";
    public static final String QUERIES_IN_TRANSACTION_NEED_ANCESTOR = "queries inside transactions must have ancestors";
    public static final String PARENT_INDEX_NOT_ALLOWED = "is not allowed to be defined as a 'parent' index.";

    public ValidationException(String message) {
        super(message, DatastorePb.Error.ErrorCode.BAD_REQUEST, null);
    }

    public ValidationException(String message, Throwable cause) {
        super(message, DatastorePb.Error.ErrorCode.BAD_REQUEST, cause);
    }

    public ValidationException(String message, DatastorePb.Error.ErrorCode errorCode, Throwable cause) {
        super(message, errorCode, cause);
    }

    public static void validateAssertion(boolean assertion, String message, Object ... messageArgs) throws ValidationException {
        if (!assertion) {
            throw new ValidationException(String.format(message, messageArgs));
        }
    }

    public static void validatePrecondition(boolean precondition, String message, Object ... messageArgs) throws ValidationException {
        if (!precondition) {
            throw new ValidationException(String.format(message, messageArgs), DatastorePb.Error.ErrorCode.FAILED_PRECONDITION, null);
        }
    }
}

