/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.rep.$AutoValue_DatabaseRef;
import com.google.apphosting.datastore.rep.AutoValue_DatabaseRef_Directory;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.rep.ResourceRef;
import com.google.auto.value.AutoValue;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

@AutoValue
public abstract class DatabaseRef
implements ResourceRef {
    public static final String DEFAULT_DATABASE = "";
    public static final DatabaseRef EMPTY = DatabaseRef.builder().partitionId("").projectId("").databaseId("").directory(Directory.USER).build();

    public static Builder builder() {
        return new $AutoValue_DatabaseRef.Builder();
    }

    public static DatabaseRef createForProject(String partitionId, String projectId, String databaseId) {
        if (partitionId.isEmpty() && projectId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Preconditions.checkArgument((boolean)RepHelper.PROJECT_ID_REGEX.matcher(projectId).matches(), (Object)"Not a project id");
        return DatabaseRef.builder().directory(Directory.USER).partitionId(partitionId).projectId(projectId).databaseId(databaseId).build();
    }

    public static DatabaseRef createWithUnknownPartitionId(String projectId, String databaseId) {
        if (projectId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        return DatabaseRef.builder().projectId(projectId).databaseId(databaseId).directory(Directory.USER).build();
    }

    public static DatabaseRef createForApp(String appId, String databaseId) {
        Directory directory;
        String projectId;
        if (appId.isEmpty() && databaseId.isEmpty()) {
            return EMPTY;
        }
        Matcher matcher = RepHelper.APP_ID_REGEX.matcher(appId);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Invalid app id");
        String partitionId = matcher.group("cluster") != null ? matcher.group("cluster") : DEFAULT_DATABASE;
        if (matcher.group("metadata") == null) {
            projectId = matcher.group("project");
            directory = Directory.USER;
        } else {
            projectId = matcher.group("metadata");
            if (matcher.group("replica") != null) {
                int replica = Integer.parseInt(matcher.group("replica"));
                Preconditions.checkArgument((replica < Directory.NUM_METADATA_REPLICAS ? 1 : 0) != 0);
                directory = Directory.replicated(replica);
            } else {
                directory = Directory.LEGACY;
            }
        }
        return DatabaseRef.builder().directory(directory).partitionId(partitionId).projectId(projectId).databaseId(databaseId).build();
    }

    public abstract Directory directory();

    @Nullable
    protected abstract String autoPartitionId();

    public abstract String projectId();

    public abstract String databaseId();

    public ByteString databaseIdAsByteString() {
        return ByteString.copyFromUtf8((String)this.databaseId());
    }

    private String internalProjectId() {
        if (this.directory().isLegacy()) {
            String string = "__metadata-";
            String string2 = this.projectId();
            String string3 = "__";
            return new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(string3).toString();
        }
        if (this.directory().isReplicated()) {
            String string = "__metadata-";
            String string4 = String.valueOf(this.directory().replicaId());
            String string5 = this.projectId();
            String string6 = "__";
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string).append(string4).append("_").append(string5).append(string6).toString();
        }
        return this.projectId();
    }

    public String appId() {
        return RepHelper.projectIdToApp(this.partitionId(), this.internalProjectId());
    }

    public ByteString appIdAsByteString() {
        return ByteString.copyFromUtf8((String)this.appId());
    }

    public String partitionId() {
        if (this.autoPartitionId() == null) {
            throw new Error("Unknown partitionId.");
        }
        return this.autoPartitionId();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public String toString() {
        String string;
        String partitionId = this.autoPartitionId() == null ? "<unknown!>" : this.autoPartitionId();
        String appId = RepHelper.projectIdToApp(partitionId, this.internalProjectId());
        if (this.databaseId().isEmpty()) {
            string = appId;
        } else {
            String string2 = this.databaseId();
            string = new StringBuilder(1 + String.valueOf(appId).length() + String.valueOf(string2).length()).append(appId).append("#").append(string2).toString();
        }
        return string;
    }

    public abstract Builder toBuilder();

    public DatabaseRef withDirectory(Directory directory) {
        return this.toBuilder().directory(directory).build();
    }

    public DatabaseRef withoutAppPartition() {
        if (this.autoPartitionId() == null) {
            return this;
        }
        return this.toBuilder().partitionId(null).build();
    }

    public boolean hasAppPartition() {
        return this.autoPartitionId() != null && !this.autoPartitionId().isEmpty();
    }

    public static abstract class Builder {
        public abstract Builder directory(Directory var1);

        public Builder partitionId(@Nullable String partitionId) {
            return this.autoPartitionId(partitionId);
        }

        protected abstract Builder autoPartitionId(@Nullable String var1);

        public abstract Builder projectId(String var1);

        public abstract Builder databaseId(String var1);

        public abstract DatabaseRef build();
    }

    @AutoValue
    public static abstract class Directory {
        public static final ImmutableList<Directory> METADATA_REPLICAS = ImmutableList.of((Object)Directory.replicated(0), (Object)Directory.replicated(1), (Object)Directory.replicated(2));
        public static final int NUM_METADATA_REPLICAS = METADATA_REPLICAS.size();
        public static final Directory USER = new AutoValue_DatabaseRef_Directory(false, false, null);
        public static final Directory LEGACY = new AutoValue_DatabaseRef_Directory(true, false, null);
        public static final Directory ALL_REPLICAS = new AutoValue_DatabaseRef_Directory(false, true, null);

        public boolean isMetadata() {
            return this.isLegacy() || this.isReplicated();
        }

        public abstract boolean isLegacy();

        public abstract boolean isReplicated();

        @Nullable
        public abstract Integer replicaId();

        public static Directory replicated(int replica) {
            return new AutoValue_DatabaseRef_Directory(false, true, replica);
        }
    }
}

