/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.apphosting.datastore.rep.AutoValue_Entity;
import com.google.apphosting.datastore.rep.EntityRef;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.Value;
import com.google.auto.value.AutoValue;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class Entity {
    public static Entity create(EntityRef entityRef, ImmutableMap<String, Value> propertyMap) {
        return new AutoValue_Entity(entityRef, propertyMap);
    }

    public abstract EntityRef ref();

    public abstract ImmutableMap<String, Value> propertyMap();

    @Nullable
    public Value get(PropertyPath propertyPath) {
        return propertyPath.getFrom(this.propertyMap());
    }

    public Entity maskCopy(PropertyMask mask) {
        return mask.entityMaskCopy(this);
    }

    public Entity copyAndMaskReplace(PropertyMask mask, Entity maskedOtherEntity) {
        return mask.entityCopyAndMaskReplace(this, maskedOtherEntity);
    }

    public static Entity create(EntityRef ref, Map<PropertyPath, Value> pathValueMap) {
        ImmutableMap<String, Value> properties = Entity.createEntityProperties(pathValueMap);
        return Entity.create(ref, properties);
    }

    private static ImmutableMap<String, Value> createEntityProperties(Map<PropertyPath, Value> pathValueMap) {
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        HashMap<PropertyName, HashMap<PropertyPath, Value>> nestedPathValueMap = new HashMap<PropertyName, HashMap<PropertyPath, Value>>();
        for (Map.Entry<PropertyPath, Value> entry : pathValueMap.entrySet()) {
            PropertyPath path = entry.getKey();
            Value value = entry.getValue();
            PropertyPathSegment segment = path.segment();
            Preconditions.checkArgument((boolean)(segment instanceof PropertyPathSegment.Member));
            PropertyName propertyName = ((PropertyPathSegment.Member)segment).name();
            PropertyPath next = path.next();
            if (next == null) {
                resultMap.put((Object)propertyName.string(), (Object)value);
                continue;
            }
            HashMap<PropertyPath, Value> nested = (HashMap<PropertyPath, Value>)nestedPathValueMap.get(propertyName);
            if (nested == null) {
                nested = new HashMap<PropertyPath, Value>();
                nestedPathValueMap.put(propertyName, nested);
            }
            nested.put(next, value);
        }
        for (Map.Entry<PropertyPath, Value> entry : nestedPathValueMap.entrySet()) {
            PropertyName propertyName = (PropertyName)((Object)entry.getKey());
            ImmutableMap<String, Value> nestedProperties = Entity.createEntityProperties((Map)((Object)entry.getValue()));
            resultMap.put((Object)propertyName.string(), (Object)Value.createMap(nestedProperties));
        }
        return resultMap.build();
    }
}

