/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.datastore.rep.AutoValue_Mutation;
import com.google.apphosting.datastore.rep.EntityTransformation;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.ReferencePaths;
import com.google.auto.value.AutoValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class Mutation {
    private boolean autoIdInserted = false;

    public abstract boolean allocateKey();

    public abstract Op op();

    @Nullable
    public abstract OnestoreEntity.EntityProto entity();

    @Nullable
    public abstract PropertyMask writePropertyMask();

    @Nullable
    public abstract PropertyMask readPropertyMask();

    @Nullable
    public abstract EntityTransformation transformation();

    public abstract OnestoreEntity.Reference key();

    public boolean replaceEntity() {
        return this.entity() != null && PropertyMask.FULL.equals(this.writePropertyMask()) && this.transformation() == null;
    }

    @Nullable
    public abstract Long baseVersion();

    @Nullable
    public abstract ConflictResolutionStrategy conflictResolutionStrategy();

    public abstract boolean recreateEntity();

    public void setAutoIdInserted() {
        this.autoIdInserted = true;
    }

    public boolean getAutoIdInserted() {
        return this.autoIdInserted;
    }

    public boolean isDelete() {
        return this.op().isDelete();
    }

    public boolean hasConflictDetection() {
        return this.baseVersion() != null;
    }

    public boolean conflictsWith(long serverVersion) {
        return this.baseVersion() != null && this.baseVersion() != serverVersion;
    }

    abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Mutation.Builder().allocateKey(false).recreateEntity(false);
    }

    public static Builder insert(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.INSERT).entityAndFullMask(entity);
    }

    public static Builder update(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.UPDATE).entityAndFullMask(entity);
    }

    public static Builder upsert(OnestoreEntity.EntityProto entity) {
        return Mutation.builder().op(Op.UPSERT).entityAndFullMask(entity);
    }

    public static Builder delete(OnestoreEntity.Reference key) {
        return Mutation.builder().op(Op.DELETE).key(key);
    }

    public static abstract class Builder {
        abstract Builder allocateKey(boolean var1);

        public abstract Builder op(Op var1);

        public abstract Builder entity(@Nullable OnestoreEntity.EntityProto var1);

        public abstract Builder writePropertyMask(@Nullable PropertyMask var1);

        public abstract Builder readPropertyMask(@Nullable PropertyMask var1);

        public abstract Builder transformation(@Nullable EntityTransformation var1);

        public abstract Builder key(OnestoreEntity.Reference var1);

        public abstract Builder baseVersion(@Nullable Long var1);

        public abstract Builder conflictResolutionStrategy(@Nullable ConflictResolutionStrategy var1);

        public abstract Builder recreateEntity(boolean var1);

        public Builder entityAndFullMask(OnestoreEntity.EntityProto entity) {
            return this.key(entity.getKey()).entity(entity).writePropertyMask(PropertyMask.FULL).readPropertyMask(PropertyMask.FULL);
        }

        abstract Mutation autoBuild();

        public Mutation build() {
            Mutation mutation = this.autoBuild();
            if (mutation.op().isDelete()) {
                Preconditions.checkArgument((mutation.transformation() == null ? 1 : 0) != 0, (Object)"Transformation cannot be set for delete.");
                Preconditions.checkArgument((!mutation.recreateEntity() ? 1 : 0) != 0, (Object)"Cannot recreate entity for delete.");
            }
            Builder.checkNullIff(mutation.entity(), mutation.op().isDelete(), "Entity should be set IFF op is not delete.");
            Builder.checkNullIff(mutation.writePropertyMask(), mutation.entity() == null, "WritePropertyMask should be set IFF entity is set.");
            Builder.checkNullIff(mutation.readPropertyMask(), mutation.entity() == null, "ReadPropertyMask should be set IFF entity is set.");
            Builder.checkNullIff((Object)mutation.conflictResolutionStrategy(), mutation.baseVersion() == null, "ConflictResolutionStrategy should be set IFF baseVersion is set.");
            if (mutation.entity() != null) {
                Preconditions.checkArgument((boolean)mutation.writePropertyMask().hasKey());
                Preconditions.checkArgument((boolean)mutation.readPropertyMask().hasKey());
                if (ReferencePaths.hasIncompleteLastElement(mutation.key())) {
                    Preconditions.checkArgument((mutation.op() != Op.UPDATE ? 1 : 0) != 0, (Object)"Key cannot have incomplete last element path for update.");
                    mutation = mutation.toBuilder().op(Op.INSERT).allocateKey(true).autoBuild();
                }
            }
            return mutation;
        }

        private static void checkNullIff(@Nullable Object maybeNull, boolean state, String message) {
            Preconditions.checkArgument((maybeNull == null == state ? 1 : 0) != 0, (Object)message);
        }
    }

    public static enum ConflictResolutionStrategy {
        SERVER_VALUE,
        CLIENT_VALUE,
        FAIL;

    }

    public static enum Op {
        INSERT(false),
        UPDATE(false),
        UPSERT(false),
        DELETE(true),
        DELETE_MUST_EXIST(true),
        DELETE_MUST_NOT_EXIST(true);

        private final boolean isDelete;

        private Op(boolean isDelete) {
            this.isDelete = isDelete;
        }

        public boolean isDelete() {
            return this.isDelete;
        }
    }
}

