/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.rep.Value;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;

public class PropertyPath
implements Comparable<PropertyPath> {
    public static final PropertyPath KEY = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.KEY);
    public static final PropertyPath KIND = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.KIND);
    public static final PropertyPath SCATTER = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.SCATTER);
    public static final PropertyPath SPLITS = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.SPLITS);
    public static final PropertyPath UNAPPLIED_LOG_TIMESTAMP_US = PropertyPath.createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor.UNAPPLIED_LOG_TIMESTAMP_US);
    private final PropertyPathSegment segment;
    @Nullable
    private final PropertyPath next;

    private PropertyPath(PropertyPathSegment segment, @Nullable PropertyPath next) {
        this.segment = segment;
        this.next = next;
    }

    public static int compare(@Nullable PropertyPath leftPath, @Nullable PropertyPath rightPath) {
        if (leftPath == null) {
            if (rightPath == null) {
                return 0;
            }
            return -1;
        }
        if (rightPath == null) {
            return 1;
        }
        int segmentComparison = leftPath.segment().compareTo(rightPath.segment());
        if (segmentComparison != 0) {
            return segmentComparison;
        }
        return PropertyPath.compare(leftPath.next(), rightPath.next());
    }

    public static PropertyPath createFromSegments(List<PropertyPathSegment> segments) {
        PropertyPath propertyPath = null;
        for (int index = segments.size() - 1; index >= 0; --index) {
            PropertyPathSegment segment = segments.get(index);
            propertyPath = PropertyPath.create(segment, propertyPath);
        }
        return propertyPath;
    }

    public static PropertyPath createFromMemberName(String name) {
        return PropertyPath.create(PropertyPathSegment.Member.create(PropertyName.fromUtf8(name)), null);
    }

    public static PropertyPath create(PropertyPathSegment segment, @Nullable PropertyPath next) {
        return new PropertyPath(segment, next);
    }

    public static PropertyPath create(@Nullable PropertyPath prefix, PropertyPathSegment segment) {
        if (prefix == null) {
            return PropertyPath.create(segment, null);
        }
        PropertyPath remainder = prefix.next() == null ? PropertyPath.create(segment, null) : PropertyPath.create(prefix.next(), segment);
        return PropertyPath.create(prefix.segment(), remainder);
    }

    public static PropertyPath createFromAmbiguousPathString(String name) {
        return PropertyPath.createFromAmbiguousPathByteArray(name.getBytes(StandardCharsets.UTF_8));
    }

    public static PropertyPath createFromAmbiguousPathByteArray(byte[] byteArray) {
        String stringLossy = ProtocolSupport.toStringUtf8((byte[])byteArray);
        PropertyName propertyName = PropertyName.fromByteArrayAndUtf8(byteArray, stringLossy);
        return PropertyPath.create(PropertyPathSegment.Member.create(propertyName), null);
    }

    private static PropertyPath createFromSpecialPropertyDescriptor(SpecialPropertyDescriptor special) {
        return PropertyPath.createFromMemberName(special.getPropertyName());
    }

    public PropertyPathSegment segment() {
        return this.segment;
    }

    public PropertyPathSegment lastSegment() {
        return this.next() == null ? this.segment() : this.next().lastSegment();
    }

    @Nullable
    public PropertyPath next() {
        return this.next;
    }

    @Nullable
    Value getFrom(ImmutableList<Value> array) {
        Value subValue = this.segment().getFrom(array);
        if (subValue == null || this.next() == null) {
            return subValue;
        }
        return subValue.get(this.next());
    }

    @Nullable
    Value getFrom(ImmutableMap<String, Value> map) {
        Value subValue = this.segment().getFrom(map);
        if (subValue == null || this.next() == null) {
            return subValue;
        }
        return subValue.get(this.next());
    }

    @Nullable
    public SpecialPropertyDescriptor special() {
        return this.segment().special();
    }

    public PropertyName asPropertyNameWithDelimiterAmbiguity() {
        Preconditions.checkState((this.next() == null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)(this.segment() instanceof PropertyPathSegment.Member));
        return ((PropertyPathSegment.Member)this.segment()).name();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        for (PropertyPath path = this; path != null; path = path.next()) {
            path.segment().appendAsString(isFirst, stringBuilder);
            isFirst = false;
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(@Nullable PropertyPath other) {
        return PropertyPath.compare(this, other);
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof PropertyPath)) {
            return false;
        }
        PropertyPath otherPropertyPath = (PropertyPath)otherObject;
        return this.compareTo(otherPropertyPath) == 0;
    }

    public int hashCode() {
        int hashCode = this.segment().hashCode();
        if (this.next() != null) {
            hashCode ^= this.next().hashCode();
        }
        return hashCode;
    }

    public String asStringLossy() {
        return this.toString();
    }
}

