/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.appengv3;

import com.google.appengine.repackaged.com.google.datastore.v1.CompositeFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.FilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilterOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Value;
import com.google.apphosting.datastore.rep.Condition;
import com.google.apphosting.datastore.rep.ConditionVisitor;
import com.google.apphosting.datastore.rep.Direction;
import com.google.apphosting.datastore.rep.Query;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public final class QueryHelper {
    public static int getQueryMaxResultsWithOffsetLimitAndPeek(Query query) {
        int actualLimit;
        Integer limitInteger = query.limit();
        if (limitInteger == null) {
            actualLimit = Integer.MAX_VALUE;
        } else {
            actualLimit = query.offset() + limitInteger;
            if (actualLimit > 0) {
                ++actualLimit;
            }
            if (actualLimit < 0) {
                actualLimit = Integer.MAX_VALUE;
            }
        }
        return actualLimit;
    }

    public static boolean isQuerySearch(Query query) {
        return new ConditionVisitor(){

            @Override
            protected boolean visit(Condition condition) {
                return condition.op() == Condition.Op.GEO_IN;
            }
        }.visitLeafConditions(query.condition());
    }

    public static boolean hasAncestorOrParent(QueryOrBuilder query) {
        return QueryHelper.getFirstAncestorOrParentKey((FilterOrBuilder)query.getFilter()) != null;
    }

    private static Key getFirstAncestorOrParentKey(FilterOrBuilder filter) {
        switch (filter.getFilterTypeCase()) {
            case PROPERTY_FILTER: {
                PropertyFilterOrBuilder propFilter = filter.getPropertyFilterOrBuilder();
                if (propFilter.getPropertyOrBuilder().getName().equals(SpecialPropertyDescriptor.KEY.getPropertyName()) && propFilter.getValue().getValueTypeCase() == Value.ValueTypeCase.KEY_VALUE && (propFilter.getOp() == PropertyFilter.Operator.HAS_ANCESTOR || propFilter.getOp() == PropertyFilter.Operator.HAS_PARENT)) {
                    return propFilter.getValue().getKeyValue();
                }
                return null;
            }
            case COMPOSITE_FILTER: {
                if (filter.getCompositeFilter().getOp() == CompositeFilter.Operator.AND) {
                    for (Filter subFilter : filter.getCompositeFilter().getFiltersList()) {
                        Key ancestor = QueryHelper.getFirstAncestorOrParentKey((FilterOrBuilder)subFilter);
                        if (ancestor == null) continue;
                        return ancestor;
                    }
                }
                return null;
            }
            case FILTERTYPE_NOT_SET: {
                return null;
            }
        }
        String string = String.valueOf(filter.getFilterTypeCase());
        throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(string).length()).append("Unrecognized filter_type: ").append(string).toString());
    }

    @Nullable
    public static Direction convertV3IndexDirectionToRep(OnestoreEntity.Index.Property.Direction direction) {
        switch (direction) {
            case ASCENDING: {
                return Direction.ASCENDING;
            }
            case DESCENDING: {
                return Direction.DESCENDING;
            }
            case DIRECTION_UNSPECIFIED: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    private QueryHelper() {
    }
}

