/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.cloudv1;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResult;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequestOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.service.appengv3.TransactionConverter;
import com.google.apphosting.datastore.service.cloudv1.AppEngV3ToCloudDatastoreV1Converter;
import com.google.apphosting.datastore.service.cloudv1.CloudDatastoreV1ToAppEngV3Converter;
import com.google.apphosting.datastore.service.cloudv1.EntityV3V1Converter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

public abstract class BaseCloudDatastoreV1Converter {
    public static final String UNKNOWN_PROJECT_ID = "__unknown__";
    protected final TransactionConverter transactionConverter;
    protected final CloudDatastoreV1ToAppEngV3Converter cloudDatastoreV1ToAppEngV3Converter;
    protected final AppEngV3ToCloudDatastoreV1Converter appEngV3ToCloudDatastoreV1Converter;

    public BaseCloudDatastoreV1Converter(TransactionConverter transactionConverter, CloudDatastoreV1ToAppEngV3Converter cloudDatastoreV1ToAppEngV3Converter, AppEngV3ToCloudDatastoreV1Converter appEngV3ToCloudDatastoreV1Converter) {
        this.transactionConverter = transactionConverter;
        this.cloudDatastoreV1ToAppEngV3Converter = cloudDatastoreV1ToAppEngV3Converter;
        this.appEngV3ToCloudDatastoreV1Converter = appEngV3ToCloudDatastoreV1Converter;
    }

    public DatastorePb.GetRequest toV3GetRequest(ProjectIdAppIdResolver resolver, LookupRequestOrBuilder req, @Nullable ByteString newTxnBytes, String appId, String databaseId) throws InvalidConversionException {
        ReadOptions.ConsistencyTypeCase consistencyType = req.getReadOptions().getConsistencyTypeCase();
        Preconditions.checkArgument((newTxnBytes != null == (consistencyType == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION) ? 1 : 0) != 0);
        DatastorePb.GetRequest get = new DatastorePb.GetRequest();
        get.setAllowDeferred(true);
        block0 : switch (consistencyType) {
            case CONSISTENCYTYPE_NOT_SET: {
                break;
            }
            case NEW_TRANSACTION: {
                get.setTransaction(this.transactionConverter.toV3Transaction(newTxnBytes, appId, databaseId));
                break;
            }
            case TRANSACTION: {
                get.setTransaction(this.transactionConverter.toV3Transaction(req.getReadOptions().getTransaction(), appId, databaseId));
                break;
            }
            case READ_CONSISTENCY: {
                ReadOptions.ReadConsistency readConsistency = req.getReadOptionsOrBuilder().getReadConsistency();
                switch (readConsistency) {
                    case READ_CONSISTENCY_UNSPECIFIED: {
                        break block0;
                    }
                    case STRONG: {
                        get.setStrong(true);
                        break block0;
                    }
                    case EVENTUAL: {
                        get.setStrong(false);
                        get.setFailoverMs(-1L);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Unhandled read consistency: %s", readConsistency.name()));
            }
            default: {
                throw new IllegalArgumentException(String.format("Unhandled consistency type: %s", consistencyType.name()));
            }
        }
        for (Key key : req.getKeysList()) {
            get.addKey(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)key));
        }
        return get;
    }

    public LookupResponse.Builder toV1LookupResponse(ProjectIdAppIdResolver resolver, DatastorePb.GetResponse res, @Nullable ByteString adHocTxn) throws InvalidConversionException {
        LookupResponse.Builder builder = LookupResponse.newBuilder();
        if (adHocTxn != null) {
            builder.setTransaction(adHocTxn);
        }
        for (OnestoreEntity.Reference key : res.deferreds()) {
            builder.addDeferred(EntityV3V1Converter.INSTANCE.toV1Key(resolver, key));
        }
        for (DatastorePb.GetResponse.Entity entity : res.entitys()) {
            EntityResult.Builder entityResult = this.appEngV3ToCloudDatastoreV1Converter.toV1EntityResult(resolver, entity);
            if (entity.hasEntity()) {
                builder.addFound(entityResult);
            }
            if (!entity.hasKey()) continue;
            builder.addMissing(entityResult);
        }
        return builder;
    }

    public DatastorePb.Query toV3Query(ProjectIdAppIdResolver resolver, RunQueryRequestOrBuilder request, @Nullable ByteString newTxnBytes, boolean allowInMemoryOperations) throws InvalidConversionException {
        ReadOptions.ConsistencyTypeCase consistencyType = request.getReadOptions().getConsistencyTypeCase();
        Preconditions.checkArgument((newTxnBytes != null == (consistencyType == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION) ? 1 : 0) != 0);
        DatastorePb.Query result = this.cloudDatastoreV1ToAppEngV3Converter.toV3Query(resolver, request.getPartitionIdOrBuilder(), (QueryOrBuilder)request.getQuery());
        result.setCount(Integer.MAX_VALUE);
        result.setRequirePerfectPlan(!allowInMemoryOperations);
        block0 : switch (consistencyType) {
            case CONSISTENCYTYPE_NOT_SET: {
                break;
            }
            case NEW_TRANSACTION: {
                result.setTransaction(this.transactionConverter.toV3Transaction(newTxnBytes, result.getApp(), result.getDatabaseId()));
                break;
            }
            case TRANSACTION: {
                result.setTransaction(this.transactionConverter.toV3Transaction(request.getReadOptions().getTransaction(), result.getApp(), result.getDatabaseId()));
                break;
            }
            case READ_CONSISTENCY: {
                ReadOptions.ReadConsistency readConsistency = request.getReadOptionsOrBuilder().getReadConsistency();
                switch (readConsistency) {
                    case READ_CONSISTENCY_UNSPECIFIED: {
                        break block0;
                    }
                    case STRONG: {
                        result.setStrong(true);
                        break block0;
                    }
                    case EVENTUAL: {
                        result.setStrong(false);
                        result.setFailoverMs(-1L);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Unhandled read consistency: %s", readConsistency.name()));
            }
            default: {
                throw new IllegalArgumentException(String.format("Unhandled consistency type: %s", consistencyType.name()));
            }
        }
        return result;
    }
}

