/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Shape;
import java.io.Serializable;

@GwtCompatible(serializable=true)
public final class S2Edge
implements Serializable,
S2Shape {
    private final S2Point start;
    private final S2Point end;

    public S2Edge(S2Point start, S2Point end) {
        this.start = start;
        this.end = end;
    }

    public S2Point getStart() {
        return this.start;
    }

    public S2Point getEnd() {
        return this.end;
    }

    public String toString() {
        String string = this.start.toDegreesString();
        String string2 = this.end.toDegreesString();
        return new StringBuilder(12 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Edge: (").append(string).append(" -> ").append(string2).append(")").toString();
    }

    public int hashCode() {
        return this.getStart().hashCode() - this.getEnd().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof S2Edge)) {
            return false;
        }
        S2Edge other = (S2Edge)o;
        return this.getStart().equalsPoint(other.getStart()) && this.getEnd().equalsPoint(other.getEnd());
    }

    @Override
    public int numEdges() {
        return 1;
    }

    @Override
    public void getEdge(int index, S2Shape.MutableEdge result) {
        result.set(this.start, this.end);
    }

    @Override
    public boolean hasInterior() {
        return false;
    }

    @Override
    public boolean containsOrigin() {
        return false;
    }
}

