/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.appengv4;

import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponseOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.MutationResult;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.service.appengv4.AppEngV3ToAppEngV4Converter;
import com.google.apphosting.datastore.service.appengv4.AppEngV4IntraConverter;
import com.google.apphosting.datastore.service.appengv4.AppEngV4ToAppEngV3Converter;
import com.google.apphosting.datastore.service.appengv4.AppEngV4ToCloudDatastoreV1Converter;
import com.google.apphosting.datastore.service.appengv4.CloudDatastoreV1ToAppEngV4Converter;
import com.google.apphosting.datastore.service.appengv4.EntityV4Converter;
import com.google.apphosting.datastore.service.appengv4.LocalTransactionConverter;
import com.google.apphosting.datastore.service.cloudv1.AppEngV3ToCloudDatastoreV1Converter;
import com.google.apphosting.datastore.service.cloudv1.CloudDatastoreV1ToAppEngV3Converter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.shared.Config;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;

public class EmulatorAppEngV4Converter {
    private final LocalTransactionConverter transactionConverter;
    private final EntityV4Converter entityV4Converter;
    private final AppEngV4ToCloudDatastoreV1Converter appEngV4ToCloudDatastoreV1Converter;
    private final AppEngV4ToAppEngV3Converter appEngV4ToAppEngV3Converter;
    private final AppEngV3ToAppEngV4Converter appEngV3ToAppEngV4Converter;
    private final AppEngV4IntraConverter appEngV4IntraConverter;

    public EmulatorAppEngV4Converter(Config.DatastoreConfig datastoreConfig, LocalTransactionConverter transactionConverter, EntityV4Converter entityV4Converter) {
        AppEngV3ToCloudDatastoreV1Converter appEngV3ToCloudDatastoreV1Converter = new AppEngV3ToCloudDatastoreV1Converter(datastoreConfig);
        CloudDatastoreV1ToAppEngV3Converter cloudDatastoreV1ToAppEngV3Converter = new CloudDatastoreV1ToAppEngV3Converter();
        CloudDatastoreV1ToAppEngV4Converter cloudDatastoreV1ToAppEngV4Converter = new CloudDatastoreV1ToAppEngV4Converter(entityV4Converter);
        this.transactionConverter = transactionConverter;
        this.entityV4Converter = entityV4Converter;
        this.appEngV4ToCloudDatastoreV1Converter = new AppEngV4ToCloudDatastoreV1Converter(entityV4Converter);
        this.appEngV4ToAppEngV3Converter = new AppEngV4ToAppEngV3Converter(entityV4Converter, this.appEngV4ToCloudDatastoreV1Converter, cloudDatastoreV1ToAppEngV3Converter);
        this.appEngV3ToAppEngV4Converter = new AppEngV3ToAppEngV4Converter(entityV4Converter, appEngV3ToCloudDatastoreV1Converter, cloudDatastoreV1ToAppEngV4Converter);
        this.appEngV4IntraConverter = new AppEngV4IntraConverter(entityV4Converter, this.appEngV4ToCloudDatastoreV1Converter, cloudDatastoreV1ToAppEngV4Converter);
    }

    public DatastoreV4.Query.Builder toV4Query(DatastoreV4.GqlQueryOrBuilder gqlQuery, EntityV4.PartitionIdOrBuilder partitionId) throws InvalidConversionException {
        return this.appEngV4IntraConverter.toV4Query(gqlQuery, partitionId);
    }

    private DatastorePb.Cursor toV3Cursor(ByteString queryHandleV4) throws InvalidConversionException {
        try {
            return (DatastorePb.Cursor)DatastorePb.Cursor.parser().parseFrom(queryHandleV4);
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidConversionException(e);
        }
    }

    private ByteString toV4QueryHandle(DatastorePb.Cursor cursorV3) throws InvalidConversionException {
        return cursorV3.toByteString();
    }

    public DatastorePb.GetRequest toV3GetRequest(DatastoreV4.LookupRequestOrBuilder req, String appId, String databaseId) throws InvalidConversionException {
        DatastorePb.GetRequest get = new DatastorePb.GetRequest();
        get.setAllowDeferred(true);
        if (req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL) {
            get.setFailoverMs(-1L);
        } else if (req.getReadOptionsOrBuilder().getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG) {
            get.setStrong(true);
        }
        if (req.getReadOptionsOrBuilder().hasTransaction()) {
            get.setTransaction(this.transactionConverter.toV3Transaction(req.getReadOptionsOrBuilder().getTransaction(), appId, databaseId));
        }
        for (EntityV4.Key key : req.getKeyList()) {
            get.addKey(this.entityV4Converter.toV3Reference((EntityV4.KeyOrBuilder)key));
        }
        return get;
    }

    public DatastoreV4.LookupResponse.Builder toV4LookupResponse(DatastorePb.GetResponse res) throws InvalidConversionException {
        DatastoreV4.LookupResponse.Builder builder = DatastoreV4.LookupResponse.newBuilder();
        for (OnestoreEntity.Reference key : res.deferreds()) {
            builder.addDeferred(this.entityV4Converter.toV4Key(key));
        }
        for (DatastorePb.GetResponse.Entity entity : res.entitys()) {
            DatastoreV4.EntityResult.Builder entityResult = this.appEngV3ToAppEngV4Converter.toV4EntityResult(entity);
            if (entity.hasEntity()) {
                builder.addFound(entityResult);
            }
            if (!entity.hasKey()) continue;
            builder.addMissing(entityResult);
        }
        return builder;
    }

    public DatastorePb.Query toV3Query(DatastoreV4.RunQueryRequestOrBuilder request, String appId, String databaseId) throws InvalidConversionException {
        DatastoreV4.ReadOptionsOrBuilder options;
        DatastorePb.Query result = this.appEngV4ToAppEngV3Converter.toV3Query(request.getPartitionIdOrBuilder(), request.getQueryOrBuilder());
        if (request.hasSuggestedBatchSize()) {
            result.setCount(request.getSuggestedBatchSize());
        }
        if ((options = request.getReadOptionsOrBuilder()).hasTransaction()) {
            result.setTransaction(this.transactionConverter.toV3Transaction(options.getTransaction(), appId, databaseId));
        } else if (options.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.STRONG) {
            result.setStrong(true);
        } else if (options.getReadConsistency() == DatastoreV4.ReadOptions.ReadConsistency.EVENTUAL) {
            result.setStrong(false);
            result.setFailoverMs(-1L);
        }
        if (request.hasMinSafeTimeSeconds()) {
            result.setMinSafeTimeSeconds(request.getMinSafeTimeSeconds());
        }
        return result;
    }

    public DatastoreV4.RunQueryResponse.Builder toV4RunQueryResponse(DatastorePb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.RunQueryResponse.Builder builder = DatastoreV4.RunQueryResponse.newBuilder();
        builder.setBatch(this.appEngV3ToAppEngV4Converter.toV4QueryResultBatch(result));
        if (result.hasCursor()) {
            builder.setQueryHandle(this.toV4QueryHandle(result.getCursor()));
        }
        return builder;
    }

    public DatastorePb.NextRequest toV3NextRequest(DatastoreV4.ContinueQueryRequestOrBuilder req) throws InvalidConversionException {
        DatastorePb.NextRequest next = new DatastorePb.NextRequest();
        next.setCompile(true);
        next.setCursor(this.toV3Cursor(req.getQueryHandle()));
        return next;
    }

    public DatastoreV4.ContinueQueryResponse.Builder toV4ContinueQueryResponse(DatastorePb.QueryResult result) throws InvalidConversionException {
        DatastoreV4.ContinueQueryResponse.Builder builder = DatastoreV4.ContinueQueryResponse.newBuilder();
        builder.setBatch(this.appEngV3ToAppEngV4Converter.toV4QueryResultBatch(result));
        return builder;
    }

    public DatastorePb.BeginTransactionRequest toV3BeginTransactionRequest(String app, DatastoreV4.BeginTransactionRequestOrBuilder req) {
        DatastorePb.BeginTransactionRequest reqV3 = new DatastorePb.BeginTransactionRequest();
        reqV3.setApp(app);
        reqV3.setAllowMultipleEg(req.getCrossGroup());
        return reqV3;
    }

    public DatastoreV4.BeginTransactionResponse.Builder toV4BeginTransactionResponse(DatastorePb.Transaction txn) throws InvalidConversionException {
        DatastoreV4.BeginTransactionResponse.Builder builder = DatastoreV4.BeginTransactionResponse.newBuilder();
        builder.setTransaction(this.transactionConverter.toTransactionBytes(txn));
        return builder;
    }

    public DatastorePb.Transaction toV3Transaction(DatastoreV4.RollbackRequestOrBuilder req, String appId, String databaseId) throws InvalidConversionException {
        return this.transactionConverter.toV3Transaction(req.getTransaction(), appId, databaseId);
    }

    public CommitRequest.Builder toV1CommitRequest(ProjectIdAppIdResolver resolver, DatastoreV4.CommitRequest reqV4) throws InvalidConversionException {
        CommitRequest.Builder reqV1 = CommitRequest.newBuilder();
        InvalidConversionException.checkConversion(reqV4.getMutationList().isEmpty() || !reqV4.hasDeprecatedMutation(), "CommitRequest has both a mutation list and a deprecated mutation", new Object[0]);
        if (reqV4.hasDeprecatedMutation()) {
            DatastoreV4.DeprecatedMutation deprecatedMutation = reqV4.getDeprecatedMutation();
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.UPSERT, deprecatedMutation.getUpsertList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.UPDATE, deprecatedMutation.getUpdateList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertList());
            this.addV1Mutations(resolver, reqV1, DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertAutoIdList());
            for (DatastoreV4.Mutation.Builder mutation : this.appEngV4IntraConverter.toV4DeleteMutationList(deprecatedMutation.getDeleteList())) {
                reqV1.addMutations(this.appEngV4ToCloudDatastoreV1Converter.toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutation));
            }
        } else {
            for (DatastoreV4.Mutation mutationV4 : reqV4.getMutationList()) {
                reqV1.addMutations(this.appEngV4ToCloudDatastoreV1Converter.toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutationV4));
            }
        }
        switch (reqV4.getMode()) {
            case NON_TRANSACTIONAL: {
                reqV1.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
                break;
            }
            case TRANSACTIONAL: {
                reqV1.setMode(CommitRequest.Mode.TRANSACTIONAL);
                break;
            }
            default: {
                throw InvalidConversionException.unrecognizedEnumValue("mutation.mode", reqV4.getMode());
            }
        }
        if (reqV4.hasTransaction()) {
            reqV1.setTransaction(reqV4.getTransaction());
        }
        this.inferRequestHeader(reqV1);
        return reqV1;
    }

    private void addV1Mutations(ProjectIdAppIdResolver resolver, CommitRequest.Builder reqV1, DatastoreV4.Mutation.Operation op, List<EntityV4.Entity> entities) throws InvalidConversionException {
        for (DatastoreV4.Mutation.Builder mutation : this.appEngV4IntraConverter.toV4MutationList(op, entities)) {
            reqV1.addMutations(this.appEngV4ToCloudDatastoreV1Converter.toV1Mutation(resolver, (DatastoreV4.MutationOrBuilder)mutation));
        }
    }

    public DatastoreV4.CommitResponse.Builder toV4CommitResponse(ProjectIdAppIdResolver resolver, CommitResponseOrBuilder resV1) throws InvalidConversionException {
        DatastoreV4.CommitResponse.Builder resV4 = DatastoreV4.CommitResponse.newBuilder();
        for (MutationResult resultV1 : resV1.getMutationResultsList()) {
            resV4.addMutationResult(this.toV4MutationResult(resolver, resultV1));
        }
        resV4.setIndexUpdates(resV1.getIndexUpdates());
        return resV4;
    }

    private DatastoreV4.MutationResult.Builder toV4MutationResult(ProjectIdAppIdResolver resolver, MutationResult resultV1) throws InvalidConversionException {
        DatastoreV4.MutationResult.Builder resultV4 = DatastoreV4.MutationResult.newBuilder();
        if (resultV1.hasKey()) {
            resultV4.setKey(this.entityV4Converter.toV4Key(resolver, (KeyOrBuilder)resultV1.getKey()));
        }
        return resultV4;
    }

    private void inferRequestHeader(CommitRequest.Builder reqV1) {
        for (Mutation mutation : reqV1.getMutationsList()) {
            switch (mutation.getOperationCase()) {
                case INSERT: {
                    reqV1.setProjectId(mutation.getInsert().getKey().getPartitionId().getProjectId());
                    return;
                }
                case UPDATE: {
                    reqV1.setProjectId(mutation.getUpdate().getKey().getPartitionId().getProjectId());
                    return;
                }
                case UPSERT: {
                    reqV1.setProjectId(mutation.getUpsert().getKey().getPartitionId().getProjectId());
                    return;
                }
                case DELETE: {
                    reqV1.setProjectId(mutation.getDelete().getPartitionId().getProjectId());
                    return;
                }
            }
        }
        reqV1.setProjectId("__unknown__");
    }
}

