/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.cloudv1;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.rep.Lookup;
import com.google.apphosting.datastore.rep.Mutation;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.service.appengv3.TransactionConverter;
import com.google.apphosting.datastore.service.cloudv1.CloudDatastoreV1PropertyPathToRepConverter;
import com.google.apphosting.datastore.service.cloudv1.EntityV3V1Converter;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.apphosting.datastore.service.common.ValidationConstraint;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class CloudDatastoreV1ToRepConverter {
    protected final TransactionConverter transactionConverter;
    protected final CloudDatastoreV1PropertyPathToRepConverter propertyPathToRepConverter;
    private final Supplier<Boolean> allowPartialUpdates;
    private final Supplier<Boolean> allowPartialReads;

    public CloudDatastoreV1ToRepConverter(TransactionConverter transactionConverter, CloudDatastoreV1PropertyPathToRepConverter propertyPathToRepConverter, Supplier<Boolean> allowPartialUpdates, Supplier<Boolean> allowPartialReads) {
        this.transactionConverter = transactionConverter;
        this.propertyPathToRepConverter = propertyPathToRepConverter;
        this.allowPartialUpdates = allowPartialUpdates;
        this.allowPartialReads = allowPartialReads;
    }

    public CloudDatastoreV1ToRepConverter(TransactionConverter transactionConverter, CloudDatastoreV1PropertyPathToRepConverter propertyPathToRepConverter, boolean allowPartialUpdates, boolean allowPartialReads) {
        this(transactionConverter, propertyPathToRepConverter, (Supplier<Boolean>)Suppliers.ofInstance((Object)allowPartialUpdates), (Supplier<Boolean>)Suppliers.ofInstance((Object)allowPartialReads));
    }

    public Lookup toLookup(ProjectIdAppIdResolver resolver, LookupRequestOrBuilder req, @Nullable ByteString newTxnBytes) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!req.hasPropertyMask() || (Boolean)this.allowPartialReads.get() != false, "setting a property mask on a lookup is not allowed", new Object[0]);
        ReadOptions.ConsistencyTypeCase consistencyType = req.getReadOptions().getConsistencyTypeCase();
        Preconditions.checkArgument((newTxnBytes != null == (consistencyType == ReadOptions.ConsistencyTypeCase.NEW_TRANSACTION) ? 1 : 0) != 0);
        Lookup.Builder builder = Lookup.builder().allowDefer(true);
        block0 : switch (consistencyType) {
            case CONSISTENCYTYPE_NOT_SET: {
                break;
            }
            case NEW_TRANSACTION: {
                builder.transaction(this.transactionConverter.toTransactionHandle(newTxnBytes));
                break;
            }
            case TRANSACTION: {
                builder.transaction(this.transactionConverter.toTransactionHandle(req.getReadOptions().getTransaction()));
                break;
            }
            case READ_CONSISTENCY: {
                ReadOptions.ReadConsistency readConsistency = req.getReadOptionsOrBuilder().getReadConsistency();
                switch (readConsistency) {
                    case READ_CONSISTENCY_UNSPECIFIED: 
                    case STRONG: {
                        break block0;
                    }
                    case EVENTUAL: {
                        builder.isStrong(false);
                        builder.allowFailover(true);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(String.format("Unhandled read consistency: %s", readConsistency.name()));
            }
            default: {
                throw new IllegalArgumentException(String.format("Unhandled consistency type: %s", consistencyType.name()));
            }
        }
        ImmutableList.Builder v3Keys = ImmutableList.builder();
        for (Key key : req.getKeysList()) {
            v3Keys.add((Object)EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)key));
        }
        builder.keys((Iterable<OnestoreEntity.Reference>)v3Keys.build());
        if (req.hasPropertyMask()) {
            builder.propertyMask(this.toPropertyMask(req.getPropertyMask(), ValidationConstraint.LOOKUP));
        }
        return builder.build();
    }

    public PropertyMask toPropertyMask(com.google.appengine.repackaged.com.google.datastore.v1.PropertyMask propertyMask, ValidationConstraint constraint) throws InvalidConversionException {
        return this.propertyPathToRepConverter.convertPropertyMask(propertyMask, constraint);
    }

    public ImmutableList<Mutation> toMutationList(ProjectIdAppIdResolver resolver, List<com.google.appengine.repackaged.com.google.datastore.v1.Mutation> requestMutations) throws InvalidConversionException {
        ImmutableList.Builder internalMutations = ImmutableList.builder();
        block15: for (com.google.appengine.repackaged.com.google.datastore.v1.Mutation mutation : requestMutations) {
            Long baseVersion = null;
            switch (mutation.getConflictDetectionStrategyCase()) {
                case CONFLICTDETECTIONSTRATEGY_NOT_SET: {
                    InvalidConversionException.checkConversion(mutation.getConflictResolutionStrategy() == Mutation.ConflictResolutionStrategy.STRATEGY_UNSPECIFIED, "cannot set a conflict resolution strategy if no detection strategy was set", new Object[0]);
                    break;
                }
                case BASE_VERSION: {
                    baseVersion = mutation.getBaseVersion();
                    InvalidConversionException.checkConversion(baseVersion >= 0L, "Invalid base_version: %d, it should be >= 0", baseVersion);
                    break;
                }
                default: {
                    throw new InvalidConversionException("Unknown conflict detection strategy.");
                }
            }
            Mutation.ConflictResolutionStrategy resolutionStrategy = null;
            if (baseVersion != null) {
                switch (mutation.getConflictResolutionStrategy()) {
                    case STRATEGY_UNSPECIFIED: 
                    case SERVER_VALUE: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.SERVER_VALUE;
                        break;
                    }
                    case CLIENT_VALUE: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.CLIENT_VALUE;
                        break;
                    }
                    case FAIL: {
                        resolutionStrategy = Mutation.ConflictResolutionStrategy.FAIL;
                        break;
                    }
                    default: {
                        throw new InvalidConversionException("Unknown conflict resolution strategy.");
                    }
                }
            }
            InvalidConversionException.checkConversion(!mutation.hasPropertyMask() || (Boolean)this.allowPartialUpdates.get() != false, "setting a property mask on a mutation is not allowed", new Object[0]);
            PropertyMask mask = mutation.hasPropertyMask() ? this.toPropertyMask(mutation.getPropertyMask(), this.getValidationConstraint(mutation)) : PropertyMask.FULL;
            switch (mutation.getOperationCase()) {
                case INSERT: {
                    OnestoreEntity.EntityProto insertEntity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)mutation.getInsert());
                    internalMutations.add((Object)Mutation.insert(insertEntity).writePropertyMask(mask).baseVersion(baseVersion).conflictResolutionStrategy(resolutionStrategy).build());
                    continue block15;
                }
                case UPDATE: {
                    OnestoreEntity.EntityProto updateEntity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)mutation.getUpdate());
                    internalMutations.add((Object)Mutation.update(updateEntity).writePropertyMask(mask).baseVersion(baseVersion).conflictResolutionStrategy(resolutionStrategy).build());
                    continue block15;
                }
                case UPSERT: {
                    OnestoreEntity.EntityProto upsertEntity = EntityV3V1Converter.INSTANCE.toV3Entity(resolver, (EntityOrBuilder)mutation.getUpsert());
                    internalMutations.add((Object)Mutation.upsert(upsertEntity).writePropertyMask(mask).baseVersion(baseVersion).conflictResolutionStrategy(resolutionStrategy).build());
                    continue block15;
                }
                case DELETE: {
                    internalMutations.add((Object)Mutation.delete(EntityV3V1Converter.INSTANCE.toV3Reference(resolver, (KeyOrBuilder)mutation.getDelete())).baseVersion(baseVersion).conflictResolutionStrategy(resolutionStrategy).build());
                    continue block15;
                }
            }
            throw new InvalidConversionException("Mutation is missing operation.");
        }
        return internalMutations.build();
    }

    private ValidationConstraint getValidationConstraint(com.google.appengine.repackaged.com.google.datastore.v1.Mutation mutation) throws InvalidConversionException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return ValidationConstraint.INSERT;
            }
            case UPDATE: {
                return ValidationConstraint.UPDATE;
            }
            case UPSERT: {
                return ValidationConstraint.UPSERT;
            }
            case DELETE: {
                return ValidationConstraint.DELETE;
            }
        }
        throw new IllegalArgumentException("invalid mutation case");
    }
}

