/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.exception.ValidationException;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyMaskHelper;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.service.common.PropertyPathValidator;
import com.google.apphosting.datastore.service.common.ValidationConstraint;
import java.util.Collection;

public class PropertyPathToMaskConverter {
    private final PropertyPathValidator propertyPathValidator;

    public PropertyPathToMaskConverter(PropertyPathValidator propertyPathValidator) {
        this.propertyPathValidator = propertyPathValidator;
    }

    public PropertyMask validateAndConvertPathsToMask(Collection<PropertyPath> propertyPaths, ValidationConstraint constraint) throws InvalidConversionException {
        constraint = constraint.withContext(ValidationConstraint.Context.IN_PROPERTY_MASK);
        try {
            for (PropertyPath propertyPath : propertyPaths) {
                this.propertyPathValidator.validatePropertyPath(propertyPath, constraint);
            }
        }
        catch (ValidationException exception) {
            throw new InvalidConversionException(exception.getMessage(), exception);
        }
        return PropertyMaskHelper.convertPathsToMask(propertyPaths);
    }
}

