/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.datastore.exception.ValidationException;
import com.google.apphosting.datastore.rep.EntitySize;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.service.common.ValidationConstraint;
import com.google.apphosting.datastore.shared.Config;

public class PropertyPathValidator {
    private final Config.DatastoreConfig config;

    public PropertyPathValidator(Config.DatastoreConfig config) {
        this.config = (Config.DatastoreConfig)Preconditions.checkNotNull((Object)config);
    }

    public void validatePropertyPath(PropertyPath propertyPath, ValidationConstraint constraint) throws ValidationException {
        ValidationException.validateAssertion(propertyPath.next() == null || constraint.allowMultisegmentPath(), "only single segment property path allowed", new Object[0]);
        ValidationException.validateAssertion(EntitySize.propertyPathSize(propertyPath) <= this.config.getMaxIndexedValueBytes(), "property path is longer than %d bytes.", this.config.getMaxIndexedValueBytes());
        int segmentCount = 0;
        while (propertyPath != null) {
            PropertyPathSegment.Member memberSegment = (PropertyPathSegment.Member)propertyPath.segment();
            propertyPath = propertyPath.next();
            boolean firstSegment = ++segmentCount == 1;
            boolean lastSegment = propertyPath == null;
            this.validatePropertyNameInPath(memberSegment.name(), firstSegment, lastSegment, constraint);
        }
        ValidationException.validateAssertion(segmentCount <= this.config.getMaxEntityValueDepth(), "paths must have at most %d elements", this.config.getMaxEntityValueDepth());
    }

    public void validatePropertyNameInPath(PropertyName name, boolean firstSegment, boolean lastSegment, ValidationConstraint constraint) throws ValidationException {
        ValidationException.validateAssertion(!name.string().isEmpty(), "a property path segment cannot be empty", new Object[0]);
        if (RepHelper.isNameReserved(name.bytes())) {
            ValidationException.validateAssertion(constraint.allowReservedName(name, firstSegment, lastSegment), "the name %s is reserved", name.string());
        }
    }
}

