/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Interner;
import com.google.appengine.repackaged.com.google.common.collect.Interners;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.ReservedName;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ValidationConstraint {
    private static final Interner<ValidationConstraint> CONSTRAINT_INTERNER = Interners.newStrongInterner();
    public static final ValidationConstraint LOOKUP = ValidationConstraint.forOperation(Operation.LOOKUP);
    public static final ValidationConstraint INSERT = ValidationConstraint.forOperation(Operation.INSERT);
    public static final ValidationConstraint UPSERT = ValidationConstraint.forOperation(Operation.UPSERT);
    public static final ValidationConstraint UPDATE = ValidationConstraint.forOperation(Operation.UPDATE);
    public static final ValidationConstraint DELETE = ValidationConstraint.forOperation(Operation.DELETE);
    public static final ValidationConstraint QUERY = ValidationConstraint.forOperation(Operation.QUERY);
    public static final ValidationConstraint ALLOCATE_ID = ValidationConstraint.forOperation(Operation.ALLOCATE_ID);
    public static final ValidationConstraint ALLOCATE_ID_RANGE = ValidationConstraint.forOperation(Operation.ALLOCATE_ID_RANGE);
    public static final ValidationConstraint RESERVE_ID = ValidationConstraint.forOperation(Operation.RESERVE_ID);
    public static final ValidationConstraint CREATE_INDEX = ValidationConstraint.forOperation(Operation.CREATE_INDEX);
    private static final ImmutableSet<PropertyName> WHITELISTED_IN_INDEX_RESERVED_PROPERTY_NAMES = ImmutableSet.of((Object)ReservedName.KIND.asPropertyName(), (Object)ReservedName.SCATTER.asPropertyName(), (Object)ReservedName.NAME.asPropertyName(), (Object)ReservedName.WHITELISTED_ANCESTOR_1.asPropertyName(), (Object)ReservedName.WHITELISTED_ANCESTOR_2.asPropertyName(), (Object)ReservedName.WHITELISTED_ANCESTOR_3.asPropertyName(), (Object[])new PropertyName[]{ReservedName.WHITELISTED_CATEGORY.asPropertyName(), ReservedName.WHITELISTED_COURSE_KEY.asPropertyName(), ReservedName.WHITELISTED_CREATED_AT.asPropertyName(), ReservedName.WHITELISTED_CREATED.asPropertyName(), ReservedName.WHITELISTED_DATE.asPropertyName(), ReservedName.WHITELISTED_EMAIL.asPropertyName(), ReservedName.WHITELISTED_EMPTY_IN_LIST.asPropertyName(), ReservedName.WHITELISTED_ENCODED_KEY.asPropertyName(), ReservedName.WHITELISTED_ID_1.asPropertyName(), ReservedName.WHITELISTED_ID_2.asPropertyName(), ReservedName.WHITELISTED_KEY_1.asPropertyName(), ReservedName.WHITELISTED_KEY_2.asPropertyName(), ReservedName.WHITELISTED_KEY_3.asPropertyName(), ReservedName.WHITELISTED_KEY_4.asPropertyName(), ReservedName.WHITELISTED_KEY_5.asPropertyName(), ReservedName.WHITELISTED_KEY_NAME.asPropertyName(), ReservedName.WHITELISTED_KEYNAME.asPropertyName(), ReservedName.WHITELISTED_KEYNAMEASD.asPropertyName(), ReservedName.WHITELISTED_KDSFEY.asPropertyName(), ReservedName.WHITELISTED_LOGINID.asPropertyName(), ReservedName.WHITELISTED_MESSAGE.asPropertyName(), ReservedName.WHITELISTED_NOTHING.asPropertyName(), ReservedName.WHITELISTED_PARENT.asPropertyName(), ReservedName.WHITELISTED_RECORDSET.asPropertyName(), ReservedName.WHITELISTED_SEVERITY.asPropertyName(), ReservedName.WHITELISTED_USERID.asPropertyName()});
    private final Operation operation;
    private final EnumSet<Context> contexts;

    @VisibleForTesting
    static ImmutableSet<ValidationConstraint> getAllForTesting() {
        ImmutableSet.Builder all = ImmutableSet.builder();
        Set contexts = Sets.powerSet(EnumSet.allOf(Context.class));
        for (Operation op : Operation.values()) {
            for (Set context : contexts) {
                if (context.isEmpty()) {
                    all.add((Object)ValidationConstraint.create(op, EnumSet.noneOf(Context.class)));
                    continue;
                }
                all.add((Object)ValidationConstraint.create(op, EnumSet.copyOf(context)));
            }
        }
        return all.build();
    }

    private ValidationConstraint(Operation operation, EnumSet<Context> contexts) {
        this.operation = operation;
        this.contexts = contexts;
    }

    private static ValidationConstraint create(Operation operation, EnumSet<Context> contexts) {
        return (ValidationConstraint)CONSTRAINT_INTERNER.intern((Object)new ValidationConstraint(operation, contexts));
    }

    private static ValidationConstraint forOperation(Operation operation) {
        return ValidationConstraint.create(operation, EnumSet.noneOf(Context.class));
    }

    public ValidationConstraint withContext(Context ... context) {
        List<Context> contextList = Arrays.asList(context);
        if (this.contexts.containsAll(contextList)) {
            return this;
        }
        EnumSet<Context> newContexts = EnumSet.copyOf(this.contexts);
        newContexts.addAll(contextList);
        return ValidationConstraint.create(this.operation, newContexts);
    }

    public ValidationConstraint withContext(boolean isTrusted, Context ... context) {
        if (isTrusted) {
            if (!this.contexts.contains((Object)Context.TRUSTED)) {
                return this.withContext(Context.TRUSTED).withContext(context);
            }
        } else {
            Preconditions.checkState((!this.contexts.contains((Object)Context.TRUSTED) ? 1 : 0) != 0);
        }
        return this.withContext(context);
    }

    @VisibleForTesting
    public boolean hasContext(Context context) {
        return this.contexts.contains((Object)context);
    }

    public boolean allowMissingKey() {
        return this.contexts.contains((Object)Context.IN_ENTITY_VALUE);
    }

    public boolean allowCompleteKey() {
        if (this.contexts.contains((Object)Context.IN_ENTITY_VALUE) || this.contexts.contains((Object)Context.IN_KEY_VALUE)) {
            return true;
        }
        return this.operation != Operation.ALLOCATE_ID;
    }

    public boolean allowIncompleteKey(boolean getAllowIncompleteKeyPathsInQueryFilters) {
        if (this.contexts.contains((Object)Context.IN_FILTER_ON_ENTITY_VALUE_KEY)) {
            return getAllowIncompleteKeyPathsInQueryFilters;
        }
        if (this.contexts.contains((Object)Context.IN_KEY_VALUE)) {
            return false;
        }
        if (this.contexts.contains((Object)Context.IN_ENTITY_VALUE)) {
            return true;
        }
        switch (this.operation) {
            case INSERT: 
            case UPSERT: 
            case QUERY: 
            case ALLOCATE_ID: 
            case ALLOCATE_ID_RANGE: {
                return true;
            }
        }
        return false;
    }

    public boolean allowPartitionMissingProjectId() {
        return this.contexts.contains((Object)Context.PRENORMALIZATION);
    }

    public boolean allowMissingPartionId() {
        return this.contexts.contains((Object)Context.PRENORMALIZATION);
    }

    public boolean allowReservedKey() {
        return this.contexts.contains((Object)Context.IN_KEY_VALUE) || this.contexts.contains((Object)Context.IN_ENTITY_VALUE) || this.operation.equals((Object)Operation.CREATE_INDEX) || this.allowReservedName();
    }

    public boolean allowReservedName() {
        switch (this.operation) {
            case QUERY: 
            case LOOKUP: {
                return !this.contexts.contains((Object)Context.FIRESTORE);
            }
        }
        return this.contexts.contains((Object)Context.TRUSTED);
    }

    public boolean allowMultisegmentPath() {
        return this.contexts.contains((Object)Context.FIRESTORE) || this.contexts.contains((Object)Context.IN_PROPERTY_MASK) || this.contexts.contains((Object)Context.IN_TRANSFORM);
    }

    public boolean allowReservedName(PropertyName name, boolean firstSegment, boolean lastSegment) {
        if (name.special() == SpecialPropertyDescriptor.KEY) {
            if (!lastSegment) {
                return false;
            }
            if (this.contexts.contains((Object)Context.IN_PROPERTY_MASK)) {
                return true;
            }
            switch (this.operation) {
                case QUERY: 
                case LOOKUP: 
                case CREATE_INDEX: {
                    return !this.contexts.contains((Object)Context.FIRESTORE) || firstSegment;
                }
            }
            return !this.contexts.contains((Object)Context.FIRESTORE) && this.contexts.contains((Object)Context.TRUSTED);
        }
        if (this.contexts.contains((Object)Context.FIRESTORE)) {
            switch (this.operation) {
                case QUERY: 
                case LOOKUP: 
                case CREATE_INDEX: {
                    return name.equals(ReservedName.TYPE.asPropertyName()) && !firstSegment && lastSegment && !this.contexts.contains((Object)Context.IN_PROPERTY_MASK);
                }
            }
            return false;
        }
        if (this.operation == Operation.CREATE_INDEX) {
            return lastSegment && firstSegment && WHITELISTED_IN_INDEX_RESERVED_PROPERTY_NAMES.contains((Object)name);
        }
        return this.allowReservedName();
    }

    public boolean allowIndexOnlyMeaning() {
        return this.operation == Operation.LOOKUP || this.operation == Operation.QUERY;
    }

    public boolean allowCompoundValues() {
        return this.operation != Operation.QUERY;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValidationConstraint)) {
            return false;
        }
        ValidationConstraint otherConstraint = (ValidationConstraint)other;
        return this.operation == otherConstraint.operation && this.contexts.equals(otherConstraint.contexts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.contexts});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operation", (Object)this.operation).add("contexts", this.contexts).toString();
    }

    private static enum Operation {
        LOOKUP,
        INSERT,
        UPSERT,
        UPDATE,
        DELETE,
        QUERY,
        ALLOCATE_ID,
        ALLOCATE_ID_RANGE,
        RESERVE_ID,
        CREATE_INDEX;

    }

    public static enum Context {
        IN_KEY_VALUE,
        IN_ENTITY_VALUE,
        TRUSTED,
        PRENORMALIZATION,
        IN_FILTER_ON_ENTITY_VALUE_KEY,
        IN_PROPERTY_MASK,
        IN_TRANSFORM,
        FIRESTORE;

    }
}

