/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.apphosting.datastore.rep.AutoValue_DatastoreValue;
import com.google.auto.value.AutoValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class DatastoreValue {
    public static boolean fixDoubleIndexEntries = false;

    public static DatastoreValue create(OnestoreEntity.PropertyValue value) {
        if (fixDoubleIndexEntries) {
            if (value.hasDoubleValue()) {
                return new AutoValue_DatastoreValue(null, Double.doubleToLongBits(value.getDoubleValue()), null);
            }
            if (value.hasPointValue()) {
                return new AutoValue_DatastoreValue(null, Double.doubleToLongBits(value.getPointValue().getX()), Double.doubleToLongBits(value.getPointValue().getY()));
            }
        }
        return new AutoValue_DatastoreValue(value, null, null);
    }

    public OnestoreEntity.PropertyValue v3Value() {
        if (this.pointYBits() != null) {
            OnestoreEntity.PropertyValue point = new OnestoreEntity.PropertyValue();
            point.getMutablePointValue().setX(Double.longBitsToDouble(this.doubleBits())).setY(Double.longBitsToDouble(this.pointYBits()));
            return point;
        }
        if (this.doubleBits() != null) {
            return new OnestoreEntity.PropertyValue().setDoubleValue(Double.longBitsToDouble(this.doubleBits()));
        }
        return this.internalValue();
    }

    @Deprecated
    @Nullable
    abstract OnestoreEntity.PropertyValue internalValue();

    @Nullable
    @Deprecated
    abstract Long doubleBits();

    @Nullable
    @Deprecated
    abstract Long pointYBits();
}

