/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.apphosting.datastore.rep.PropertyMask;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.PropertyPath;
import com.google.apphosting.datastore.rep.PropertyPathSegment;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyMaskHelper {
    public static PropertyMask convertPathsToMask(Collection<PropertyPath> propertyPaths) {
        boolean includeKeyPath = false;
        HashMap<PropertyName, PropertyMask> nestedMasks = new HashMap<PropertyName, PropertyMask>();
        ArrayListMultimap nestedPaths = ArrayListMultimap.create();
        for (PropertyPath propertyPath : propertyPaths) {
            boolean isEndOfPath;
            PropertyPathSegment segment = propertyPath.segment();
            Preconditions.checkArgument((boolean)(segment instanceof PropertyPathSegment.Member), (Object)"Property mask paths currently support only \".\".");
            PropertyName propertyName = ((PropertyPathSegment.Member)segment).name();
            PropertyPath propertyPathNext = propertyPath.next();
            boolean bl = isEndOfPath = propertyPathNext == null;
            if (propertyName.special() == SpecialPropertyDescriptor.KEY) {
                includeKeyPath = true;
                continue;
            }
            if (isEndOfPath) {
                nestedMasks.put(propertyName, PropertyMask.FULL);
                nestedPaths.removeAll((Object)propertyName);
                continue;
            }
            if (nestedMasks.containsKey(propertyName)) continue;
            nestedPaths.put((Object)propertyName, (Object)propertyPathNext);
        }
        for (Map.Entry entry : nestedPaths.asMap().entrySet()) {
            PropertyName propertyName = (PropertyName)entry.getKey();
            Collection subPropertyPaths = (Collection)entry.getValue();
            nestedMasks.put(propertyName, PropertyMaskHelper.convertPathsToMask(subPropertyPaths));
        }
        return new PropertyMask(includeKeyPath, nestedMasks);
    }
}

