/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.apphosting.datastore.rep.AutoValue_PropertyPathSegment_Index;
import com.google.apphosting.datastore.rep.AutoValue_PropertyPathSegment_Member;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.apphosting.datastore.rep.Value;
import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;

public abstract class PropertyPathSegment
implements Comparable<PropertyPathSegment> {
    @Nullable
    Value getFrom(ImmutableList<Value> array) {
        return null;
    }

    @Nullable
    Value getFrom(ImmutableMap<String, Value> map) {
        return null;
    }

    public SpecialPropertyDescriptor special() {
        return null;
    }

    abstract void appendAsString(boolean var1, StringBuilder var2);

    @Override
    public int compareTo(PropertyPathSegment other) {
        int classOrderDiff = this.classOrder().ordinal() - other.classOrder().ordinal();
        if (classOrderDiff < 0) {
            return -1;
        }
        if (classOrderDiff > 0) {
            return 1;
        }
        return this.compareToSameClass(other);
    }

    protected abstract ClassOrder classOrder();

    protected abstract int compareToSameClass(PropertyPathSegment var1);

    @AutoValue
    public static abstract class Index
    extends PropertyPathSegment {
        public static Index create(int index) {
            return new AutoValue_PropertyPathSegment_Index(index);
        }

        public abstract int index();

        @Override
        @Nullable
        Value getFrom(ImmutableList<Value> array) {
            if (this.index() >= array.size()) {
                return null;
            }
            return (Value)array.get(this.index());
        }

        @Override
        protected ClassOrder classOrder() {
            return ClassOrder.INDEX;
        }

        @Override
        protected int compareToSameClass(PropertyPathSegment otherSameClassSegment) {
            Index other = (Index)otherSameClassSegment;
            return Integer.compare(this.index(), other.index());
        }

        @Override
        void appendAsString(boolean isFirst, StringBuilder stringBuilder) {
            stringBuilder.append('[');
            stringBuilder.append(this.index());
            stringBuilder.append(']');
        }
    }

    @AutoValue
    public static abstract class Member
    extends PropertyPathSegment {
        public static Member create(PropertyName propertyName) {
            return new AutoValue_PropertyPathSegment_Member(propertyName);
        }

        public abstract PropertyName name();

        @Override
        @Nullable
        Value getFrom(ImmutableMap<String, Value> map) {
            return (Value)map.get((Object)this.name().string());
        }

        @Override
        public SpecialPropertyDescriptor special() {
            return this.name().special();
        }

        @Override
        protected ClassOrder classOrder() {
            return ClassOrder.MEMBER;
        }

        @Override
        protected int compareToSameClass(PropertyPathSegment otherSameClassSegment) {
            Member otherMemberSegment = (Member)otherSameClassSegment;
            return this.name().compareTo(otherMemberSegment.name());
        }

        @Override
        void appendAsString(boolean isFirst, StringBuilder stringBuilder) {
            if (!isFirst) {
                stringBuilder.append('.');
            }
            stringBuilder.append(this.name().string());
        }
    }

    private static enum ClassOrder {
        NONE,
        INDEX,
        MEMBER;

    }
}

