/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.datastore.rep.AutoValue_UnifiedIndexValue;
import com.google.apphosting.datastore.rep.DatastoreValue;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.internal.IndexValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import javax.annotation.Nullable;

@AutoValue
public abstract class UnifiedIndexValue {
    public IndexValue firestoreIndexValue() {
        Preconditions.checkState((boolean)this.isFirestore());
        return this.internalFirestoreIndexValue();
    }

    public OnestoreEntity.PropertyValue datastoreIndexValue() {
        Preconditions.checkState((boolean)this.isDatastore());
        return this.internalDatastoreIndexValue().v3Value();
    }

    public String getString() {
        if (this.isDatastore()) {
            return this.datastoreIndexValue().getStringValue();
        }
        Preconditions.checkState((boolean)this.isFirestore());
        return this.firestoreIndexValue().getStringValue().getValue();
    }

    @Nullable
    protected abstract IndexValue internalFirestoreIndexValue();

    @Nullable
    protected abstract DatastoreValue internalDatastoreIndexValue();

    public static UnifiedIndexValue create(IndexValue firestoreIndexValue) {
        return new AutoValue_UnifiedIndexValue(firestoreIndexValue, null);
    }

    public static UnifiedIndexValue create(OnestoreEntity.PropertyValue datastoreIndexValue) {
        return new AutoValue_UnifiedIndexValue(null, DatastoreValue.create(datastoreIndexValue));
    }

    public boolean isDatastore() {
        return this.internalDatastoreIndexValue() != null;
    }

    public boolean isFirestore() {
        return this.internalFirestoreIndexValue() != null;
    }
}

