/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.util.Timestamps;
import com.google.apphosting.datastore.exception.InvalidConversionException;

public abstract class ConverterHelper {
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    private static final int NANOSECONDS_PER_MICROSECOND = 1000;

    public static Timestamp microsecondsToTimestamp(long microseconds) throws InvalidConversionException {
        long seconds = microseconds / 1000000L;
        int microsecondsRemainder = (int)(microseconds % 1000000L);
        if (microsecondsRemainder < 0) {
            microsecondsRemainder += 1000000;
            --seconds;
        }
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(seconds).setNanos(microsecondsRemainder * 1000).build();
        try {
            Timestamps.checkValid((Timestamp)timestamp);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidConversionException(exception);
        }
        return timestamp;
    }

    public static long timestampToMicrosecondsLossy(Timestamp timestamp) {
        long nanoseconds = timestamp.getNanos();
        return timestamp.getSeconds() * 1000000L + nanoseconds / 1000L;
    }

    public static long timestampsToMicroseconds(Timestamp timestamp) throws InvalidConversionException {
        InvalidConversionException.checkConversion(timestamp.getNanos() % 1000 == 0, "timestamp cannot have more than microseconds precision", new Object[0]);
        return ConverterHelper.timestampToMicrosecondsLossy(timestamp);
    }
}

