/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.rpc.Code;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.datastore.exception.DatastoreException;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.net.rpc3.RpcStatusFactory;
import com.google.net.util.Status;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public final class DatastoreHelper
extends RepHelper {
    public static final ProjectIdResolver PROJECT_ID_RESOLVER = new ProjectIdResolver();
    public static final Function<OnestoreEntity.EntityProto, OnestoreEntity.Reference> ENTITY_TO_REFERENCE = new Function<OnestoreEntity.EntityProto, OnestoreEntity.Reference>(){

        public OnestoreEntity.Reference apply(OnestoreEntity.EntityProto entity) {
            return entity.getKey();
        }
    };
    public static final String NONE_KIND_NAME = "__none__";
    public static final String BLOBINFO_KIND_NAME = "__BlobInfo__";
    public static final String KIND_KIND_NAME = "__kind__";
    public static final String PROPERTY_KIND_NAME = "__property__";
    public static final String NAMESPACE_KIND_NAME = "__namespace__";
    public static final String COLLECTION_KIND_NAME = "__collection__";
    public static final String DOCUMENT_KIND_NAME = "__document__";
    public static final String DOCUMENT_KIND_DOCUMENT_KEY_PROPERTY_NAME_STRING = "document_key";
    public static final String DOCUMENT_KIND_DOCUMENT_PROPERTY_NAME_STRING = "document";
    public static final String DOCUMENT_KIND_CREATED_VERSION_PROPERTY_NAME_STRING = "created";
    public static final String DOCUMENT_KIND_UPDATED_VERSION_PROPERTY_NAME_STRING = "updated";
    public static final PropertyName DOCUMENT_KIND_DOCUMENT_KEY_PROPERTY_NAME = PropertyName.fromUtf8("document_key");
    public static final PropertyName DOCUMENT_KIND_DOCUMENT_PROPERTY_NAME = PropertyName.fromUtf8("document");
    public static final PropertyName DOCUMENT_KIND_CREATED_VERSION_PROPERTY_NAME = PropertyName.fromUtf8("created");
    public static final PropertyName DOCUMENT_KIND_UPDATED_VERSION_PROPERTY_NAME = PropertyName.fromUtf8("updated");
    public static final String ALL_NAMESPACES = "__all__";
    public static final ImmutableSet<String> GLOBAL_STATS_KIND_NAMES = ImmutableSet.of((Object)"__Stat_Total__", (Object)"__Stat_Namespace__", (Object)"__Stat_Kind_CompositeIndex__", (Object)"__Stat_Kind__", (Object)"__Stat_Kind_IsRootEntity__", (Object)"__Stat_Kind_NotRootEntity__", (Object[])new String[]{"__Stat_PropertyType__", "__Stat_PropertyType_Kind__", "__Stat_PropertyName_Kind__", "__Stat_PropertyType_PropertyName_Kind__"});
    public static final ImmutableSet<String> NAMESPACE_STATS_KIND_NAMES = ImmutableSet.of((Object)"__Stat_Ns_Total__", (Object)"__Stat_Ns_Kind_CompositeIndex__", (Object)"__Stat_Ns_Kind__", (Object)"__Stat_Ns_Kind_IsRootEntity__", (Object)"__Stat_Ns_Kind_NotRootEntity__", (Object)"__Stat_Ns_PropertyType__", (Object[])new String[]{"__Stat_Ns_PropertyType_Kind__", "__Stat_Ns_PropertyName_Kind__", "__Stat_Ns_PropertyType_PropertyName_Kind__"});
    public static final int MAX_QUERY_COMPONENTS = 100;
    @VisibleForTesting
    public static final ImmutableMap<Integer, Codes.Code> CANONICAL_ERROR_MAPPING = ImmutableMap.builder().put((Object)DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), (Object)Codes.Code.INVALID_ARGUMENT).put((Object)DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), (Object)Codes.Code.ABORTED).put((Object)DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), (Object)Codes.Code.INTERNAL).put((Object)DatastorePb.Error.ErrorCode.NEED_INDEX.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)DatastorePb.Error.ErrorCode.TIMEOUT.getValue(), (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)DatastorePb.Error.ErrorCode.PERMISSION_DENIED.getValue(), (Object)Codes.Code.PERMISSION_DENIED).put((Object)DatastorePb.Error.ErrorCode.BIGTABLE_ERROR.getValue(), (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)DatastorePb.Error.ErrorCode.COMMITTED_BUT_STILL_APPLYING.getValue(), (Object)Codes.Code.INTERNAL).put((Object)DatastorePb.Error.ErrorCode.CAPABILITY_DISABLED.getValue(), (Object)Codes.Code.UNAVAILABLE).put((Object)DatastorePb.Error.ErrorCode.TRY_ALTERNATE_BACKEND.getValue(), (Object)Codes.Code.UNAVAILABLE).put((Object)DatastorePb.Error.ErrorCode.SAFE_TIME_TOO_OLD.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)DatastorePb.Error.ErrorCode.RESOURCE_EXHAUSTED.getValue(), (Object)Codes.Code.RESOURCE_EXHAUSTED).put((Object)DatastorePb.Error.ErrorCode.NOT_FOUND.getValue(), (Object)Codes.Code.NOT_FOUND).put((Object)DatastorePb.Error.ErrorCode.ALREADY_EXISTS.getValue(), (Object)Codes.Code.ALREADY_EXISTS).put((Object)DatastorePb.Error.ErrorCode.FAILED_PRECONDITION.getValue(), (Object)Codes.Code.FAILED_PRECONDITION).put((Object)DatastorePb.Error.ErrorCode.UNAUTHENTICATED.getValue(), (Object)Codes.Code.UNAUTHENTICATED).put((Object)DatastorePb.Error.ErrorCode.ABORTED.getValue(), (Object)Codes.Code.ABORTED).put((Object)90000, (Object)Codes.Code.DEADLINE_EXCEEDED).put((Object)90001, (Object)Codes.Code.INTERNAL).put((Object)90002, (Object)Codes.Code.INTERNAL).build();

    private DatastoreHelper() {
    }

    public static String appToProjectId(String appId) {
        DatabaseRef parsed = DatabaseRef.createForApp(appId, "");
        return parsed.projectId();
    }

    public static String getCluster(String appId) {
        Matcher patternMatch = APP_ID_REGEX.matcher(appId);
        if (patternMatch.matches()) {
            return (String)MoreObjects.firstNonNull((Object)patternMatch.group("cluster"), (Object)"");
        }
        return "";
    }

    public static Codes.Code getCanonicalCodeForAppError(@Nullable DatastorePb.Error.ErrorCode appCode) {
        if (appCode == null) {
            return Codes.Code.UNKNOWN;
        }
        return DatastoreHelper.getCanonicalCodeForAppError(appCode.getValue());
    }

    public static Codes.Code getCanonicalCodeForAppError(int appCode) {
        Codes.Code code = (Codes.Code)CANONICAL_ERROR_MAPPING.get((Object)appCode);
        if (code != null) {
            return code;
        }
        return Codes.Code.UNKNOWN;
    }

    public static Code getGoogleRpcCanonicalCodeForAppError(int appCode) {
        return Code.forNumber((int)DatastoreHelper.getCanonicalCodeForAppError(appCode).getNumber());
    }

    public static boolean isEntityValue(OnestoreEntity.Property property) {
        return property.getMeaningEnum().equals((Object)OnestoreEntity.Property.Meaning.ENTITY_PROTO);
    }

    public static Status statusFromException(DatastoreException datastoreException) {
        return RpcStatusFactory.createApplicationError((int)datastoreException.getErrorCode().getValue(), (String)datastoreException.getMessage()).withCanonicalCode(DatastoreHelper.getCanonicalCodeForAppError(datastoreException.getErrorCode()));
    }

    public static class ProjectIdResolver
    implements ProjectIdAppIdResolver {
        @Override
        public String toAppId(String projectId) throws InvalidConversionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public final String toProjectId(String appId) {
            return DatastoreHelper.appToProjectId(appId);
        }
    }
}

