/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.util.v1;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;

public class V1Paths {
    public static Key.PathElement lastElement(KeyOrBuilder key) {
        Preconditions.checkArgument((key.getPathCount() >= 1 ? 1 : 0) != 0, (Object)"empty path");
        return key.getPath(key.getPathCount() - 1);
    }

    public static boolean hasIncompleteLastElement(KeyOrBuilder key) {
        if (key.getPathCount() == 0) {
            return false;
        }
        return V1Paths.lastElement(key).getIdTypeCase() == Key.PathElement.IdTypeCase.IDTYPE_NOT_SET;
    }

    public static String toPathString(KeyOrBuilder key) {
        if (key.getPathCount() == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Key.PathElement element : key.getPathList()) {
            String kind = element.getKind();
            stringBuilder.append(kind);
            stringBuilder.append(": ");
            switch (element.getIdTypeCase()) {
                case ID: {
                    stringBuilder.append(element.getId());
                    break;
                }
                case NAME: {
                    stringBuilder.append(element.getName());
                    break;
                }
                case IDTYPE_NOT_SET: {
                    break;
                }
                default: {
                    String string = String.valueOf(element.getIdTypeCase());
                    throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(string).length()).append("Unrecognized id_type: ").append(string).toString());
                }
            }
            stringBuilder.append(", ");
        }
        int stringBuilderLength = stringBuilder.length();
        stringBuilder.delete(stringBuilderLength - 2, stringBuilderLength);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

