/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedBytes;
import com.google.apphosting.datastore.rep.AutoValue_PropertyName_ByteArrayWrapper;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.rep.SpecialPropertyDescriptor;
import com.google.auto.value.AutoValue;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.annotation.Nullable;

public class PropertyName
implements Comparable<PropertyName> {
    private static final Comparator<byte[]> UTF8_BYTE_COMPARATOR = UnsignedBytes.lexicographicalComparator();
    private static final ImmutableMap<ByteArrayWrapper, SpecialPropertyName> NAME_TO_SPECIAL_PROPERTY_NAME_MAP = PropertyName.makeNameToSpecialPropertyNameMap();
    public static final PropertyName KEY = PropertyName.specialLookup(SpecialPropertyDescriptor.KEY.getPropertyNameAsByteArray());
    private final byte[] nameAsByteArray;
    private final String name;

    private static ImmutableMap<ByteArrayWrapper, SpecialPropertyName> makeNameToSpecialPropertyNameMap() {
        HashMap<ByteArrayWrapper, SpecialPropertyName> map = new HashMap<ByteArrayWrapper, SpecialPropertyName>();
        for (SpecialPropertyDescriptor descriptor : SpecialPropertyDescriptor.values()) {
            SpecialPropertyName previousName = map.put(ByteArrayWrapper.create(descriptor.getPropertyNameAsByteArray()), new SpecialPropertyName(descriptor));
            Preconditions.checkState((previousName == null ? 1 : 0) != 0, (Object)"duplicate special property name");
        }
        return ImmutableMap.copyOf(map);
    }

    public static PropertyName from(OnestoreEntity.Property property) {
        return PropertyName.create(property.getNameAsBytes(), property.getName());
    }

    public static PropertyName from(OnestoreEntity.Index.Property indexProperty) {
        return PropertyName.create(indexProperty.getNameAsBytes(), indexProperty.getName());
    }

    public static PropertyName fromUtf8(String name) {
        return PropertyName.create(name.getBytes(StandardCharsets.UTF_8), name);
    }

    public static PropertyName from(byte[] nameAsByteArray) {
        return PropertyName.create(nameAsByteArray, new String(nameAsByteArray, StandardCharsets.UTF_8));
    }

    static PropertyName fromByteArrayAndUtf8(byte[] nameAsByteArray, String name) {
        return PropertyName.create(nameAsByteArray, name);
    }

    private static PropertyName create(byte[] nameAsByteArray, String name) {
        PropertyName specialPropertyName = PropertyName.specialLookup(nameAsByteArray);
        if (specialPropertyName != null) {
            return specialPropertyName;
        }
        return new PropertyName(nameAsByteArray, name);
    }

    @Nullable
    public static PropertyName specialLookup(byte[] nameAsByteArray) {
        if (!RepHelper.isNameReserved(nameAsByteArray)) {
            return null;
        }
        SpecialPropertyName specialPropertyName = (SpecialPropertyName)NAME_TO_SPECIAL_PROPERTY_NAME_MAP.get((Object)ByteArrayWrapper.create(nameAsByteArray));
        if (specialPropertyName == null) {
            return null;
        }
        return specialPropertyName;
    }

    protected PropertyName(byte[] nameAsByteArray, String name) {
        this.nameAsByteArray = nameAsByteArray;
        this.name = name;
    }

    public byte[] bytes() {
        return this.nameAsByteArray;
    }

    public String string() {
        return this.name;
    }

    @Nullable
    public SpecialPropertyDescriptor special() {
        return null;
    }

    public boolean isReserved() {
        return RepHelper.isNameReserved(this.bytes());
    }

    public boolean same(byte[] otherNameAsByteArray) {
        return Arrays.equals(this.nameAsByteArray, otherNameAsByteArray);
    }

    @Override
    public int compareTo(PropertyName other) {
        return UTF8_BYTE_COMPARATOR.compare(this.nameAsByteArray, other.nameAsByteArray);
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PropertyName)) {
            return false;
        }
        PropertyName other = (PropertyName)otherObject;
        return Arrays.equals(this.nameAsByteArray, other.nameAsByteArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.nameAsByteArray);
    }

    public String toString() {
        return this.string();
    }

    @AutoValue
    public static abstract class ByteArrayWrapper {
        public static ByteArrayWrapper create(byte[] bytes) {
            return new AutoValue_PropertyName_ByteArrayWrapper(bytes);
        }

        public abstract byte[] bytes();
    }

    private static class SpecialPropertyName
    extends PropertyName {
        private final SpecialPropertyDescriptor descriptor;

        public SpecialPropertyName(SpecialPropertyDescriptor descriptor) {
            super(descriptor.getPropertyNameAsByteArray(), descriptor.getPropertyName());
            this.descriptor = descriptor;
        }

        @Override
        public SpecialPropertyDescriptor special() {
            return this.descriptor;
        }
    }
}

