/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.service.common;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.apphosting.datastore.exception.InvalidConversionException;
import com.google.apphosting.datastore.rep.DatabaseRef;
import com.google.apphosting.datastore.rep.PropertyName;
import com.google.apphosting.datastore.rep.RepHelper;
import com.google.apphosting.datastore.service.common.ProjectIdAppIdResolver;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.regex.Matcher;

public final class DatastoreHelper
extends RepHelper {
    public static final ProjectIdResolver PROJECT_ID_RESOLVER = new ProjectIdResolver();
    public static final Function<OnestoreEntity.EntityProto, OnestoreEntity.Reference> ENTITY_TO_REFERENCE = new Function<OnestoreEntity.EntityProto, OnestoreEntity.Reference>(){

        public OnestoreEntity.Reference apply(OnestoreEntity.EntityProto entity) {
            return entity.getKey();
        }
    };
    public static final String NONE_KIND_NAME = "__none__";
    public static final String BLOBINFO_KIND_NAME = "__BlobInfo__";
    public static final String KIND_KIND_NAME = "__kind__";
    public static final String PROPERTY_KIND_NAME = "__property__";
    public static final String NAMESPACE_KIND_NAME = "__namespace__";
    public static final String COLLECTION_KIND_NAME = "__collection__";
    public static final String DOCUMENT_KIND_NAME = "__document__";
    public static final String DOCUMENT_KIND_DOCUMENT_KEY_PROPERTY_NAME_STRING = "document_key";
    public static final String DOCUMENT_KIND_DOCUMENT_PROPERTY_NAME_STRING = "document";
    public static final String DOCUMENT_KIND_CREATED_VERSION_PROPERTY_NAME_STRING = "created";
    public static final String DOCUMENT_KIND_UPDATED_VERSION_PROPERTY_NAME_STRING = "updated";
    public static final PropertyName DOCUMENT_KIND_DOCUMENT_KEY_PROPERTY_NAME = PropertyName.fromUtf8("document_key");
    public static final PropertyName DOCUMENT_KIND_DOCUMENT_PROPERTY_NAME = PropertyName.fromUtf8("document");
    public static final PropertyName DOCUMENT_KIND_CREATED_VERSION_PROPERTY_NAME = PropertyName.fromUtf8("created");
    public static final PropertyName DOCUMENT_KIND_UPDATED_VERSION_PROPERTY_NAME = PropertyName.fromUtf8("updated");
    public static final String ALL_NAMESPACES = "__all__";
    public static final ImmutableSet<String> GLOBAL_STATS_KIND_NAMES = ImmutableSet.of((Object)"__Stat_Total__", (Object)"__Stat_Namespace__", (Object)"__Stat_Kind_CompositeIndex__", (Object)"__Stat_Kind__", (Object)"__Stat_Kind_IsRootEntity__", (Object)"__Stat_Kind_NotRootEntity__", (Object[])new String[]{"__Stat_PropertyType__", "__Stat_PropertyType_Kind__", "__Stat_PropertyName_Kind__", "__Stat_PropertyType_PropertyName_Kind__"});
    public static final ImmutableSet<String> NAMESPACE_STATS_KIND_NAMES = ImmutableSet.of((Object)"__Stat_Ns_Total__", (Object)"__Stat_Ns_Kind_CompositeIndex__", (Object)"__Stat_Ns_Kind__", (Object)"__Stat_Ns_Kind_IsRootEntity__", (Object)"__Stat_Ns_Kind_NotRootEntity__", (Object)"__Stat_Ns_PropertyType__", (Object[])new String[]{"__Stat_Ns_PropertyType_Kind__", "__Stat_Ns_PropertyName_Kind__", "__Stat_Ns_PropertyType_PropertyName_Kind__"});
    public static final int MAX_QUERY_COMPONENTS = 100;

    private DatastoreHelper() {
    }

    public static String appToProjectId(String appId) {
        DatabaseRef parsed = DatabaseRef.createForApp(appId, "");
        return parsed.projectId();
    }

    public static String getCluster(String appId) {
        Matcher patternMatch = APP_ID_REGEX.matcher(appId);
        if (patternMatch.matches()) {
            return (String)MoreObjects.firstNonNull((Object)patternMatch.group("cluster"), (Object)"");
        }
        return "";
    }

    public static boolean isEntityValue(OnestoreEntity.Property property) {
        return property.getMeaningEnum().equals((Object)OnestoreEntity.Property.Meaning.ENTITY_PROTO);
    }

    public static class ProjectIdResolver
    implements ProjectIdAppIdResolver {
        @Override
        public String toAppId(String projectId) throws InvalidConversionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public final String toProjectId(String appId) {
            return DatastoreHelper.appToProjectId(appId);
        }
    }
}

