/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;

@GwtCompatible(serializable=true)
public strictfp final class S2Cap
implements S2Region,
Serializable {
    private static final double ROUND_UP = 1.0000000000000002;
    private final S2Point axis;
    private final double height;

    private S2Cap() {
        this.axis = new S2Point();
        this.height = 0.0;
    }

    private S2Cap(S2Point axis, double height) {
        this.axis = axis;
        this.height = height;
    }

    public static S2Cap fromAxisHeight(S2Point axis, double height) {
        return new S2Cap(axis, height);
    }

    public static S2Cap fromAxisAngle(S2Point axis, S1Angle angle) {
        double d = Math.sin(0.5 * angle.radians());
        return new S2Cap(axis, 2.0 * d * d);
    }

    public static S2Cap fromAxisArea(S2Point axis, double area) {
        return new S2Cap(axis, area / (Math.PI * 2));
    }

    public static S2Cap empty() {
        return new S2Cap(S2Point.X_POS, -1.0);
    }

    public static S2Cap full() {
        return new S2Cap(S2Point.X_POS, 2.0);
    }

    public S2Point axis() {
        return this.axis;
    }

    public double height() {
        return this.height;
    }

    public double area() {
        return Math.PI * 2 * Math.max(0.0, this.height);
    }

    public S1Angle angle() {
        if (this.isEmpty()) {
            return S1Angle.radians(-1.0);
        }
        return S1Angle.radians(2.0 * Math.asin(Math.sqrt(0.5 * this.height)));
    }

    public boolean isValid() {
        return S2.isUnitLength(this.axis) && this.height <= 2.0;
    }

    public boolean isEmpty() {
        return this.height < 0.0;
    }

    public boolean isFull() {
        return this.height >= 2.0;
    }

    @CheckReturnValue
    public S2Cap complement() {
        double cHeight = this.isFull() ? -1.0 : 2.0 - Math.max(this.height, 0.0);
        return S2Cap.fromAxisHeight(S2Point.neg(this.axis), cHeight);
    }

    public boolean contains(S2Cap other) {
        if (this.isFull() || other.isEmpty()) {
            return true;
        }
        return this.angle().radians() >= this.axis.angle(other.axis) + other.angle().radians();
    }

    public boolean interiorIntersects(S2Cap other) {
        return !this.complement().contains(other);
    }

    public boolean interiorContains(S2Point p) {
        return this.isFull() || S2Point.sub(this.axis, p).norm2() < 2.0 * this.height;
    }

    @CheckReturnValue
    public S2Cap addPoint(S2Point p) {
        if (this.isEmpty()) {
            return new S2Cap(p, 0.0);
        }
        double dist2 = S2Point.sub(this.axis, p).norm2();
        double newHeight = Math.max(this.height, 0.5000000000000001 * dist2);
        return new S2Cap(this.axis, newHeight);
    }

    @CheckReturnValue
    public S2Cap addCap(S2Cap other) {
        if (this.isEmpty()) {
            return new S2Cap(other.axis, other.height);
        }
        double angle = this.axis.angle(other.axis) + other.angle().radians();
        if (angle >= Math.PI) {
            return new S2Cap(this.axis, 2.0);
        }
        double d = Math.sin(0.5 * angle);
        double newHeight = Math.max(this.height, 2.0000000000000004 * d * d);
        return new S2Cap(this.axis, newHeight);
    }

    @Override
    public S2Cap getCapBound() {
        return this;
    }

    @Override
    public S2LatLngRect getRectBound() {
        double sinC;
        double sinA;
        if (this.isEmpty()) {
            return S2LatLngRect.empty();
        }
        S2LatLng axisLatLng = new S2LatLng(this.axis);
        double capAngle = this.angle().radians();
        boolean allLongitudes = false;
        double[] lat = new double[2];
        double[] lng = new double[]{-Math.PI, Math.PI};
        lat[0] = axisLatLng.lat().radians() - capAngle;
        if (lat[0] <= -1.5707963267948966) {
            lat[0] = -1.5707963267948966;
            allLongitudes = true;
        }
        lat[1] = axisLatLng.lat().radians() + capAngle;
        if (lat[1] >= 1.5707963267948966) {
            lat[1] = 1.5707963267948966;
            allLongitudes = true;
        }
        if (!allLongitudes && (sinA = Math.sqrt(this.height * (2.0 - this.height))) <= (sinC = Math.cos(axisLatLng.lat().radians()))) {
            double angleA = Math.asin(sinA / sinC);
            lng[0] = Platform.IEEEremainder(axisLatLng.lng().radians() - angleA, Math.PI * 2);
            lng[1] = Platform.IEEEremainder(axisLatLng.lng().radians() + angleA, Math.PI * 2);
        }
        return new S2LatLngRect(new R1Interval(lat[0], lat[1]), new S1Interval(lng[0], lng[1]));
    }

    @Override
    public boolean contains(S2Cell cell) {
        S2Point[] vertices = new S2Point[4];
        for (int k = 0; k < 4; ++k) {
            vertices[k] = cell.getVertex(k);
            if (this.contains(vertices[k])) continue;
            return false;
        }
        return !this.complement().intersects(cell, vertices);
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        S2Point[] vertices = new S2Point[4];
        for (int k = 0; k < 4; ++k) {
            vertices[k] = cell.getVertex(k);
            if (!this.contains(vertices[k])) continue;
            return true;
        }
        return this.intersects(cell, vertices);
    }

    public boolean intersects(S2Cell cell, S2Point[] vertices) {
        if (this.height >= 1.0) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (cell.contains(this.axis)) {
            return true;
        }
        double sin2Angle = this.height * (2.0 - this.height);
        for (int k = 0; k < 4; ++k) {
            S2Point edge = cell.getEdgeRaw(k);
            double dot = this.axis.dotProd(edge);
            if (dot > 0.0) continue;
            if (dot * dot > sin2Angle * edge.norm2()) {
                return false;
            }
            S2Point dir = S2Point.crossProd(edge, this.axis);
            if (!(dir.dotProd(vertices[k]) < 0.0) || !(dir.dotProd(vertices[k + 1 & 3]) > 0.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(S2Point p) {
        return S2Point.sub(this.axis, p).norm2() <= 2.0 * this.height;
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2Cap)) {
            return false;
        }
        S2Cap other = (S2Cap)that;
        return this.axis.equalsPoint(other.axis) && this.height == other.height || this.isEmpty() && other.isEmpty() || this.isFull() && other.isFull();
    }

    public int hashCode() {
        if (this.isFull()) {
            return 17;
        }
        if (this.isEmpty()) {
            return 37;
        }
        int result = 17;
        result = 37 * result + this.axis.hashCode();
        long heightBits = Double.doubleToLongBits(this.height);
        result = 37 * result + (int)(heightBits >>> 32 ^ heightBits);
        return result;
    }

    boolean approxEquals(S2Cap other, double maxError) {
        return this.axis.aequal(other.axis, maxError) && Math.abs(this.height - other.height) <= maxError || this.isEmpty() && other.height <= maxError || other.isEmpty() && this.height <= maxError || this.isFull() && other.height >= 2.0 - maxError || other.isFull() && this.height >= 2.0 - maxError;
    }

    boolean approxEquals(S2Cap other) {
        return this.approxEquals(other, 1.0E-14);
    }

    public String toString() {
        String string = this.axis.toString();
        double d = this.height;
        return new StringBuilder(44 + String.valueOf(string).length()).append("[Point = ").append(string).append(" Height = ").append(d).append("]").toString();
    }

    public void encode(OutputStream os) throws IOException {
        this.encode(new LittleEndianOutput(os));
    }

    void encode(LittleEndianOutput os) throws IOException {
        this.axis.encode(os);
        os.writeDouble(this.height / 2.0);
    }

    public static S2Cap decode(InputStream is) throws IOException {
        return S2Cap.decode(new LittleEndianInput(is));
    }

    static S2Cap decode(LittleEndianInput is) throws IOException {
        S2Point axis = S2Point.decode(is);
        return S2Cap.fromAxisHeight(axis, 2.0 * is.readDouble());
    }
}

