/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.exception;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import javax.annotation.Nullable;

public class DatastoreException
extends Exception {
    private final RetryOptions retryOptions;
    private final DatastorePb.Error.ErrorCode errorCode;
    @Nullable
    private final ProblemCode problemCode;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isNeverRetryable() {
        return this.retryOptions() == RetryOptions.NOT_RETRYABLE || this.errorCode.equals((Object)DatastorePb.Error.ErrorCode.INTERNAL_ERROR);
    }

    public RetryOptions retryOptions() {
        return this.retryOptions;
    }

    public DatastoreException(String message, DatastorePb.Error.ErrorCode errorCode, @Nullable Throwable cause) {
        this(message, errorCode, null, cause, RetryOptions.DEFAULT);
    }

    private DatastoreException(String message, DatastorePb.Error.ErrorCode errorCode, @Nullable ProblemCode problemCode, @Nullable Throwable cause, RetryOptions retryOptions) {
        super((String)Preconditions.checkNotNull((Object)message), cause);
        this.errorCode = (DatastorePb.Error.ErrorCode)Preconditions.checkNotNull((Object)errorCode);
        this.problemCode = problemCode;
        this.retryOptions = retryOptions;
    }

    public DatastorePb.Error.ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public ProblemCode getProblemCode() {
        return this.problemCode;
    }

    public DatastoreException withProblemCode(ProblemCode problemCode) {
        return new DatastoreException(this.getMessage(), this.errorCode, (ProblemCode)((Object)Preconditions.checkNotNull((Object)((Object)problemCode))), this.getCause(), this.retryOptions);
    }

    public static class Builder {
        private RetryOptions retryOptions = RetryOptions.DEFAULT;
        private DatastorePb.Error.ErrorCode errorCode;
        @Nullable
        private ProblemCode problemCode;
        private String message;
        @Nullable
        private Throwable cause;

        public Builder forceNonRetryable() {
            Preconditions.checkArgument((this.retryOptions == RetryOptions.DEFAULT ? 1 : 0) != 0, (Object)"RetryOptions already set.");
            this.retryOptions = RetryOptions.NOT_RETRYABLE;
            return this;
        }

        public Builder continuation() {
            Preconditions.checkArgument((this.retryOptions == RetryOptions.DEFAULT ? 1 : 0) != 0, (Object)"RetryOptions already set.");
            this.retryOptions = RetryOptions.CONTINUATION;
            return this;
        }

        public Builder errorCode(DatastorePb.Error.ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder problemCode(ProblemCode problemCode) {
            this.problemCode = (ProblemCode)((Object)Preconditions.checkNotNull((Object)((Object)problemCode)));
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public DatastoreException build() {
            return new DatastoreException(this.message, this.errorCode, this.problemCode, this.cause, this.retryOptions);
        }
    }

    public static enum ProblemCode {
        MISSING_TRANSACTION_HANDLE,
        TRANSACTION_CONCURRENCY_ERROR,
        MISSING_STORAGE_FEATURE,
        INDEX_ALREADY_EXISTS,
        IAM_UNAVAILABLE,
        IAM_UNEXPECTED_RESPONSE,
        WRITE_PRECONDITION_FAILED_ALREADY_EXISTS,
        WRITE_PRECONDITION_FAILED_NOT_FOUND,
        WRITE_PRECONDITION_FAILED_FUTURE_BASE_VERSION,
        WRITE_PRECONDITION_FAILED_PAST_BASE_VERSION;

    }

    public static enum RetryOptions {
        DEFAULT,
        NOT_RETRYABLE,
        CONTINUATION;

    }
}

