/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.appidentity.dev;

import com.google.appengine.api.appidentity.AppIdentityServicePb;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalAppIdentityService
extends AbstractLocalRpcService {
    private static final Logger log = Logger.getLogger(LocalAppIdentityService.class.getName());
    public static final String PACKAGE = "app_identity_service";
    public static final String PRIVATE_KEY_PATH = "/com/google/appengine/api/appidentity/dev/testkey/private";
    public static final String PUBLIC_CERT_PATH = "/com/google/appengine/api/appidentity/dev/testkey/public-pem";
    private static final String KEY_NAME = "key";
    private RSAPrivateKey privateKey;
    private String publicCert;
    private Clock clock;
    private String defaultGcsBucketName;

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        try {
            InputStream in = LocalAppIdentityService.class.getResourceAsStream(PRIVATE_KEY_PATH);
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            String privateKeyBytes = new String(bytes, StandardCharsets.UTF_8);
            in = LocalAppIdentityService.class.getResourceAsStream(PUBLIC_CERT_PATH);
            bytes = new byte[in.available()];
            in.read(bytes);
            this.publicCert = new String(bytes, StandardCharsets.UTF_8);
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(BaseEncoding.base64().decode((CharSequence)CharMatcher.whitespace().removeFrom((CharSequence)privateKeyBytes)));
            KeyFactory fac = KeyFactory.getInstance("RSA");
            this.privateKey = (RSAPrivateKey)fac.generatePrivate(spec);
            this.defaultGcsBucketName = properties.get("appengine.default.gcs.bucket.name");
            if (this.defaultGcsBucketName == null) {
                this.defaultGcsBucketName = "app_default_bucket";
            }
            this.clock = context.getClock();
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException e) {
            throw new RuntimeException("Can not initialize app identity service.");
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public AppIdentityServicePb.SignForAppResponse signForApp(LocalRpcService.Status status, AppIdentityServicePb.SignForAppRequest request) throws Exception {
        AppIdentityServicePb.SignForAppResponse.Builder responseBuilder = AppIdentityServicePb.SignForAppResponse.newBuilder();
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(this.privateKey);
        signature.update(request.getBytesToSign().toByteArray());
        responseBuilder.setSignatureBytes(ByteString.copyFrom((byte[])signature.sign()));
        responseBuilder.setKeyName(KEY_NAME);
        return responseBuilder.build();
    }

    public AppIdentityServicePb.GetPublicCertificateForAppResponse getPublicCertificatesForApp(LocalRpcService.Status status, AppIdentityServicePb.GetPublicCertificateForAppRequest request) {
        AppIdentityServicePb.GetPublicCertificateForAppResponse.Builder responseBuilder = AppIdentityServicePb.GetPublicCertificateForAppResponse.newBuilder();
        responseBuilder.addPublicCertificateList(AppIdentityServicePb.PublicCertificate.newBuilder().setKeyName(KEY_NAME).setX509CertificatePem(this.publicCert));
        return responseBuilder.build();
    }

    public AppIdentityServicePb.GetServiceAccountNameResponse getServiceAccountName(LocalRpcService.Status status, AppIdentityServicePb.GetServiceAccountNameRequest request) {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        AppIdentityServicePb.GetServiceAccountNameResponse.Builder responseBuilder = AppIdentityServicePb.GetServiceAccountNameResponse.newBuilder();
        responseBuilder.setServiceAccountName(String.valueOf(environment.getAppId()).concat("@localhost"));
        return responseBuilder.build();
    }

    public AppIdentityServicePb.GetDefaultGcsBucketNameResponse getDefaultGcsBucketName(LocalRpcService.Status status, AppIdentityServicePb.GetDefaultGcsBucketNameRequest request) {
        AppIdentityServicePb.GetDefaultGcsBucketNameResponse.Builder responseBuilder = AppIdentityServicePb.GetDefaultGcsBucketNameResponse.newBuilder();
        responseBuilder.setDefaultGcsBucketName(this.defaultGcsBucketName);
        return responseBuilder.build();
    }

    public AppIdentityServicePb.GetAccessTokenResponse getAccessToken(LocalRpcService.Status status, AppIdentityServicePb.GetAccessTokenRequest request) {
        AppIdentityServicePb.GetAccessTokenResponse.Builder responseBuilder = AppIdentityServicePb.GetAccessTokenResponse.newBuilder();
        String token = null;
        try {
            token = this.getApplicationDefaultToken(request);
            if (token != null) {
                responseBuilder.setAccessToken(token);
                return responseBuilder.build();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.logp(Level.WARNING, "com.google.appengine.api.appidentity.dev.LocalAppIdentityService", "getAccessToken", "No Application Default credential, using an invalid token.  If needed, you may want to call the gcloud command: `gcloud auth application-default login`");
        StringBuilder builder = new StringBuilder();
        builder.append("InvalidToken");
        for (String scope : request.getScopeList()) {
            builder.append(":");
            builder.append(scope);
        }
        builder.append(":");
        builder.append(this.clock.getCurrentTime() % 10000L);
        responseBuilder.setAccessToken(builder.toString());
        responseBuilder.setExpirationTime(this.clock.getCurrentTime() / 1000L + 1800L);
        return responseBuilder.build();
    }

    String getApplicationDefaultToken(AppIdentityServicePb.GetAccessTokenRequest request) throws IOException {
        GoogleCredential credential = GoogleCredential.getApplicationDefault();
        if (credential.createScopedRequired() && !request.getScopeList().isEmpty()) {
            credential = credential.createScoped((Collection)request.getScopeList());
        }
        credential.refreshToken();
        return credential.getAccessToken();
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    RSAPrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

