/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry.stlib;

import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class STGeography {
    private final S2Point[] points;
    private final S2Polyline[] lines;
    private final S2Polygon[] polygons;

    private STGeography(S2Point[] points, S2Polyline[] lines, S2Polygon[] polygons) {
        this.points = points;
        this.lines = lines;
        this.polygons = polygons;
    }

    public Iterable<S2Point> points() {
        return Arrays.asList(this.points);
    }

    public Iterable<S2Polyline> lines() {
        return Arrays.asList(this.lines);
    }

    public Iterable<S2Polygon> polygons() {
        return Arrays.asList(this.polygons);
    }

    public int numPoints() {
        return this.points.length;
    }

    public int numLines() {
        return this.lines.length;
    }

    public int numPolygons() {
        return this.polygons.length;
    }

    public boolean isEmpty() {
        return this.numPoints() == 0 && this.numLines() == 0 && this.numPolygons() == 0;
    }

    public int dimension() {
        if (this.numPolygons() > 0) {
            return 2;
        }
        if (this.numLines() > 0) {
            return 1;
        }
        if (this.numPoints() > 0) {
            return 0;
        }
        return -1;
    }

    public static class Builder {
        private final List<S2Point> points = new ArrayList<S2Point>();
        private final List<S2Polyline> lines = new ArrayList<S2Polyline>();
        private final List<S2Polygon> polygons = new ArrayList<S2Polygon>();

        public Builder addPoint(S2Point point) {
            if (point != null) {
                this.points.add(point);
            }
            return this;
        }

        public Builder addLine(S2Polyline line) {
            if (line != null && line.numVertices() > 0) {
                this.lines.add(line);
            }
            return this;
        }

        public Builder addPolygon(S2Polygon polygon) {
            if (polygon != null && polygon.getNumVertices() > 0) {
                this.polygons.add(polygon);
            }
            return this;
        }

        public void clear() {
            this.points.clear();
            this.lines.clear();
            this.polygons.clear();
        }

        public STGeography build() {
            STGeography result = new STGeography(this.points.toArray(new S2Point[0]), this.lines.toArray(new S2Polyline[0]), this.polygons.toArray(new S2Polygon[0]));
            this.clear();
            return result;
        }
    }
}

