/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Loop;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polygon;
import com.google.appengine.repackaged.com.google.common.geometry.S2Polyline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@GwtCompatible(serializable=true)
public strictfp final class S2ConvexHullQuery {
    private static final double OFFSET_FOR_SINGLE_POINT_LOOP = 1.0E-15;
    private final S2LatLngRect.Builder bound = S2LatLngRect.Builder.empty();
    private final List<S2Point> points = new ArrayList<S2Point>();

    public void addPoint(S2Point point) {
        this.bound.addPoint(point);
        this.points.add(point);
    }

    public void addPolyline(S2Polyline polyline) {
        this.bound.union(polyline.getRectBound());
        this.points.addAll(polyline.vertices());
    }

    public void addLoop(S2Loop loop) {
        if (loop.depth() != 0) {
            return;
        }
        this.bound.union(loop.getRectBound());
        if (loop.isEmptyOrFull()) {
            return;
        }
        for (int i = 0; i < loop.numVertices(); ++i) {
            this.points.add(loop.vertex(i));
        }
    }

    public void addPolygon(S2Polygon polygon) {
        for (int i = 0; i < polygon.numLoops(); ++i) {
            this.addLoop(polygon.loop(i));
        }
    }

    public S2Cap getCapBound() {
        return this.bound.getCapBound();
    }

    public S2Loop getConvexHull() {
        S2Cap cap = this.getCapBound();
        if (cap.height() >= 1.0) {
            return S2Loop.full();
        }
        S2Point origin = cap.axis().ortho();
        Collections.sort(this.points, new OrderedCcwAround(origin));
        ImmutableSet uniquePoints = ImmutableSet.copyOf(this.points);
        this.points.clear();
        this.points.addAll((Collection<S2Point>)uniquePoints);
        if (this.points.size() < 3) {
            if (this.points.isEmpty()) {
                return S2Loop.empty();
            }
            if (this.points.size() == 1) {
                return S2ConvexHullQuery.getSinglePointLoop(this.points.get(0));
            }
            return S2ConvexHullQuery.getSingleEdgeLoop(this.points.get(0), this.points.get(1));
        }
        Preconditions.checkState((S2.robustCCW(origin, this.points.get(0), (S2Point)Iterables.getLast(this.points)) >= 0 ? 1 : 0) != 0);
        List<S2Point> lower = S2ConvexHullQuery.getMonotoneChain(this.points);
        List<S2Point> upper = S2ConvexHullQuery.getMonotoneChain(Lists.reverse(this.points));
        Preconditions.checkState((boolean)lower.get(0).equals(Iterables.getLast(upper)));
        Preconditions.checkState((boolean)((S2Point)Iterables.getLast(lower)).equals(upper.get(0)));
        lower.remove(lower.size() - 1);
        upper.remove(upper.size() - 1);
        lower.addAll(upper);
        return new S2Loop(lower);
    }

    private static List<S2Point> getMonotoneChain(List<S2Point> points) {
        ArrayList<S2Point> output = new ArrayList<S2Point>();
        for (S2Point p : points) {
            while (output.size() >= 2 && S2.robustCCW((S2Point)output.get(output.size() - 2), (S2Point)Iterables.getLast(output), p) <= 0) {
                output.remove(output.size() - 1);
            }
            output.add(p);
        }
        return output;
    }

    private static S2Loop getSinglePointLoop(S2Point p) {
        S2Point d0 = S2.ortho(p);
        S2Point d1 = S2Point.crossProd(p, d0);
        return new S2Loop((List<S2Point>)ImmutableList.of((Object)p, (Object)S2Point.normalize(S2Point.add(p, S2Point.mul(d0, 1.0E-15))), (Object)S2Point.normalize(S2Point.add(p, S2Point.mul(d1, 1.0E-15)))));
    }

    private static S2Loop getSingleEdgeLoop(S2Point a, S2Point b) {
        S2Loop loop = new S2Loop((List<S2Point>)ImmutableList.of((Object)a, (Object)b, (Object)S2Point.normalize(S2Point.add(a, b))));
        loop.normalize();
        return loop;
    }

    private strictfp static final class OrderedCcwAround
    implements Comparator<S2Point> {
        private final S2Point center;

        OrderedCcwAround(S2Point center) {
            this.center = center;
        }

        @Override
        public int compare(S2Point x, S2Point y) {
            if (this.lessThan(x, y)) {
                return -1;
            }
            if (this.lessThan(y, x)) {
                return 1;
            }
            return 0;
        }

        private boolean lessThan(S2Point x, S2Point y) {
            return S2.robustCCW(this.center, x, y) > 0;
        }
    }
}

