/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.api.socket.SocketServicePb;
import com.google.appengine.api.socket.dev.LocalDatagramSocket;
import com.google.appengine.api.socket.dev.LocalSocket;
import com.google.appengine.api.socket.dev.LocalStreamSocket;
import com.google.appengine.api.socket.dev.SocketPermissions;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LocalSocketService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "remote_socket";
    public static final String PERMIT_CONNECT = "socket.permit_connect";
    public static final String PERMIT_BIND = "socket.permit_bind";
    public static final String PERMIT_LISTEN = "socket.permit_listen";
    public static final String PERMIT_SET_SOCKET_OPT = "socket.permit_setsocketopt";
    public static final String PERMIT_GET_SOCKET_OPT = "socket.permit_getsocketopt";
    public static final String SOCKET_OPTIONS_SPEC_OPT = "socket.socket_options";
    private static final Double API_DEADLINE = 60.0;
    private final Map<String, LocalSocket> sockets = Collections.synchronizedMap(new HashMap());

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        SocketPermissions.setDefaultSocketPermissions(properties.get(PERMIT_BIND), properties.get(PERMIT_LISTEN), properties.get(PERMIT_CONNECT), properties.get(PERMIT_SET_SOCKET_OPT), properties.get(PERMIT_GET_SOCKET_OPT), properties.get(SOCKET_OPTIONS_SPEC_OPT));
    }

    public void start() {
    }

    public void stop() {
        for (LocalSocket localSocket : this.sockets.values().toArray(new LocalSocket[0])) {
            if (localSocket == null) continue;
            localSocket.close();
        }
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return API_DEADLINE;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return API_DEADLINE;
    }

    LocalSocket newLocalSocket(boolean isStream) {
        LocalSocket localSocket;
        LocalSocket localSocket2 = localSocket = isStream ? new LocalStreamSocket(this) : new LocalDatagramSocket(this);
        if (this.sockets.put(localSocket.getSocketDescriptor(), localSocket) != null) {
            throw new IllegalStateException("Internal error: Local socket descriptor collision.");
        }
        return localSocket;
    }

    private LocalSocket getLocalSocket(String socketDescriptor) {
        LocalSocket socket = this.sockets.get(socketDescriptor);
        if (socket == null) {
            throw new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.SOCKET_CLOSED.getValue(), "Socket closed");
        }
        return socket;
    }

    private <T extends ProtocolMessage<T>> void validateRequired(ProtocolMessage<T> request) {
        if (!request.isInitialized()) {
            String string = String.valueOf(request.findInitializationError());
            throw new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE.getValue(), string.length() != 0 ? "Missing required field in request:".concat(string) : new String("Missing required field in request:"));
        }
    }

    public SocketServicePb.CreateSocketReply createSocket(LocalRpcService.Status status, SocketServicePb.CreateSocketRequest request) {
        this.validateRequired((ProtocolMessage)request);
        LocalSocket localSocket = this.newLocalSocket(request.getProtocolEnum() == SocketServicePb.CreateSocketRequest.SocketProtocol.TCP);
        return localSocket.createSocket(request);
    }

    public SocketServicePb.PollReply poll(LocalRpcService.Status status, SocketServicePb.PollRequest request) {
        throw new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE.getValue(), "Not yet implimented");
    }

    public SocketServicePb.ResolveReply resolve(LocalRpcService.Status status, SocketServicePb.ResolveRequest request) {
        throw new ApiProxy.ApplicationException(SocketServicePb.RemoteSocketServiceError.ErrorCode.FAILURE.getValue(), "Not yet implimented");
    }

    public SocketServicePb.BindReply bind(LocalRpcService.Status status, SocketServicePb.BindRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).bind(request);
    }

    public SocketServicePb.GetSocketNameReply getSocketName(LocalRpcService.Status status, SocketServicePb.GetSocketNameRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).getSocketName(request);
    }

    public SocketServicePb.GetPeerNameReply getPeerName(LocalRpcService.Status status, SocketServicePb.GetPeerNameRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).getPeerName(request);
    }

    public SocketServicePb.SetSocketOptionsReply setSocketOptions(LocalRpcService.Status status, SocketServicePb.SetSocketOptionsRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).setSocketOptions(request);
    }

    public SocketServicePb.GetSocketOptionsReply getSocketOptions(LocalRpcService.Status status, SocketServicePb.GetSocketOptionsRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).getSocketOptions(request);
    }

    public SocketServicePb.ConnectReply connect(LocalRpcService.Status status, SocketServicePb.ConnectRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).connect(request);
    }

    public SocketServicePb.ListenReply listen(LocalRpcService.Status status, SocketServicePb.ListenRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).listen(request);
    }

    public SocketServicePb.AcceptReply accept(LocalRpcService.Status status, SocketServicePb.AcceptRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).accept(request);
    }

    public SocketServicePb.ShutDownReply shutDown(LocalRpcService.Status status, SocketServicePb.ShutDownRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).shutDown(request);
    }

    public SocketServicePb.CloseReply close(LocalRpcService.Status status, SocketServicePb.CloseRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).close(request);
    }

    public SocketServicePb.SendReply send(LocalRpcService.Status status, SocketServicePb.SendRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).send(request);
    }

    public SocketServicePb.ReceiveReply receive(LocalRpcService.Status status, SocketServicePb.ReceiveRequest request) {
        return this.getLocalSocket(request.getSocketDescriptor()).receive(request);
    }

    void removeSocket(String socketDescriptor) {
        this.sockets.remove(socketDescriptor);
    }
}

