/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.Real;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import java.io.PrintStream;
import java.util.logging.Logger;

@GwtCompatible(emulated=true)
final class Platform {
    private Platform() {
    }

    static double IEEEremainder(double f1, double f2) {
        return Math.IEEEremainder(f1, f2);
    }

    static int getExponent(double d) {
        return Math.getExponent(d);
    }

    static Logger getLoggerForClass(Class<?> clazz) {
        return Logger.getLogger(clazz.getCanonicalName());
    }

    static void printf(PrintStream stream, String format, Object ... params) {
        stream.printf(format, params);
    }

    static String formatString(String format, Object ... params) {
        return String.format(format, params);
    }

    public static long doubleHash(double value) {
        return Double.doubleToLongBits(value);
    }

    public static int sign(S2Point a, S2Point b, S2Point c) {
        Real bycz = Real.mul(b.y, c.z);
        Real bzcy = Real.mul(b.z, c.y);
        Real bzcx = Real.mul(b.z, c.x);
        Real bxcz = Real.mul(b.x, c.z);
        Real bxcy = Real.mul(b.x, c.y);
        Real bycx = Real.mul(b.y, c.x);
        Real bcx = bycz.sub(bzcy);
        Real bcy = bzcx.sub(bxcz);
        Real bcz = bxcy.sub(bycx);
        Real x = bcx.mul(a.x);
        Real y = bcy.mul(a.y);
        Real z = bcz.mul(a.z);
        return x.add(y).add(z).signum();
    }

    public static double ulp(double x) {
        return Math.ulp(x);
    }

    public static double nextAfter(double x, double dir) {
        return Math.nextAfter(x, dir);
    }
}

